/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Dialog;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.ServerNodeProvider;
import org.netbeans.modules.db.mysql.ui.AdminPropertiesPanel;
import org.netbeans.modules.db.mysql.ui.BasePropertiesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesDialog {
    private static final Logger LOGGER = Logger.getLogger(PropertiesDialog.class.getName());
    private static final String HELP_CTX = PropertiesDialog.class.getName();
    private final JTabbedPane tabbedPane;
    private final BasePropertiesPanel basePanel;
    private final AdminPropertiesPanel adminPanel;
    private final DatabaseServer server;

    public PropertiesDialog(DatabaseServer server) {
        this.server = server;
        this.basePanel = new BasePropertiesPanel(server);
        this.adminPanel = new AdminPropertiesPanel(server);
        this.tabbedPane = PropertiesDialog.createTabbedPane(this.basePanel, this.adminPanel);
    }

    public boolean displayDialog() {
        return this.displayDialog(Tab.BASIC);
    }

    public boolean displayDialog(Tab focusTab) {
        boolean ok;
        DialogDescriptor descriptor = this.createDialogDescriptor();
        if (focusTab == Tab.ADMIN) {
            this.tabbedPane.setSelectedIndex(1);
        }
        if (ok = this.displayDialog(descriptor)) {
            this.updateServer();
        }
        return ok;
    }

    private static JTabbedPane createTabbedPane(JPanel basePanel, JPanel adminPanel) {
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab(PropertiesDialog.getMessage("PropertiesDialog.BasePanelTitle"), null, basePanel, PropertiesDialog.getMessage("PropertiesDialog.BasePanelHint"));
        tabbedPane.addTab(PropertiesDialog.getMessage("PropertiesDialog.AdminPanelTitle"), null, adminPanel, PropertiesDialog.getMessage("PropertiesDialog.AdminPanelHint"));
        tabbedPane.getAccessibleContext().setAccessibleName(PropertiesDialog.getMessage("PropertiesDialog.ACS_Name"));
        tabbedPane.getAccessibleContext().setAccessibleDescription(PropertiesDialog.getMessage("PropertiesDialog.ACS_Desc"));
        return tabbedPane;
    }

    private DialogDescriptor createDialogDescriptor() {
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.tabbedPane, PropertiesDialog.getMessage("PropertiesDialog.Title"));
        descriptor.setHelpCtx(new HelpCtx(HELP_CTX));
        this.basePanel.setDialogDescriptor(descriptor);
        this.adminPanel.setDialogDescriptor(descriptor);
        return descriptor;
    }

    private boolean displayDialog(DialogDescriptor descriptor) {
        assert (SwingUtilities.isEventDispatchThread());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        dialog.dispose();
        return DialogDescriptor.OK_OPTION.equals(descriptor.getValue());
    }

    private void updateServer() {
        ServerNodeProvider provider;
        if (!this.basePanel.getHost().equals(this.server.getHost())) {
            this.server.setHost(this.basePanel.getHost());
        }
        if (!this.basePanel.getPort().equals(this.server.getPort())) {
            this.server.setPort(this.basePanel.getPort());
        }
        if (!this.basePanel.getUser().equals(this.server.getUser())) {
            this.server.setUser(this.basePanel.getUser());
        }
        if (!this.basePanel.getPassword().equals(this.server.getPassword())) {
            this.server.setPassword(this.basePanel.getPassword());
        }
        if (this.basePanel.getSavePassword() != this.server.isSavePassword()) {
            this.server.setSavePassword(this.basePanel.getSavePassword());
        }
        if (!this.adminPanel.getAdminPath().equals(this.server.getAdminPath())) {
            this.server.setAdminPath(this.adminPanel.getAdminPath());
        }
        if (!this.adminPanel.getAdminArgs().equals(this.server.getAdminArgs())) {
            this.server.setAdminArgs(this.adminPanel.getAdminArgs());
        }
        if (!this.adminPanel.getStartPath().equals(this.server.getStartPath())) {
            this.server.setStartPath(this.adminPanel.getStartPath());
        }
        if (!this.adminPanel.getStartArgs().equals(this.server.getStartArgs())) {
            this.server.setStartArgs(this.adminPanel.getStartArgs());
        }
        if (!this.adminPanel.getStopPath().equals(this.server.getStopPath())) {
            this.server.setStopPath(this.adminPanel.getStopPath());
        }
        if (!this.adminPanel.getStopArgs().equals(this.server.getStopArgs())) {
            this.server.setStopArgs(this.adminPanel.getStopArgs());
        }
        if (!(provider = ServerNodeProvider.getDefault()).isRegistered()) {
            provider.setRegistered(true);
        }
    }

    private static String getMessage(String id) {
        return NbBundle.getMessage(PropertiesDialog.class, (String)id);
    }

    public static enum Tab {
        BASIC,
        ADMIN;

    }
}

