/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class MessageDigestAlgorithm
extends Algorithm {
    public static final String ALGO_ID_DIGEST_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String ALGO_ID_DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String ALGO_ID_DIGEST_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String ALGO_ID_DIGEST_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String ALGO_ID_DIGEST_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ALGO_ID_DIGEST_RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    MessageDigest algorithm = null;
    static ThreadLocal instances = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    private MessageDigestAlgorithm(Document document, MessageDigest messageDigest, String string2) {
        super(document, string2);
        this.algorithm = messageDigest;
    }

    public static MessageDigestAlgorithm getInstance(Document document, String string2) throws XMLSignatureException {
        MessageDigest messageDigest = MessageDigestAlgorithm.getDigestInstance(string2);
        return new MessageDigestAlgorithm(document, messageDigest, string2);
    }

    private static MessageDigest getDigestInstance(String string2) throws XMLSignatureException {
        MessageDigest messageDigest;
        MessageDigest messageDigest2 = (MessageDigest)((Map)instances.get()).get(string2);
        if (messageDigest2 != null) {
            return messageDigest2;
        }
        String string3 = JCEMapper.translateURItoJCEID(string2);
        if (string3 == null) {
            Object[] objectArray = new Object[]{string2};
            throw new XMLSignatureException("algorithms.NoSuchMap", objectArray);
        }
        String string4 = JCEMapper.getProviderId();
        try {
            messageDigest = string4 == null ? MessageDigest.getInstance(string3) : MessageDigest.getInstance(string3, string4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string3, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string3, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        ((Map)instances.get()).put(string2, messageDigest);
        return messageDigest;
    }

    public MessageDigest getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return MessageDigest.isEqual(byArray, byArray2);
    }

    public byte[] digest() {
        return this.algorithm.digest();
    }

    public byte[] digest(byte[] byArray) {
        return this.algorithm.digest(byArray);
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.algorithm.digest(byArray, n, n2);
    }

    public String getJCEAlgorithmString() {
        return this.algorithm.getAlgorithm();
    }

    public Provider getJCEProvider() {
        return this.algorithm.getProvider();
    }

    public int getDigestLength() {
        return this.algorithm.getDigestLength();
    }

    public void reset() {
        this.algorithm.reset();
    }

    public void update(byte[] byArray) {
        this.algorithm.update(byArray);
    }

    public void update(byte by) {
        this.algorithm.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.algorithm.update(byArray, n, n2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "DigestMethod";
    }
}

