/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class DeleteAction
extends SystemAction {
    public DeleteAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        final DesignDocument activeDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (activeDocument == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                activeDocument.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        DeleteSupport.invokeDirectUserDeletion(activeDocument, activeDocument.getSelectedComponents(), true);
                    }
                });
            }
        });
    }

    public boolean isEnabled() {
        final DesignDocument activeDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (activeDocument == null) {
            return false;
        }
        final boolean[] ret = new boolean[1];
        activeDocument.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ret[0] = DeleteSupport.canDeleteAsUser(activeDocument, activeDocument.getSelectedComponents());
            }
        });
        return ret[0];
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return NbBundle.getMessage(DeleteAction.class, (String)"NAME_DeleteAction");
    }
}

