/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.AddressRangeSet;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfArangesSection
extends ElfSection {
    private final ArrayList<AddressRangeSet> addressRangeSets = new ArrayList();

    public DwarfArangesSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
    }

    void addAddressRangeSet(AddressRangeSet addressRangeSet) {
        this.addressRangeSets.add(addressRangeSet);
    }

    public ArrayList<AddressRangeSet> getAddressRangeSets() {
        if (this.addressRangeSets.isEmpty()) {
            try {
                this.read();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.addressRangeSets;
    }

    @Override
    public DwarfArangesSection read() throws IOException {
        long sectionStart = this.header.getSectionOffset();
        long sectionEnd = this.header.getSectionSize() + sectionStart;
        this.reader.seek(sectionStart);
        while (this.reader.getFilePointer() != sectionEnd) {
            long length;
            long address;
            int multTupleSize;
            AddressRangeSet addressRangeSet = new AddressRangeSet();
            addressRangeSet.length = this.reader.readInt();
            addressRangeSet.version = this.reader.readShort();
            addressRangeSet.info_offset = this.reader.readInt();
            addressRangeSet.address_size = (byte)(0xFF & this.reader.readByte());
            addressRangeSet.segment_descriptor_size = (byte)(0xFF & this.reader.readByte());
            int hLength = 12;
            for (multTupleSize = addressRangeSet.address_size * 2; multTupleSize < hLength; multTupleSize <<= 1) {
            }
            this.reader.skipBytes(multTupleSize - hLength);
            do {
                address = this.reader.readNumber(addressRangeSet.address_size);
                length = this.reader.readNumber(addressRangeSet.address_size);
                addressRangeSet.addRange(address, length);
            } while (address != 0L || length != 0L);
            this.addAddressRangeSet(addressRangeSet);
        }
        return this;
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        for (AddressRangeSet addressRangeSet : this.getAddressRangeSets()) {
            addressRangeSet.dump(out);
        }
        out.println();
    }
}

