/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.spi.LaunchConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class Workspace {
    private static final Logger logger = Logger.getLogger(Workspace.class.getName());
    private static final String RUNTIME_SETTINGS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/";
    static final String CORE_PREFERENCE = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.core.prefs";
    static final String RESOURCES_PREFERENCE = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs";
    static final String LAUNCHING_PREFERENCES = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.launching.prefs";
    static final String RESOURCE_PROJECTS_DIR = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    static final String DEFAULT_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    static final String USER_JSF_LIBRARIES = ".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml";
    private File corePrefFile;
    private File resourcesPrefFile;
    private File launchingPrefsFile;
    private File resourceProjectsDir;
    private File workspaceDir;
    private File userJSFLibraries;
    private Set<Variable> variables = new HashSet<Variable>();
    private Set<Variable> resourcesVariables = new HashSet<Variable>();
    private Set<EclipseProject> projects = new HashSet<EclipseProject>();
    private Map<String, String> jreContainers;
    private Map<String, List<String>> userLibraries;
    private Map<String, List<String>> userLibraryJavadocs;
    private Map<String, List<String>> userLibrarySources;
    private Collection<LaunchConfiguration> launchConfigurations;
    private boolean myEclipseLibrariesLoaded;

    static Workspace createWorkspace(File workspaceDir) {
        if (!EclipseUtils.isRegularWorkSpace(workspaceDir)) {
            ErrorManager.getDefault().log(1, "There is not a regular workspace in " + workspaceDir);
            return null;
        }
        Workspace workspace = new Workspace(workspaceDir);
        return workspace;
    }

    Workspace(File workspaceDir) {
        this.workspaceDir = workspaceDir;
        this.corePrefFile = new File(workspaceDir, CORE_PREFERENCE);
        this.resourcesPrefFile = new File(workspaceDir, RESOURCES_PREFERENCE);
        this.launchingPrefsFile = new File(workspaceDir, LAUNCHING_PREFERENCES);
        this.resourceProjectsDir = new File(workspaceDir, RESOURCE_PROJECTS_DIR);
        this.userJSFLibraries = new File(workspaceDir, USER_JSF_LIBRARIES);
    }

    File getUserJSFLibraries() {
        return this.userJSFLibraries;
    }

    public File getDirectory() {
        return this.workspaceDir;
    }

    File getCorePreferenceFile() {
        return this.corePrefFile;
    }

    File getResourcesPreferenceFile() {
        return this.resourcesPrefFile;
    }

    File getLaunchingPrefsFile() {
        return this.launchingPrefsFile;
    }

    File getResourceProjectsDir() {
        return this.resourceProjectsDir;
    }

    void addVariable(Variable var) {
        this.variables.add(var);
    }

    void addResourcesVariable(Variable var) {
        this.resourcesVariables.add(var);
    }

    Set<Variable> getVariables() {
        return this.variables;
    }

    Set<Variable> getResourcesVariables() {
        return this.resourcesVariables;
    }

    void loadMyEclipseLibraries(List<String> importProblems) {
        if (!this.myEclipseLibrariesLoaded) {
            File f;
            this.myEclipseLibrariesLoaded = true;
            String path = null;
            for (Variable v : this.getVariables()) {
                int start;
                if (!v.getName().startsWith("MYECLIPSE_") || !v.getName().endsWith("_HOME") || (start = v.getLocation().replace('\\', '/').indexOf("/plugins/")) == -1) continue;
                path = v.getLocation().substring(0, start + 8);
                break;
            }
            if (path == null) {
                Variable v = this.getVariable("ECLIPSE_HOME");
                if (v == null) {
                    importProblems.add(NbBundle.getMessage(Workspace.class, (String)"MSG_CannotReadMyEclipseLibs"));
                    return;
                }
                path = new File(new File(v.getLocation()), "plugins").getPath();
            }
            if (!(f = new File(path)).exists()) {
                importProblems.add(NbBundle.getMessage(Workspace.class, (String)"MSG_CannotReadMyEclipseLibs"));
                return;
            }
            this.scanForLibraries(f);
        }
    }

    private void scanForLibraries(File dir) {
        File[] kids;
        assert (dir.isDirectory()) : dir;
        for (File kid : kids = dir.listFiles()) {
            File f;
            if (!kid.isDirectory() || !(f = new File(kid, "preferences.ini")).exists()) continue;
            this.analyzePreferencesIniFile(f);
        }
    }

    private void analyzePreferencesIniFile(File f) {
        Properties p = new Properties();
        EclipseUtils.tryLoad(p, f);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith("melibrary.com.genuitec.eclipse.") || !key.endsWith(".classpath")) continue;
            List<String> jars = this.parseLibDefinition(value);
            int end = key.indexOf(".classpath");
            int index = key.indexOf(".MYECLIPSE_");
            if (index == -1) {
                index = key.substring(0, end).lastIndexOf(".");
                if (index != -1) {
                    ++index;
                }
            } else {
                index += 11;
            }
            assert (index != -1) : key;
            String libName = key.substring(index, end);
            this.addUserLibrary(libName, jars, null, null);
        }
    }

    private List<String> parseLibDefinition(String s) {
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            String[] ss;
            Variable var;
            String token = st.nextToken();
            int index = token.indexOf("(");
            if (index != -1) {
                token = token.substring(0, index);
            }
            if ((var = this.getVariable((ss = EclipseUtils.splitVariable(token))[0])) != null) {
                token = var.getLocation() + ss[1];
            }
            res.add(token);
        }
        return res;
    }

    public Variable getVariable(String rawPath) {
        for (Variable variable : this.getVariables()) {
            if (!variable.getName().equals(rawPath)) continue;
            return variable;
        }
        return null;
    }

    void setJREContainers(Map<String, String> jreContainers) {
        this.jreContainers = jreContainers;
    }

    void addProject(EclipseProject project) {
        this.projects.add(project);
    }

    void addUserLibrary(String libName, List<String> jars, List<String> javadoc, List<String> sources) {
        if (this.userLibraries == null) {
            this.userLibraries = new HashMap<String, List<String>>();
            this.userLibraryJavadocs = new HashMap<String, List<String>>();
            this.userLibrarySources = new HashMap<String, List<String>>();
        }
        this.userLibraries.put(libName, jars);
        if (javadoc != null) {
            this.userLibraryJavadocs.put(libName, javadoc);
        }
        if (sources != null) {
            this.userLibrarySources.put(libName, sources);
        }
    }

    Map<String, List<String>> getUserLibraries() {
        return this.userLibraries;
    }

    List<URL> getJarsForUserLibrary(String libRawPath) {
        if (this.userLibraries != null && this.userLibraries.get(libRawPath) != null) {
            List<String> jars = this.userLibraries.get(libRawPath);
            ArrayList<URL> urls = new ArrayList<URL>(jars.size());
            for (String jar : jars) {
                try {
                    File f = new File(jar);
                    URL url = f.toURI().toURL();
                    if (f.isFile()) {
                        url = FileUtil.getArchiveRoot((URL)url);
                    }
                    urls.add(url);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return urls;
        }
        return Collections.emptyList();
    }

    private URL convertPathToURL(String path, List<String> importProblems, String libName) {
        try {
            File f = new File(path);
            URL u = f.toURI().toURL();
            if (!f.exists()) {
                importProblems.add(NbBundle.getMessage(Workspace.class, (String)"MSG_CannotFindLibrarySources", (Object)path, (Object)libName));
                return null;
            }
            boolean isFolder = f.isDirectory();
            if (isFolder) {
                if (!u.toExternalForm().endsWith("/")) {
                    u = new URL(u.toExternalForm() + "/");
                }
            } else if (!"jar".equals(u.getProtocol())) {
                u = FileUtil.getArchiveRoot((URL)u);
            }
            return u;
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    List<URL> getJavadocForUserLibrary(String libRawPath, List<String> importProblems) {
        if (this.userLibraryJavadocs != null && this.userLibraryJavadocs.get(libRawPath) != null) {
            List<String> jars = this.userLibraryJavadocs.get(libRawPath);
            ArrayList<URL> urls = new ArrayList<URL>(jars.size());
            for (String path : jars) {
                String resolvedPath = EclipseProject.resolveJavadocLocationAttribute(path, this, importProblems, true);
                if (resolvedPath != null) {
                    try {
                        urls.add(new URL(resolvedPath));
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                URL u = this.convertPathToURL(path, importProblems, libRawPath);
                if (u == null) continue;
                urls.add(u);
            }
            return urls;
        }
        return null;
    }

    List<URL> getSourcesForUserLibrary(String libRawPath, List<String> importProblems) {
        if (this.userLibrarySources != null && this.userLibrarySources.get(libRawPath) != null) {
            List<String> jars = this.userLibrarySources.get(libRawPath);
            ArrayList<URL> urls = new ArrayList<URL>(jars.size());
            for (String path : jars) {
                URL u;
                String resolvedPath = EclipseProject.resolveSourcePathAttribute(path, this, false);
                if (resolvedPath != null) {
                    path = resolvedPath;
                }
                if ((u = this.convertPathToURL(path, importProblems, libRawPath)) == null) continue;
                urls.add(u);
            }
            return urls;
        }
        return null;
    }

    EclipseProject getProjectByRawPath(String rawPath) {
        EclipseProject project = null;
        for (EclipseProject prj : this.projects) {
            if (!prj.getName().equals(rawPath.substring(1))) continue;
            project = prj;
        }
        if (project == null) {
            logger.info("Project with raw path \"" + rawPath + "\" cannot" + " be found in project list: " + this.projects);
        }
        return project;
    }

    public Set<EclipseProject> getProjects() {
        return this.projects;
    }

    EclipseProject getProjectByProjectDir(File projectDir) {
        for (EclipseProject project : this.projects) {
            if (!project.getDirectory().equals(projectDir)) continue;
            return project;
        }
        return null;
    }

    EclipseProject getProjectByName(String projectName) {
        for (EclipseProject project : this.projects) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    String getJDKDirectory(String jreContainer) {
        if (jreContainer != null) {
            if (!DEFAULT_JRE_CONTAINER.equals(jreContainer)) {
                jreContainer = jreContainer.substring(jreContainer.lastIndexOf(47) + 1);
            }
            for (Map.Entry<String, String> entry : this.jreContainers.entrySet()) {
                if (!entry.getKey().equals(jreContainer)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public Collection<LaunchConfiguration> getLaunchConfigurations() {
        return this.launchConfigurations;
    }

    void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        this.launchConfigurations = launchConfigurations;
    }

    public static class Variable {
        private String name;
        private String location;
        private boolean fileVar;
        private String file;

        public Variable(String name, String location) {
            this.name = name;
            this.location = location;
            File f = new File(location);
            boolean bl = this.fileVar = f.exists() && f.isFile();
            if (this.fileVar) {
                this.file = f.getName();
                this.location = f.getParentFile().getAbsolutePath();
            }
        }

        String getName() {
            return this.name;
        }

        String getLocation() {
            return this.location;
        }

        public String getFileName() {
            return this.file;
        }

        public String toString() {
            return this.name + " = " + this.location;
        }

        public boolean isFileVariable() {
            return this.fileVar;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Variable)) {
                return false;
            }
            Variable var = (Variable)obj;
            if (this.name != null ? !this.name.equals(var.name) : var.name != null) {
                return false;
            }
            return !(this.location != null ? !this.location.equals(var.location) : var.location != null);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + System.identityHashCode(this.name);
            result = 37 * result + System.identityHashCode(this.location);
            return result;
        }
    }
}

