/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.zip;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;
import org.pentaho.reporting.libraries.resourceloader.loader.zip.ZipEntryKey;
import org.pentaho.reporting.libraries.resourceloader.loader.zip.ZipResourceData;

public class ZipResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey resourceKey) {
        return ZipResourceLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        if (!(object instanceof ZipEntryKey)) {
            return null;
        }
        ZipEntryKey zipEntryKey = (ZipEntryKey)object;
        ResourceKey resourceKey = zipEntryKey.getZipFile().getKey();
        return new ResourceKey(resourceKey, ZipResourceLoader.class.getName(), zipEntryKey.getEntryName(), map);
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        HashMap hashMap;
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String string2 = string != null ? LoaderUtils.mergePaths((String)resourceKey.getIdentifier(), string) : (String)resourceKey.getIdentifier();
        if (map != null) {
            hashMap = new HashMap();
            hashMap.putAll(resourceKey.getFactoryParameters());
            hashMap.putAll(map);
        } else {
            hashMap = resourceKey.getFactoryParameters();
        }
        return new ResourceKey(resourceKey.getParent(), resourceKey.getSchema(), string2, hashMap);
    }

    public URL toURL(ResourceKey resourceKey) {
        return null;
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new ZipResourceData(resourceKey);
    }
}

