/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.zip;

import java.io.File;
import java.net.URL;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ZipEntryKey {
    private ResourceData zipFile;
    private String entryName;

    public ZipEntryKey(ResourceData resourceData, String string) {
        if (resourceData == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.zipFile = resourceData;
        this.entryName = string;
    }

    public ZipEntryKey(ResourceManager resourceManager, String string, String string2) throws ResourceKeyCreationException, ResourceLoadingException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.zipFile = resourceManager.load(resourceManager.createKey(string));
        this.entryName = string2;
    }

    public ZipEntryKey(ResourceManager resourceManager, URL uRL, String string) throws ResourceKeyCreationException, ResourceLoadingException {
        if (uRL == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.zipFile = resourceManager.load(resourceManager.createKey(uRL));
        this.entryName = string;
    }

    public ZipEntryKey(ResourceManager resourceManager, File file, String string) throws ResourceKeyCreationException, ResourceLoadingException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.zipFile = resourceManager.load(resourceManager.createKey(file));
        this.entryName = string;
    }

    public ResourceData getZipFile() {
        return this.zipFile;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ZipEntryKey zipEntryKey = (ZipEntryKey)object;
        if (!this.entryName.equals(zipEntryKey.entryName)) {
            return false;
        }
        return this.zipFile.getKey().equals(zipEntryKey.zipFile.getKey());
    }

    public int hashCode() {
        int n = this.zipFile.getKey().hashCode();
        n = 29 * n + this.entryName.hashCode();
        return n;
    }
}

