/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.truetype.ScalableTrueTypeFontMetrics;

public class TrueTypeFontMetrics
implements FontMetrics {
    private ScalableTrueTypeFontMetrics fontMetrics;
    private double fontSize;

    public TrueTypeFontMetrics(ScalableTrueTypeFontMetrics scalableTrueTypeFontMetrics, double d) {
        if (scalableTrueTypeFontMetrics == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.fontMetrics = scalableTrueTypeFontMetrics;
        this.fontSize = d;
    }

    public boolean isUniformFontMetrics() {
        return true;
    }

    public long getAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getAscent());
    }

    public long getDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getDescent());
    }

    public long getLeading() {
        return (long)(this.fontSize * (double)this.fontMetrics.getLeading());
    }

    public long getXHeight() {
        return (long)(this.fontSize * (double)this.fontMetrics.getXHeight());
    }

    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, StrictGeomUtility.toInternalValue(this.fontSize) / 20L);
    }

    public long getUnderlinePosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getUnderlinePosition());
    }

    public long getStrikeThroughPosition() {
        return (long)(this.fontSize * (double)this.fontMetrics.getStrikeThroughPosition());
    }

    public long getMaxAscent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxAscent());
    }

    public long getMaxDescent() {
        return (long)(this.fontSize * (double)this.fontMetrics.getMaxDescent());
    }

    public long getItalicAngle() {
        return this.fontMetrics.getItalicAngle();
    }

    public long getMaxHeight() {
        return (long)((double)(this.fontMetrics.getMaxAscent() + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading()) * this.fontSize);
    }

    public long getMaxCharAdvance() {
        return (long)((double)this.fontMetrics.getMaxCharAdvance() * this.fontSize);
    }

    public long getCharWidth(int n) {
        return 0L;
    }

    public long getKerning(int n, int n2) {
        return 0L;
    }

    public BaselineInfo getBaselines(int n, BaselineInfo baselineInfo) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

