/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;

public final class External8BitEncodingCore
implements EncodingCore {
    private char[] byteToChar;
    private byte[] charToByte;

    public External8BitEncodingCore(External8BitEncodingData external8BitEncodingData) {
        int n;
        int n2;
        if (external8BitEncodingData == null) {
            throw new NullPointerException();
        }
        int[] nArray = external8BitEncodingData.getIndexDelta();
        int[] nArray2 = external8BitEncodingData.getValueDelta();
        this.byteToChar = new char[256];
        int n3 = this.byteToChar.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.byteToChar[n2] = (char)n2;
        }
        n2 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        for (n = 0; n < n5; ++n) {
            this.byteToChar[n2 += nArray[n]] = (char)(n4 += nArray2[n]);
        }
        this.charToByte = new byte[65536];
        for (n = 0; n < n3; ++n) {
            this.charToByte[this.byteToChar[n]] = (byte)n;
        }
    }

    public boolean isUnicodeCharacterSupported(int n) {
        if (n == 0) {
            return true;
        }
        return this.charToByte[n] != 0;
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer) {
        int n = codePointBuffer.getLength();
        if (byteBuffer == null) {
            byteBuffer = new ByteBuffer(n);
        } else if (byteBuffer.getLength() < n) {
            byteBuffer.ensureSize(n);
        }
        byte[] byArray = byteBuffer.getData();
        int[] nArray = codePointBuffer.getData();
        int n2 = byteBuffer.getOffset();
        int n3 = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n3; ++i) {
            int n4 = nArray[i];
            if (!this.isUnicodeCharacterSupported(n4)) continue;
            byArray[n2] = this.charToByte[n4 & 0xFFFF];
            ++n2;
        }
        byteBuffer.setCursor(n2);
        return byteBuffer;
    }

    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        int n = codePointBuffer.getLength();
        if (byteBuffer == null) {
            byteBuffer = new ByteBuffer(n);
        } else if (byteBuffer.getLength() < n) {
            byteBuffer.ensureSize(n);
        }
        byte[] byArray = byteBuffer.getData();
        int[] nArray = codePointBuffer.getData();
        int n2 = byteBuffer.getOffset();
        int n3 = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n3; ++i) {
            int n4 = nArray[i];
            if (this.isUnicodeCharacterSupported(n4)) {
                byArray[n2] = this.charToByte[n4 & 0xFFFF];
                ++n2;
                continue;
            }
            if (EncodingErrorType.REPLACE.equals(encodingErrorType)) {
                byArray[n2] = 63;
                ++n2;
                continue;
            }
            if (!EncodingErrorType.FAIL.equals(encodingErrorType)) continue;
            throw new EncodingException();
        }
        byteBuffer.setCursor(n2);
        return byteBuffer;
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer) {
        int n = byteBuffer.getLength();
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n);
        } else if (codePointBuffer.getLength() < n) {
            codePointBuffer.ensureSize(n);
        }
        int[] nArray = codePointBuffer.getData();
        byte[] byArray = byteBuffer.getData();
        int n2 = codePointBuffer.getOffset();
        int n3 = byteBuffer.getCursor();
        for (int i = byteBuffer.getOffset(); i < n3; ++i) {
            nArray[n2] = this.byteToChar[byArray[i] & 0xFF];
            ++n2;
        }
        codePointBuffer.setCursor(n2);
        return codePointBuffer;
    }

    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer, EncodingErrorType encodingErrorType) {
        int n = byteBuffer.getLength();
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n);
        } else if (codePointBuffer.getLength() < n) {
            codePointBuffer.ensureSize(n);
        }
        int[] nArray = codePointBuffer.getData();
        byte[] byArray = byteBuffer.getData();
        int n2 = codePointBuffer.getOffset();
        int n3 = byteBuffer.getCursor();
        for (int i = byteBuffer.getOffset(); i < n3; ++i) {
            nArray[n2] = this.byteToChar[byArray[i] & 0xFF];
            ++n2;
        }
        codePointBuffer.setCursor(n2);
        return codePointBuffer;
    }
}

