/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;

public class ByteStream {
    private ByteBuffer buffer;
    private byte[] data;
    private int writeCursor;
    private int lastWritePos;
    private int increment;
    private int readCursor;

    public ByteStream(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = byteBuffer;
        this.data = byteBuffer.getData();
        this.writeCursor = byteBuffer.getCursor();
        this.lastWritePos = this.data.length - 1;
        this.increment = n;
        this.readCursor = byteBuffer.getOffset();
    }

    public void put(byte by) {
        if (this.writeCursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.writeCursor + this.increment);
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        this.data[this.writeCursor] = by;
        ++this.writeCursor;
    }

    public void put(byte[] byArray) {
        if (this.writeCursor >= this.lastWritePos) {
            this.buffer.ensureSize(this.writeCursor + Math.max(this.increment, byArray.length));
            this.data = this.buffer.getData();
            this.lastWritePos = this.data.length - 1;
        }
        System.arraycopy(byArray, 0, this.data, this.writeCursor, byArray.length);
        this.writeCursor += byArray.length;
    }

    public byte get() {
        if (this.readCursor < this.writeCursor) {
            byte by = this.data[this.readCursor];
            ++this.readCursor;
            return by;
        }
        return 0;
    }

    public void close() {
        this.buffer.setCursor(this.writeCursor);
    }

    public int getReadSize() {
        return this.writeCursor - this.readCursor;
    }
}

