/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class FontDataAsciiReader {
    private byte[] buffer;
    private int cursor;
    private FontDataInputSource inputSource;
    private long readPosition;
    private boolean eol;

    public FontDataAsciiReader(FontDataInputSource fontDataInputSource) {
        this(fontDataInputSource, 4096);
    }

    public FontDataAsciiReader(FontDataInputSource fontDataInputSource, int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (fontDataInputSource == null) {
            throw new NullPointerException();
        }
        this.buffer = new byte[n];
        this.cursor = n;
        this.inputSource = fontDataInputSource;
        this.readPosition = 0L;
    }

    private int read() throws IOException {
        int n;
        if ((long)this.cursor >= this.inputSource.getLength()) {
            return -1;
        }
        if (this.cursor >= this.buffer.length) {
            n = Math.min(this.buffer.length, (int)Math.min(Integer.MAX_VALUE, this.inputSource.getLength() - this.readPosition));
            if (n == 0) {
                return -1;
            }
            this.inputSource.readFullyAt(this.readPosition, this.buffer, n);
            if (n == 0) {
                return -1;
            }
            this.readPosition += (long)n;
            this.cursor = 0;
        }
        n = 0xFF & this.buffer[this.cursor];
        ++this.cursor;
        return n;
    }

    public String readLine() throws IOException {
        int n = this.read();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(150);
        while (n != -1) {
            if (n == 10) {
                this.eol = true;
                return stringBuffer.toString();
            }
            if (n == 13) {
                if (!this.eol) {
                    return stringBuffer.toString();
                }
                this.eol = false;
            } else {
                this.eol = false;
                if (n > 127) {
                    stringBuffer.append('?');
                } else {
                    stringBuffer.append((char)n);
                }
            }
            n = this.read();
        }
        return stringBuffer.toString();
    }
}

