/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public class URLEncodeFunction
implements Function {
    private static final long serialVersionUID = 646428113862238221L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        String string;
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        String string2 = formulaContext.getTypeRegistry().convertToText(type, object);
        if (string2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (n == 2) {
            Type type2 = parameterCallback.getType(1);
            Object object2 = parameterCallback.getValue(1);
            string = formulaContext.getTypeRegistry().convertToText(type2, object2);
            if (string == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        } else {
            string = "ISO-8859-1";
        }
        try {
            return new TypeValuePair(TextType.TYPE, URLEncoder.encode(string2, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }

    public String getCanonicalName() {
        return "URLENCODE";
    }
}

