/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class ExactFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final long serialVersionUID = -6303315343568906710L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n != 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Type type2 = parameterCallback.getType(1);
        Object object2 = parameterCallback.getValue(1);
        try {
            Number number = typeRegistry.convertToNumber(type, object);
            Number number2 = typeRegistry.convertToNumber(type2, object2);
            double d = Math.abs(Math.abs(number.doubleValue()) - Math.abs(number2.doubleValue()));
            if (d < 5.0E-5) {
                return RETURN_TRUE;
            }
            return RETURN_FALSE;
        }
        catch (TypeConversionException typeConversionException) {
            String string = typeRegistry.convertToText(type, object);
            String string2 = typeRegistry.convertToText(type2, object2);
            if (string == null || string2 == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (string.equals(string2)) {
                return RETURN_TRUE;
            }
            return RETURN_FALSE;
        }
    }

    public String getCanonicalName() {
        return "EXACT";
    }
}

