/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.math.SumFunction;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.DivideOperator;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class AverageFunction
implements Function {
    private static final long serialVersionUID = -5057715506050635450L;
    private SumFunction sumFunction;

    public AverageFunction() {
        this.sumFunction = new SumFunction();
    }

    protected AverageFunction(SumFunction sumFunction) {
        this.sumFunction = sumFunction;
    }

    public String getCanonicalName() {
        return "AVERAGE";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        TypeValuePair typeValuePair = this.sumFunction.evaluate(formulaContext, parameterCallback);
        Number number = formulaContext.getTypeRegistry().convertToNumber(typeValuePair.getType(), typeValuePair.getValue());
        if (number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        BigDecimal bigDecimal2 = new BigDecimal(parameterCallback.getParameterCount());
        BigDecimal bigDecimal3 = DivideOperator.divide(bigDecimal, bigDecimal2);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal3);
    }
}

