/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.VersionHelper;

public abstract class ProjectInformation
extends DependencyInformation {
    private String copyright;
    private String bootClass;
    private ArrayList libraries;
    private ArrayList optionalLibraries;
    private VersionHelper versionHelper;
    private String internalName;

    protected ProjectInformation(String string) {
        this(string, string);
    }

    protected ProjectInformation(String string, String string2) {
        super(string2);
        this.internalName = string == null ? string2 : string;
        this.libraries = new ArrayList();
        this.optionalLibraries = new ArrayList();
    }

    private synchronized VersionHelper getVersionHelper() {
        if (this.versionHelper == null) {
            this.versionHelper = new VersionHelper(this);
        }
        return this.versionHelper;
    }

    public String getCopyright() {
        return this.copyright;
    }

    protected void setCopyright(String string) {
        this.copyright = string;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getBootClass() {
        return this.bootClass;
    }

    protected void setBootClass(String string) {
        this.bootClass = string;
    }

    public DependencyInformation[] getLibraries() {
        return this.libraries.toArray(new DependencyInformation[this.libraries.size()]);
    }

    public void addLibrary(DependencyInformation dependencyInformation) {
        if (dependencyInformation == null) {
            throw new NullPointerException();
        }
        if (this.libraries.contains(dependencyInformation)) {
            throw new NullPointerException();
        }
        this.libraries.add(dependencyInformation);
    }

    public DependencyInformation[] getOptionalLibraries() {
        return this.optionalLibraries.toArray(new DependencyInformation[this.optionalLibraries.size()]);
    }

    protected void addOptionalLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("Library classname must be given.");
        }
        DependencyInformation dependencyInformation = this.loadLibrary(string);
        if (dependencyInformation != null) {
            this.optionalLibraries.add(dependencyInformation);
        }
    }

    private DependencyInformation loadLibrary(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            try {
                Method method = clazz.getMethod("getInstance", null);
                return (DependencyInformation)method.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                return (DependencyInformation)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void addOptionalLibrary(DependencyInformation dependencyInformation) {
        if (dependencyInformation == null) {
            throw new NullPointerException("Library must be given.");
        }
        this.optionalLibraries.add(dependencyInformation);
    }

    public String getVersion() {
        return this.getVersionHelper().getVersion();
    }

    public String getProductId() {
        return this.getVersionHelper().getProductId();
    }

    public String getReleaseMilestone() {
        return this.getVersionHelper().getReleaseMilestone();
    }

    public String getReleaseMinor() {
        return this.getVersionHelper().getReleaseMinor();
    }

    public String getReleaseMajor() {
        return this.getVersionHelper().getReleaseMajor();
    }

    public String getReleaseCandidateToken() {
        return this.getVersionHelper().getReleaseCandidateToken();
    }

    public String getReleaseNumber() {
        return this.getVersionHelper().getReleaseNumber();
    }

    public String getReleaseBuildNumber() {
        return this.versionHelper.getReleaseBuildNumber();
    }
}

