/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.util.HashMap;

public class LFUMap
implements Serializable,
Cloneable {
    private HashMap map;
    private MapEntry first;
    private MapEntry last;
    private int cacheSize;

    public LFUMap(int n) {
        this.cacheSize = Math.max(3, n);
        this.map = new HashMap(n);
    }

    public void clear() {
        this.map.clear();
        this.first = null;
        this.last = null;
    }

    public Object get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return null;
        }
        if (this.first == this.last) {
            if (this.first.getKey().equals(object)) {
                return this.first.getValue();
            }
            return null;
        }
        MapEntry mapEntry = (MapEntry)this.map.get(object);
        if (mapEntry == null) {
            return null;
        }
        MapEntry mapEntry2 = mapEntry.getPrevious();
        if (mapEntry2 == null) {
            return mapEntry.getValue();
        }
        MapEntry mapEntry3 = mapEntry.getNext();
        if (mapEntry3 == null) {
            mapEntry2.setNext(null);
            this.last = mapEntry2;
            mapEntry.setPrevious(null);
            mapEntry.setNext(this.first);
            this.first.setPrevious(mapEntry);
            this.first = mapEntry;
            return mapEntry.getValue();
        }
        mapEntry3.setPrevious(mapEntry2);
        mapEntry2.setNext(mapEntry3);
        mapEntry.setPrevious(null);
        mapEntry.setNext(this.first);
        this.first.setPrevious(mapEntry);
        this.first = mapEntry;
        return mapEntry.getValue();
    }

    public void put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            if (object2 == null) {
                return;
            }
            this.last = this.first = new MapEntry(object, object2);
            this.map.put(object, this.first);
            return;
        }
        if (object2 == null) {
            this.remove(object);
            return;
        }
        if (this.first.getKey().equals(object)) {
            return;
        }
        MapEntry mapEntry = (MapEntry)this.map.get(object);
        if (mapEntry == null) {
            MapEntry mapEntry2;
            if (1 + this.map.size() >= this.cacheSize) {
                this.map.remove(this.last.getKey());
                mapEntry2 = this.last.getPrevious();
                this.last.setNext(null);
                this.last.setPrevious(null);
                mapEntry2.setNext(null);
                this.last = mapEntry2;
            }
            mapEntry2 = new MapEntry(object, object2);
            this.first.setPrevious(mapEntry2);
            mapEntry2.setNext(this.first);
            this.map.put(object, mapEntry2);
            this.first = mapEntry2;
            return;
        }
        mapEntry.setValue(object2);
        if (mapEntry == this.first) {
            throw new IllegalStateException("Duplicate return?");
        }
        if (mapEntry == this.last) {
            MapEntry mapEntry3 = this.last.getPrevious();
            mapEntry3.setNext(null);
            this.last = mapEntry3;
            this.first.setPrevious(mapEntry);
            mapEntry.setNext(this.first);
            mapEntry.setPrevious(null);
            this.first = mapEntry;
            return;
        }
        MapEntry mapEntry4 = mapEntry.getPrevious();
        MapEntry mapEntry5 = mapEntry.getNext();
        mapEntry4.setNext(mapEntry5);
        mapEntry5.setPrevious(mapEntry4);
        this.first.setPrevious(mapEntry);
        mapEntry.setNext(this.first);
        mapEntry.setPrevious(null);
        this.first = mapEntry;
    }

    public void remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return;
        }
        MapEntry mapEntry = (MapEntry)this.map.remove(object);
        if (mapEntry == null) {
            return;
        }
        if (mapEntry == this.first) {
            MapEntry mapEntry2 = this.first.getNext();
            if (mapEntry2 == null) {
                this.first = null;
                this.last = null;
                mapEntry.setNext(null);
                mapEntry.setPrevious(null);
                return;
            }
            this.first = mapEntry2;
            mapEntry2.setPrevious(null);
            mapEntry.setNext(null);
            mapEntry.setPrevious(null);
            return;
        }
        if (mapEntry == this.last) {
            MapEntry mapEntry3 = this.last.getPrevious();
            mapEntry3.setNext(null);
            this.last = mapEntry3;
            mapEntry.setNext(null);
            mapEntry.setPrevious(null);
            return;
        }
        MapEntry mapEntry4 = mapEntry.getPrevious();
        MapEntry mapEntry5 = mapEntry.getNext();
        mapEntry4.setNext(mapEntry5);
        mapEntry5.setPrevious(mapEntry4);
        mapEntry.setNext(null);
        mapEntry.setPrevious(null);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int getMaximumSize() {
        return this.cacheSize;
    }

    public void validate() {
        if (this.first == null) {
            return;
        }
        if (this.first.getPrevious() != null) {
            throw new IllegalStateException();
        }
        if (this.last.getNext() != null) {
            throw new IllegalStateException();
        }
        int n = 0;
        MapEntry mapEntry = null;
        MapEntry mapEntry2 = this.first;
        while (mapEntry2 != null) {
            if (mapEntry2.getPrevious() != mapEntry) {
                throw new IllegalStateException();
            }
            mapEntry = mapEntry2;
            mapEntry2 = mapEntry2.getNext();
            ++n;
        }
        if (n != this.size()) {
            throw new IllegalStateException();
        }
        n = 0;
        MapEntry mapEntry3 = null;
        mapEntry2 = this.last;
        while (mapEntry2 != null) {
            if (mapEntry2.getNext() != mapEntry3) {
                throw new IllegalStateException();
            }
            mapEntry3 = mapEntry2;
            mapEntry2 = mapEntry2.getPrevious();
            ++n;
        }
        if (mapEntry3 != this.first) {
            throw new IllegalStateException();
        }
        if (n != this.size()) {
            throw new IllegalStateException();
        }
        if (this.size() > this.cacheSize) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LFUMap lFUMap = (LFUMap)super.clone();
        lFUMap.map = (HashMap)lFUMap.clone();
        lFUMap.map.clear();
        for (MapEntry mapEntry = this.first; mapEntry != null; mapEntry = mapEntry.getNext()) {
            lFUMap.put(mapEntry.getKey(), mapEntry.getValue());
        }
        return lFUMap;
    }

    private static class MapEntry {
        private Object key;
        private Object value;
        private MapEntry previous;
        private MapEntry next;

        protected MapEntry(Object object, Object object2) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object2 == null) {
                throw new NullPointerException();
            }
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public MapEntry getPrevious() {
            return this.previous;
        }

        public void setPrevious(MapEntry mapEntry) {
            this.previous = mapEntry;
        }

        public MapEntry getNext() {
            return this.next;
        }

        public void setNext(MapEntry mapEntry) {
            this.next = mapEntry;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.value = object;
        }
    }
}

