/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.boot.DefaultModuleInfo;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractModule
extends DefaultModuleInfo
implements Module {
    private ModuleInfo[] requiredModules;
    private ModuleInfo[] optionalModules;
    private String name;
    private String description;
    private String producer;
    private String subsystem;
    private static final ModuleInfo[] EMPTY_MODULEINFO = new ModuleInfo[0];

    protected AbstractModule() {
        this.setModuleClass(this.getClass().getName());
    }

    protected void loadModuleInfo() throws ModuleInitializeException {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("module.properties", this.getClass());
        if (inputStream == null) {
            throw new ModuleInitializeException("File 'module.properties' not found in module package.");
        }
        this.loadModuleInfo(inputStream);
    }

    protected void loadModuleInfo(InputStream inputStream) throws ModuleInitializeException {
        if (inputStream == null) {
            throw new NullPointerException("Given InputStream is null.");
        }
        try {
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration();
            defaultConfiguration.load(inputStream);
            this.readModuleInfo(defaultConfiguration);
            ArrayList<DefaultModuleInfo> arrayList = new ArrayList<DefaultModuleInfo>();
            ArrayList<DefaultModuleInfo> arrayList2 = new ArrayList<DefaultModuleInfo>();
            Iterator iterator = defaultConfiguration.findPropertyKeys("dependency.");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.endsWith(".dependency-type")) continue;
                String string2 = string.substring(0, string.length() - ".dependency-type".length());
                DefaultModuleInfo defaultModuleInfo = this.readExternalModule(defaultConfiguration, string2);
                if ("optional".equals(defaultConfiguration.getConfigProperty(string))) {
                    arrayList.add(defaultModuleInfo);
                    continue;
                }
                arrayList2.add(defaultModuleInfo);
            }
            this.optionalModules = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            this.requiredModules = arrayList2.toArray(new ModuleInfo[arrayList2.size()]);
        }
        catch (IOException iOException) {
            throw new ModuleInitializeException("Failed to load properties", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readModuleInfo(Configuration configuration) {
        this.setName(configuration.getConfigProperty("module.name"));
        this.setProducer(configuration.getConfigProperty("module.producer"));
        this.setDescription(configuration.getConfigProperty("module.description"));
        this.setMajorVersion(configuration.getConfigProperty("module.version.major"));
        this.setMinorVersion(configuration.getConfigProperty("module.version.minor"));
        this.setPatchLevel(configuration.getConfigProperty("module.version.patchlevel"));
        this.setSubSystem(configuration.getConfigProperty("module.subsystem"));
    }

    private DefaultModuleInfo readExternalModule(Configuration configuration, String string) {
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo();
        defaultModuleInfo.setModuleClass(configuration.getConfigProperty(string + ".module"));
        defaultModuleInfo.setMajorVersion(configuration.getConfigProperty(string + ".version.major"));
        defaultModuleInfo.setMinorVersion(configuration.getConfigProperty(string + ".version.minor"));
        defaultModuleInfo.setPatchLevel(configuration.getConfigProperty(string + ".version.patchlevel"));
        return defaultModuleInfo;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    public String getProducer() {
        return this.producer;
    }

    protected void setProducer(String string) {
        this.producer = string;
    }

    public ModuleInfo[] getRequiredModules() {
        if (this.requiredModules == null) {
            return EMPTY_MODULEINFO;
        }
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.requiredModules.length];
        System.arraycopy(this.requiredModules, 0, moduleInfoArray, 0, this.requiredModules.length);
        return moduleInfoArray;
    }

    public ModuleInfo[] getOptionalModules() {
        if (this.optionalModules == null) {
            return EMPTY_MODULEINFO;
        }
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.optionalModules.length];
        System.arraycopy(this.optionalModules, 0, moduleInfoArray, 0, this.optionalModules.length);
        return moduleInfoArray;
    }

    protected void setRequiredModules(ModuleInfo[] moduleInfoArray) {
        this.requiredModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.requiredModules, 0, moduleInfoArray.length);
    }

    public void setOptionalModules(ModuleInfo[] moduleInfoArray) {
        this.optionalModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.optionalModules, 0, moduleInfoArray.length);
    }

    public String toString() {
        String string = StringUtils.getLineSeparator();
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("Module : ");
        stringBuffer.append(this.getName());
        stringBuffer.append(string);
        stringBuffer.append("ModuleClass : ");
        stringBuffer.append(this.getModuleClass());
        stringBuffer.append(string);
        stringBuffer.append("Version: ");
        stringBuffer.append(this.getMajorVersion());
        stringBuffer.append('.');
        stringBuffer.append(this.getMinorVersion());
        stringBuffer.append('.');
        stringBuffer.append(this.getPatchLevel());
        stringBuffer.append(string);
        stringBuffer.append("Producer: ");
        stringBuffer.append(this.getProducer());
        stringBuffer.append(string);
        stringBuffer.append("Description: ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected static boolean isClassLoadable(String string, Class clazz) {
        try {
            ObjectUtilities.getClassLoader(clazz).loadClass(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(SubSystem subSystem) {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("configuration.properties", this.getClass());
        if (inputStream == null) {
            return;
        }
        try {
            subSystem.getPackageManager().getPackageConfiguration().load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void performExternalInitialize(String string) throws ModuleInitializeException {
        try {
            ModuleInitializer moduleInitializer = (ModuleInitializer)ObjectUtilities.loadAndInstantiate(string, AbstractModule.class, ModuleInitializer.class);
            if (moduleInitializer == null) {
                throw new ModuleInitializeException("Failed to load specified initializer class.");
            }
            moduleInitializer.performInit();
        }
        catch (ModuleInitializeException moduleInitializeException) {
            throw moduleInitializeException;
        }
        catch (Exception exception) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", exception);
        }
    }

    protected void performExternalInitialize(String string, Class clazz) throws ModuleInitializeException {
        try {
            ModuleInitializer moduleInitializer = (ModuleInitializer)ObjectUtilities.loadAndInstantiate(string, clazz, ModuleInitializer.class);
            if (moduleInitializer == null) {
                throw new ModuleInitializeException("Failed to load specified initializer class.");
            }
            moduleInitializer.performInit();
        }
        catch (ModuleInitializeException moduleInitializeException) {
            throw moduleInitializeException;
        }
        catch (Exception exception) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", exception);
        }
    }

    public String getSubSystem() {
        if (this.subsystem == null) {
            return this.getName();
        }
        return this.subsystem;
    }

    protected void setSubSystem(String string) {
        this.subsystem = string;
    }
}

