/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.dummy;

import java.io.Serializable;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.dummy.DummyContentItem;

public class DummyContentLocation
implements ContentLocation,
Serializable {
    private String name;
    private ContentLocation parent;
    private Repository repository;
    private static final ContentEntity[] EMPTY_CONTENT_ENTITY = new ContentEntity[0];

    public DummyContentLocation(ContentLocation contentLocation, String string) {
        if (contentLocation == null) {
            throw new NullPointerException("Parent must not be null");
        }
        this.repository = contentLocation.getRepository();
        this.parent = contentLocation;
        this.name = string;
    }

    public DummyContentLocation(Repository repository, String string) {
        this.repository = repository;
        this.name = string;
    }

    public ContentEntity[] listContents() throws ContentIOException {
        return EMPTY_CONTENT_ENTITY;
    }

    public ContentEntity getEntry(String string) throws ContentIOException {
        throw new ContentIOException();
    }

    public ContentItem createItem(String string) throws ContentCreationException {
        return new DummyContentItem(this, string);
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        return new DummyContentLocation(this, string);
    }

    public boolean exists(String string) {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return RepositoryUtilities.buildName(this, "/");
    }

    public Object getAttribute(String string, String string2) {
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }
}

