/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;

public class DefaultNameGenerator
implements NameGenerator {
    private ContentLocation location;
    private String defaultNameHint;
    private String defaultSuffix;

    public DefaultNameGenerator(ContentLocation contentLocation) {
        this(contentLocation, "file", null);
    }

    public DefaultNameGenerator(ContentLocation contentLocation, String string) {
        if (contentLocation == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.location = contentLocation;
        int n = string.lastIndexOf(46);
        if (this.defaultSuffix == null && n > 0) {
            if (n < string.length() - 1) {
                this.defaultNameHint = string.substring(0, n);
                this.defaultSuffix = string.substring(n + 1);
            } else {
                this.defaultNameHint = string.substring(0, n);
                this.defaultSuffix = null;
            }
        } else {
            this.defaultNameHint = string;
            this.defaultSuffix = null;
        }
    }

    public DefaultNameGenerator(ContentLocation contentLocation, String string, String string2) {
        if (contentLocation == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.location = contentLocation;
        this.defaultNameHint = string;
        this.defaultSuffix = string2;
    }

    public String generateName(String string, String string2) throws ContentIOException {
        String string3 = string != null ? string : this.defaultNameHint;
        String string4 = this.defaultSuffix != null ? this.defaultSuffix : this.getSuffixForType(string2, this.location);
        String string5 = string3 + '.' + string4;
        if (!this.location.exists(string5)) {
            return string5;
        }
        int n = 0;
        while (true) {
            if (n < 0) {
                throw new ContentIOException();
            }
            String string6 = string3 + n + '.' + string4;
            if (!this.location.exists(string6)) {
                return string6;
            }
            ++n;
        }
    }

    private String getSuffixForType(String string, ContentLocation contentLocation) {
        Repository repository = contentLocation.getRepository();
        MimeRegistry mimeRegistry = repository.getMimeRegistry();
        return mimeRegistry.getSuffix(string);
    }
}

