/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class CompoundName
implements Name,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3513100557083972036L;
    private static final int RIGHT_TO_LEFT = -1;
    private static final int LEFT_TO_RIGHT = 1;
    private static final int FLAT = 0;
    protected transient Properties mySyntax;
    private transient Vector elts = new Vector();
    private transient int direction;
    private transient String separator;
    private transient boolean ignoreCase;
    private transient String escape;
    private transient String beginQuote;
    private transient String endQuote;
    private transient String beginQuote2;
    private transient String endQuote2;
    private transient boolean trimBlanks;

    public Name add(int n, String string) throws InvalidNameException {
        this.elts.add(n, string);
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        this.elts.add(string);
        return this;
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        Enumeration enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(n, enumeration.nextElement());
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        Enumeration enumeration = name.getAll();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return this;
    }

    public Object clone() {
        return new CompoundName(this.elts.elements(), this.mySyntax);
    }

    public int compareTo(Object object) {
        if (!(object instanceof CompoundName)) {
            throw new ClassCastException("CompoundName.compareTo() expected CompoundName");
        }
        CompoundName compoundName = (CompoundName)object;
        int n = Math.min(compoundName.elts.size(), this.elts.size());
        int n2 = 0;
        while (n2 < n) {
            String string = this.canonicalize((String)this.elts.get(n2));
            int n3 = string.compareTo(this.canonicalize((String)compoundName.elts.get(n2)));
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return this.elts.size() - compoundName.elts.size();
    }

    public boolean endsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        CompoundName compoundName = (CompoundName)name;
        if (compoundName.elts.size() > this.elts.size()) {
            return false;
        }
        int n = this.elts.size() - compoundName.elts.size();
        int n2 = 0;
        while (n2 < compoundName.elts.size()) {
            String string = this.canonicalize((String)this.elts.get(n + n2));
            if (!string.equals(this.canonicalize((String)compoundName.elts.get(n2)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompoundName)) {
            return false;
        }
        boolean bl = false;
        if (this.compareTo(object) == 0) {
            bl = true;
        }
        return bl;
    }

    public String get(int n) {
        return (String)this.elts.get(n);
    }

    public Enumeration getAll() {
        return this.elts.elements();
    }

    public Name getPrefix(int n) {
        CompoundName compoundName = new CompoundName(this.mySyntax);
        int n2 = 0;
        while (n2 < n) {
            compoundName.elts.add(this.elts.get(n2));
            ++n2;
        }
        return compoundName;
    }

    public Name getSuffix(int n) {
        if (n > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        CompoundName compoundName = new CompoundName(this.mySyntax);
        int n2 = n;
        while (n2 < this.elts.size()) {
            compoundName.elts.add(this.elts.get(n2));
            ++n2;
        }
        return compoundName;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elts.size()) {
            n += this.canonicalize((String)this.elts.get(n2)).hashCode();
            ++n2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    public Object remove(int n) throws InvalidNameException {
        return this.elts.remove(n);
    }

    public int size() {
        return this.elts.size();
    }

    public boolean startsWith(Name name) {
        if (!(name instanceof CompoundName)) {
            return false;
        }
        CompoundName compoundName = (CompoundName)name;
        if (compoundName.elts.size() > this.elts.size()) {
            return false;
        }
        int n = 0;
        while (n < compoundName.elts.size()) {
            String string = this.canonicalize((String)this.elts.get(n));
            if (!string.equals(this.canonicalize((String)compoundName.elts.get(n)))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final String isSpecial(String string, int n) {
        String string2 = null;
        if (this.separator != null && string.startsWith(this.separator, n)) {
            string2 = this.separator;
        } else if (this.escape != null && string.startsWith(this.escape, n)) {
            string2 = this.escape;
        } else if (this.beginQuote != null && string.startsWith(this.beginQuote, n)) {
            string2 = this.beginQuote;
        } else if (this.endQuote != null && string.startsWith(this.endQuote, n)) {
            string2 = this.endQuote;
        } else if (this.beginQuote2 != null && string.startsWith(this.beginQuote2, n)) {
            string2 = this.beginQuote2;
        } else if (this.endQuote2 != null && string.startsWith(this.endQuote2, n)) {
            string2 = this.endQuote2;
        }
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.elts.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.direction == -1 ? n - n2 - 1 : n2;
            String string = (String)this.elts.get(n3);
            if (n2 > 0 || n2 == n - 1 && string.equals("")) {
                stringBuffer.append(this.separator);
            }
            int n4 = 0;
            while (n4 < string.length()) {
                String string2 = this.isSpecial(string, n4);
                if (string2 != null) {
                    stringBuffer.append(this.escape);
                    stringBuffer.append(string2);
                    n4 += string2.length();
                    continue;
                }
                stringBuffer.append(string.charAt(n4));
                ++n4;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private final String canonicalize(String string) {
        String string2 = string;
        if (this.ignoreCase) {
            string2 = string2.toLowerCase();
        }
        if (this.trimBlanks) {
            int n = 0;
            while (n < string2.length() && Character.isWhitespace(string2.charAt(n))) {
                ++n;
            }
            int n2 = string2.length() - 1;
            while (n2 >= n && Character.isWhitespace(string2.charAt(n2))) {
                --n2;
            }
            string2 = string2.substring(n, n2);
        }
        return string2;
    }

    private final void initializeSyntax() {
        String string = this.mySyntax.getProperty("jndi.syntax.direction", "flat");
        this.direction = string.equals("right_to_left") ? -1 : (string.equals("left_to_right") ? 1 : 0);
        this.separator = this.mySyntax.getProperty("jndi.syntax.separator", "");
        this.ignoreCase = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.ignorecase", "false"));
        this.escape = this.mySyntax.getProperty("jndi.syntax.escape", null);
        this.beginQuote = this.mySyntax.getProperty("jndi.syntax.beginquote", null);
        this.endQuote = this.mySyntax.getProperty("jndi.syntax.endquote", this.beginQuote);
        this.beginQuote2 = this.mySyntax.getProperty("jndi.syntax.beginquote2", null);
        this.endQuote2 = this.mySyntax.getProperty("jndi.syntax.endquote2", this.beginQuote2);
        this.trimBlanks = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.trimblanks", "false"));
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mySyntax = (Properties)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        this.elts = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.elts.addElement((String)objectInputStream.readObject());
            ++n2;
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.mySyntax);
        objectOutputStream.writeInt(this.elts.size());
        int n = 0;
        while (n < this.elts.size()) {
            objectOutputStream.writeObject(this.elts.elementAt(n));
            ++n;
        }
    }

    private CompoundName(Properties properties) {
        this.mySyntax = properties;
        this.initializeSyntax();
    }

    protected CompoundName(Enumeration enumeration, Properties properties) {
        this.mySyntax = properties;
        this.initializeSyntax();
        try {
            while (enumeration.hasMoreElements()) {
                this.elts.add(enumeration.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    public CompoundName(String string, Properties properties) throws InvalidNameException {
        Object object;
        this.mySyntax = properties;
        this.initializeSyntax();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string2 = null;
        while (n < string.length()) {
            block16: {
                String string3 = this.isSpecial(string, n);
                if (string3 == this.escape && this.escape != null) {
                    if (string.length() == n + string3.length()) {
                        stringBuffer.append(string3);
                        n += string3.length();
                        break block16;
                    } else {
                        object = this.isSpecial(string, n + string3.length());
                        if (object != null) {
                            stringBuffer.append((String)object);
                            n += string3.length() + ((String)object).length();
                            continue;
                        }
                        stringBuffer.append(string3);
                        n += string3.length();
                        continue;
                    }
                }
                if (string2 != null) {
                    if (string2 == string3) {
                        if (n + string2.length() < string.length() && !string.startsWith(this.separator, n + string2.length())) {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n += string2.length();
                        string2 = null;
                        continue;
                    }
                } else {
                    if (stringBuffer.length() == 0 && string3 == this.beginQuote && this.beginQuote != null) {
                        string2 = this.endQuote;
                        n += string3.length();
                        continue;
                    }
                    if (stringBuffer.length() == 0 && string3 == this.beginQuote2 && this.beginQuote2 != null) {
                        string2 = this.endQuote2;
                        n += string3.length();
                        continue;
                    }
                    if (this.direction != 0 && string3 == this.separator) {
                        this.elts.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n += string3.length();
                        continue;
                    }
                }
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        if (stringBuffer.length() != 0) {
            this.elts.add(stringBuffer.toString());
        }
        if (this.direction == -1) {
            int n2 = this.elts.size();
            n = 0;
            while (n < n2 / 2) {
                object = this.elts.set(n, this.elts.get(n2 - n - 1));
                this.elts.set(n2 - n - 1, object);
                ++n;
            }
        }
        if (string2 != null) {
            throw new InvalidNameException("unterminated quote");
        }
    }
}

