/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    public static int binarySearch(byte[] byArray, byte by) {
        int n = 0;
        int n2 = byArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            byte by2 = byArray[n3];
            if (by2 == by) {
                return n3;
            }
            if (by2 > by) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(char[] cArray, char c) {
        int n = 0;
        int n2 = cArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            char c2 = cArray[n3];
            if (c2 == c) {
                return n3;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(short[] sArray, short s) {
        int n = 0;
        int n2 = sArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            short s2 = sArray[n3];
            if (s2 == s) {
                return n3;
            }
            if (s2 > s) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = n2 + n3 >> 1;
            int n5 = nArray[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            n2 = ++n4;
        }
        return -n4 - 1;
    }

    public static int binarySearch(long[] lArray, long l) {
        int n = 0;
        int n2 = lArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            long l2 = lArray[n3];
            if (l2 == l) {
                return n3;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(float[] fArray, float f) {
        int n = 0;
        int n2 = fArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            int n4 = Float.compare(fArray[n3], f);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(double[] dArray, double d) {
        int n = 0;
        int n2 = dArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            int n4 = Double.compare(dArray[n3], d);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch(objectArray, object, null);
    }

    public static int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n = 0;
        int n2 = objectArray.length - 1;
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >> 1;
            int n4 = Collections.compare(object, objectArray[n3], comparator);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        if (blArray.length == blArray2.length) {
            int n = blArray.length;
            while (--n >= 0) {
                if (blArray[n] == blArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            int n = byArray.length;
            while (--n >= 0) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length == cArray2.length) {
            int n = cArray.length;
            while (--n >= 0) {
                if (cArray[n] == cArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        if (sArray.length == sArray2.length) {
            int n = sArray.length;
            while (--n >= 0) {
                if (sArray[n] == sArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length == nArray2.length) {
            int n = nArray.length;
            while (--n >= 0) {
                if (nArray[n] == nArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        if (lArray.length == lArray2.length) {
            int n = lArray.length;
            while (--n >= 0) {
                if (lArray[n] == lArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        if (fArray.length == fArray2.length) {
            int n = fArray.length;
            while (--n >= 0) {
                if (Float.compare(fArray[n], fArray2[n]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        if (dArray.length == dArray2.length) {
            int n = dArray.length;
            while (--n >= 0) {
                if (Double.compare(dArray[n], dArray2[n]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        if (objectArray.length == objectArray2.length) {
            int n = objectArray.length;
            while (--n >= 0) {
                if (AbstractCollection.equals(objectArray[n], objectArray2[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, 0, blArray.length, bl);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            blArray[n3] = bl;
            ++n3;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = by;
            ++n3;
        }
    }

    public static void fill(char[] cArray, char c) {
        Arrays.fill(cArray, 0, cArray.length, c);
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            cArray[n3] = c;
            ++n3;
        }
    }

    public static void fill(short[] sArray, short s) {
        Arrays.fill(sArray, 0, sArray.length, s);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            sArray[n3] = s;
            ++n3;
        }
    }

    public static void fill(int[] nArray, int n) {
        Arrays.fill(nArray, 0, nArray.length, n);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n4 = n;
        while (n4 < n2) {
            nArray[n4] = n3;
            ++n4;
        }
    }

    public static void fill(long[] lArray, long l) {
        Arrays.fill(lArray, 0, lArray.length, l);
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            lArray[n3] = l;
            ++n3;
        }
    }

    public static void fill(float[] fArray, float f) {
        Arrays.fill(fArray, 0, fArray.length, f);
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            fArray[n3] = f;
            ++n3;
        }
    }

    public static void fill(double[] dArray, double d) {
        Arrays.fill(dArray, 0, dArray.length, d);
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            dArray[n3] = d;
            ++n3;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (n3 < n2) {
            objectArray[n3] = object;
            ++n3;
        }
    }

    public static void sort(byte[] byArray) {
        Arrays.qsort(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(byArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, byte[] byArray) {
        return byArray[n] < byArray[n2] ? (byArray[n2] < byArray[n3] ? n2 : (byArray[n] < byArray[n3] ? n3 : n)) : (byArray[n2] > byArray[n3] ? n2 : (byArray[n] > byArray[n3] ? n3 : n));
    }

    private static final void swap(int n, int n2, byte[] byArray) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static final void vecswap(int n, int n2, int n3, byte[] byArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, byArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final void qsort(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && byArray[n7 - 1] > byArray[n7]) {
                    Arrays.swap(n7, n7 - 1, byArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, byArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, byArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, byArray);
        }
        n8 = Arrays.med3(n9, n8, n10, byArray);
        Arrays.swap(n, n8, byArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = byArray[n4] - byArray[n]) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, byArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = byArray[n11] - byArray[n]) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, byArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, byArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, byArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, byArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(byArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(byArray, n10 - n13, n13);
        }
    }

    public static void sort(char[] cArray) {
        Arrays.qsort(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(cArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, char[] cArray) {
        return cArray[n] < cArray[n2] ? (cArray[n2] < cArray[n3] ? n2 : (cArray[n] < cArray[n3] ? n3 : n)) : (cArray[n2] > cArray[n3] ? n2 : (cArray[n] > cArray[n3] ? n3 : n));
    }

    private static final void swap(int n, int n2, char[] cArray) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    private static final void vecswap(int n, int n2, int n3, char[] cArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, cArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final void qsort(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && cArray[n7 - 1] > cArray[n7]) {
                    Arrays.swap(n7, n7 - 1, cArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, cArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, cArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, cArray);
        }
        n8 = Arrays.med3(n9, n8, n10, cArray);
        Arrays.swap(n, n8, cArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = cArray[n4] - cArray[n]) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, cArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = cArray[n11] - cArray[n]) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, cArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, cArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, cArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, cArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(cArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(cArray, n10 - n13, n13);
        }
    }

    public static void sort(short[] sArray) {
        Arrays.qsort(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(sArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, short[] sArray) {
        return sArray[n] < sArray[n2] ? (sArray[n2] < sArray[n3] ? n2 : (sArray[n] < sArray[n3] ? n3 : n)) : (sArray[n2] > sArray[n3] ? n2 : (sArray[n] > sArray[n3] ? n3 : n));
    }

    private static final void swap(int n, int n2, short[] sArray) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    private static final void vecswap(int n, int n2, int n3, short[] sArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, sArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final void qsort(short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && sArray[n7 - 1] > sArray[n7]) {
                    Arrays.swap(n7, n7 - 1, sArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, sArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, sArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, sArray);
        }
        n8 = Arrays.med3(n9, n8, n10, sArray);
        Arrays.swap(n, n8, sArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = sArray[n4] - sArray[n]) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, sArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = sArray[n11] - sArray[n]) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, sArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, sArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, sArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, sArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(sArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(sArray, n10 - n13, n13);
        }
    }

    public static void sort(int[] nArray) {
        Arrays.qsort(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(nArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, int[] nArray) {
        return nArray[n] < nArray[n2] ? (nArray[n2] < nArray[n3] ? n2 : (nArray[n] < nArray[n3] ? n3 : n)) : (nArray[n2] > nArray[n3] ? n2 : (nArray[n] > nArray[n3] ? n3 : n));
    }

    private static final void swap(int n, int n2, int[] nArray) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static final void vecswap(int n, int n2, int n3, int[] nArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, nArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final int compare(int n, int n2) {
        int n3;
        if (n < n2) {
            n3 = -1;
        } else {
            int n4 = 0;
            if (n == n2) {
                n4 = 1;
            }
            n3 = 1 - n4;
        }
        return n3;
    }

    private static final void qsort(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && nArray[n7 - 1] > nArray[n7]) {
                    Arrays.swap(n7, n7 - 1, nArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, nArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, nArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, nArray);
        }
        n8 = Arrays.med3(n9, n8, n10, nArray);
        Arrays.swap(n, n8, nArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = Arrays.compare(nArray[n4], nArray[n])) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, nArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = Arrays.compare(nArray[n11], nArray[n])) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, nArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, nArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, nArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, nArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(nArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(nArray, n10 - n13, n13);
        }
    }

    public static void sort(long[] lArray) {
        Arrays.qsort(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(lArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, long[] lArray) {
        return lArray[n] < lArray[n2] ? (lArray[n2] < lArray[n3] ? n2 : (lArray[n] < lArray[n3] ? n3 : n)) : (lArray[n2] > lArray[n3] ? n2 : (lArray[n] > lArray[n3] ? n3 : n));
    }

    private static final void swap(int n, int n2, long[] lArray) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    private static final void vecswap(int n, int n2, int n3, long[] lArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, lArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final int compare(long l, long l2) {
        int n;
        if (l < l2) {
            n = -1;
        } else {
            int n2 = 0;
            if (l == l2) {
                n2 = 1;
            }
            n = 1 - n2;
        }
        return n;
    }

    private static final void qsort(long[] lArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && lArray[n7 - 1] > lArray[n7]) {
                    Arrays.swap(n7, n7 - 1, lArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, lArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, lArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, lArray);
        }
        n8 = Arrays.med3(n9, n8, n10, lArray);
        Arrays.swap(n, n8, lArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = Arrays.compare(lArray[n4], lArray[n])) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, lArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = Arrays.compare(lArray[n11], lArray[n])) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, lArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, lArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, lArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, lArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(lArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(lArray, n10 - n13, n13);
        }
    }

    public static void sort(float[] fArray) {
        Arrays.qsort(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(fArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, float[] fArray) {
        return Float.compare(fArray[n], fArray[n2]) < 0 ? (Float.compare(fArray[n2], fArray[n3]) < 0 ? n2 : (Float.compare(fArray[n], fArray[n3]) < 0 ? n3 : n)) : (Float.compare(fArray[n2], fArray[n3]) > 0 ? n2 : (Float.compare(fArray[n], fArray[n3]) > 0 ? n3 : n));
    }

    private static final void swap(int n, int n2, float[] fArray) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private static final void vecswap(int n, int n2, int n3, float[] fArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, fArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final void qsort(float[] fArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && Float.compare(fArray[n7 - 1], fArray[n7]) > 0) {
                    Arrays.swap(n7, n7 - 1, fArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, fArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, fArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, fArray);
        }
        n8 = Arrays.med3(n9, n8, n10, fArray);
        Arrays.swap(n, n8, fArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = Float.compare(fArray[n4], fArray[n])) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, fArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = Float.compare(fArray[n11], fArray[n])) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, fArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, fArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, fArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, fArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(fArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(fArray, n10 - n13, n13);
        }
    }

    public static void sort(double[] dArray) {
        Arrays.qsort(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(dArray, n, n2 - n);
    }

    private static final int med3(int n, int n2, int n3, double[] dArray) {
        return Double.compare(dArray[n], dArray[n2]) < 0 ? (Double.compare(dArray[n2], dArray[n3]) < 0 ? n2 : (Double.compare(dArray[n], dArray[n3]) < 0 ? n3 : n)) : (Double.compare(dArray[n2], dArray[n3]) > 0 ? n2 : (Double.compare(dArray[n], dArray[n3]) > 0 ? n3 : n));
    }

    private static final void swap(int n, int n2, double[] dArray) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static final void vecswap(int n, int n2, int n3, double[] dArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, dArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static final void qsort(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            int n6 = n + 1;
            while (n6 < n + n2) {
                int n7 = n6;
                while (n7 > n && Double.compare(dArray[n7 - 1], dArray[n7]) > 0) {
                    Arrays.swap(n7, n7 - 1, dArray);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 / 2;
        int n9 = n;
        int n10 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n9 = Arrays.med3(n9, n9 + n5, n9 + 2 * n5, dArray);
            n8 = Arrays.med3(n8 - n5, n8, n8 + n5, dArray);
            n10 = Arrays.med3(n10 - 2 * n5, n10 - n5, n10, dArray);
        }
        n8 = Arrays.med3(n9, n8, n10, dArray);
        Arrays.swap(n, n8, dArray);
        n5 = n4 = n;
        int n11 = n3 = n + n2 - 1;
        while (true) {
            int n12;
            if (n4 <= n11 && (n12 = Double.compare(dArray[n4], dArray[n])) <= 0) {
                if (n12 == 0) {
                    Arrays.swap(n5, n4, dArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n11 >= n4 && (n12 = Double.compare(dArray[n11], dArray[n])) >= 0) {
                if (n12 == 0) {
                    Arrays.swap(n11, n3, dArray);
                    --n3;
                }
                --n11;
            }
            if (n4 > n11) break;
            Arrays.swap(n4, n11, dArray);
            ++n4;
            --n11;
        }
        n10 = n + n2;
        int n13 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n13, n13, dArray);
        n13 = Math.min(n3 - n11, n10 - n3 - 1);
        Arrays.vecswap(n4, n10 - n13, n13, dArray);
        n13 = n4 - n5;
        if (n13 > 1) {
            Arrays.qsort(dArray, n, n13);
        }
        if ((n13 = n3 - n11) > 1) {
            Arrays.qsort(dArray, n10 - n13, n13);
        }
    }

    public static void sort(Object[] objectArray) {
        Arrays.sort(objectArray, 0, objectArray.length, null);
    }

    public static void sort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, 0, objectArray.length, comparator);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2, null);
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex " + n + " > toIndex " + n2);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            int n4 = Math.min(n3 + 6, n2);
            int n5 = n3 + 1;
            while (n5 < n4) {
                if (Collections.compare(objectArray[n5 - 1], objectArray[n5], comparator) > 0) {
                    int n6 = n5;
                    Object object = objectArray[n6];
                    do {
                        objectArray[n6] = objectArray[n6 - 1];
                    } while (--n6 > n3 && Collections.compare(objectArray[n6 - 1], object, comparator) > 0);
                    objectArray[n6] = object;
                }
                ++n5;
            }
            n3 += 6;
        }
        n3 = n2 - n;
        if (n3 <= 6) {
            return;
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[n3];
        Object[] objectArray4 = null;
        int n7 = -n;
        int n8 = 6;
        while (n8 < n3) {
            int n9 = n;
            while (n9 < n2) {
                int n10 = n9 + n8;
                int n11 = Math.min(n2, n10 + n8);
                if (n10 >= n11 || Collections.compare(objectArray2[n10 - 1], objectArray2[n10], comparator) <= 0) {
                    System.arraycopy(objectArray2, n9, objectArray3, n9 + n7, n11 - n9);
                } else if (Collections.compare(objectArray2[n9], objectArray2[n11 - 1], comparator) > 0) {
                    System.arraycopy(objectArray2, n9, objectArray3, n11 - n8 + n7, n8);
                    System.arraycopy(objectArray2, n10, objectArray3, n9 + n7, n11 - n10);
                } else {
                    int n12 = n9;
                    int n13 = n10;
                    int n14 = n9 + n7;
                    while (n12 < n10 && n13 < n11) {
                        objectArray3[n14++] = objectArray2[Collections.compare(objectArray2[n12], objectArray2[n13], comparator) <= 0 ? n12++ : n13++];
                    }
                    if (n12 < n10) {
                        System.arraycopy(objectArray2, n12, objectArray3, n14, n10 - n12);
                    } else {
                        System.arraycopy(objectArray2, n13, objectArray3, n14, n11 - n13);
                    }
                }
                n9 += n8 << 1;
            }
            objectArray4 = objectArray2;
            objectArray2 = objectArray3;
            objectArray3 = objectArray4;
            n += n7;
            n2 += n7;
            n7 = -n7;
            n8 <<= 1;
        }
        if (objectArray2 != objectArray) {
            System.arraycopy(objectArray2, 0, objectArray, n7, n2);
        }
    }

    public static List asList(Object[] objectArray) {
        return new ArrayList(objectArray);
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < lArray.length - 1) {
            string = string + String.valueOf(lArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(lArray[lArray.length - 1]) + ']';
        return string;
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < nArray.length - 1) {
            string = string + String.valueOf(nArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(nArray[nArray.length - 1]) + ']';
        return string;
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        if (sArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < sArray.length - 1) {
            string = string + String.valueOf(sArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(sArray[sArray.length - 1]) + ']';
        return string;
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        if (cArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < cArray.length - 1) {
            string = string + String.valueOf(cArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(cArray[cArray.length - 1]) + ']';
        return string;
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < byArray.length - 1) {
            string = string + String.valueOf(byArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(byArray[byArray.length - 1]) + ']';
        return string;
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < blArray.length - 1) {
            string = string + String.valueOf(blArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(blArray[blArray.length - 1]) + ']';
        return string;
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        if (fArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < fArray.length - 1) {
            string = string + String.valueOf(fArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(fArray[fArray.length - 1]) + ']';
        return string;
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        if (dArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < dArray.length - 1) {
            string = string + String.valueOf(dArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(dArray[dArray.length - 1]) + ']';
        return string;
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        String string = "[";
        int n = 0;
        while (n < objectArray.length - 1) {
            string = string + String.valueOf(objectArray[n]) + ", ";
            ++n;
        }
        string = string + String.valueOf(objectArray[objectArray.length - 1]) + ']';
        return string;
    }

    private Arrays() {
    }

    private static final class ArrayList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final Object[] a;

        public final Object get(int n) {
            return this.a[n];
        }

        public final int size() {
            return this.a.length;
        }

        public final Object set(int n, Object object) {
            Object object2 = this.a[n];
            this.a[n] = object;
            return object2;
        }

        public final boolean contains(Object object) {
            boolean bl = false;
            if (this.lastIndexOf(object) >= 0) {
                bl = true;
            }
            return bl;
        }

        public final int indexOf(Object object) {
            int n = this.a.length;
            int n2 = 0;
            while (n2 < n) {
                if (ArrayList.equals(object, this.a[n2])) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public final int lastIndexOf(Object object) {
            int n = this.a.length;
            while (--n >= 0) {
                if (!ArrayList.equals(object, this.a[n])) continue;
                return n;
            }
            return -1;
        }

        public final Object[] toArray() {
            return (Object[])this.a.clone();
        }

        public final Object[] toArray(Object[] objectArray) {
            int n = this.a.length;
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            } else if (objectArray.length > n) {
                objectArray[n] = null;
            }
            System.arraycopy(this.a, 0, objectArray, 0, n);
            return objectArray;
        }

        ArrayList(Object[] objectArray) {
            if (objectArray == null) {
                throw new NullPointerException();
            }
            this.a = objectArray;
        }
    }
}

