/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.SaslEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SaslInputStream
extends InputStream {
    private static final String NAME = "SaslOutputStream";
    private static final String ERROR = "ERROR";
    private static final String WARN = " WARN";
    private static final String TRACE = "DEBUG";
    private static final boolean DEBUG = true;
    private static final int debuglevel = 3;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private SaslClient client;
    private SaslServer server;
    private int maxRawSendSize;
    private InputStream source;
    private byte[] internalBuf;

    private static final void debug(String string, Object object) {
        err.println("[" + string + "] SaslOutputStream: " + String.valueOf(object));
    }

    public int available() throws IOException {
        int n = 0;
        if (this.internalBuf != null) {
            n = this.internalBuf.length;
        }
        return n;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public int read() throws IOException {
        int n = -1;
        if (this.internalBuf != null && this.internalBuf.length > 0) {
            n = this.internalBuf[0] & 0xFF;
            if (this.internalBuf.length == 1) {
                this.internalBuf = new byte[0];
            } else {
                byte[] byArray = new byte[this.internalBuf.length - 1];
                System.arraycopy(this.internalBuf, 1, byArray, 0, byArray.length);
                this.internalBuf = byArray;
            }
        } else {
            byte[] byArray = new byte[1];
            int n2 = this.read(byArray);
            n = n2 > 0 ? byArray[0] & 0xFF : -1;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b");
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off=" + String.valueOf(n) + ", len=" + String.valueOf(n2) + ", b.length=" + String.valueOf(byArray.length));
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (this.internalBuf == null || this.internalBuf.length < 1) {
            try {
                this.internalBuf = this.readSaslBuffer();
                if (this.internalBuf == null) {
                    return -1;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                return -1;
            }
        }
        if (n2 <= this.internalBuf.length) {
            n3 = n2;
            System.arraycopy(this.internalBuf, 0, byArray, n, n2);
            if (n2 == this.internalBuf.length) {
                this.internalBuf = null;
            } else {
                byte[] byArray2 = new byte[this.internalBuf.length - n2];
                System.arraycopy(this.internalBuf, n2, byArray2, 0, byArray2.length);
                this.internalBuf = byArray2;
            }
        } else {
            n3 = this.internalBuf.length;
            System.arraycopy(this.internalBuf, 0, byArray, n, n3);
            this.internalBuf = null;
            n += n3;
            n2 -= n3;
            while (n2 > 0) {
                byte[] byArray3;
                if (this.source.available() <= 3 || (byArray3 = this.readSaslBuffer()) == null) break;
                int n4 = byArray3.length;
                int n5 = 0;
                if (n4 > n2) {
                    n5 = n4 - n2;
                }
                int n6 = n5;
                int n7 = n4 - n6;
                System.arraycopy(byArray3, 0, byArray, n, n7);
                if (n6 > 0) {
                    this.internalBuf = new byte[n6];
                    System.arraycopy(byArray3, n7, this.internalBuf, 0, n6);
                }
                n += n7;
                n3 += n7;
                n2 -= n7;
            }
        }
        return n3;
    }

    private final byte[] readSaslBuffer() throws IOException {
        int n;
        byte[] byArray = new byte[4];
        try {
            n = this.source.read(byArray);
            if (n == -1) {
                return null;
            }
        }
        catch (IOException iOException) {
            SaslInputStream.debug(ERROR, iOException);
            throw iOException;
        }
        if (n != 4) {
            throw new IOException("Was expecting 4 but found " + String.valueOf(n));
        }
        int n2 = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n2 > this.maxRawSendSize || n2 < 0) {
            throw new SaslEncodingException("SASL buffer (security layer) too long");
        }
        byArray = new byte[n2];
        try {
            n = this.source.read(byArray);
        }
        catch (IOException iOException) {
            SaslInputStream.debug(ERROR, iOException);
            throw iOException;
        }
        if (n != n2) {
            throw new IOException("Was expecting " + String.valueOf(n2) + " but found " + String.valueOf(n));
        }
        byArray = this.client != null ? this.client.unwrap(byArray, 0, n) : this.server.unwrap(byArray, 0, n);
        return byArray;
    }

    public SaslInputStream(SaslClient saslClient, InputStream inputStream) throws IOException {
        this.client = saslClient;
        this.maxRawSendSize = Integer.parseInt((String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
        this.server = null;
        this.source = inputStream;
    }

    public SaslInputStream(SaslServer saslServer, InputStream inputStream) throws IOException {
        this.server = saslServer;
        this.maxRawSendSize = Integer.parseInt((String)saslServer.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
        this.client = null;
        this.source = inputStream;
    }
}

