/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertificateEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class GnuPublicKeyring
extends BaseKeyring
implements IPublicKeyring {
    public static final int USAGE = 4;

    public boolean containsCertificate(String string) {
        if (!this.containsAlias(string)) {
            return false;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof CertificateEntry)) continue;
            return true;
        }
        return false;
    }

    public Certificate getCertificate(String string) {
        if (!this.containsAlias(string)) {
            return null;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!(entry instanceof CertificateEntry)) continue;
            return ((CertificateEntry)entry).getCertificate();
        }
        return null;
    }

    public void putCertificate(String string, Certificate certificate) {
        if (this.containsCertificate(string)) {
            return;
        }
        Properties properties = new Properties();
        properties.put("alias", this.fixAlias(string));
        this.add(new CertificateEntry(certificate, new Date(), properties));
    }

    protected void load(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream.read() != 4) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        this.keyring = PasswordAuthenticatedEntry.decode(new DataInputStream(inputStream), cArray);
    }

    protected void store(OutputStream outputStream, char[] cArray) throws IOException {
        outputStream.write(4);
        this.keyring.encode(new DataOutputStream(outputStream), cArray);
    }

    public GnuPublicKeyring(String string, int n) {
        this.keyring = new PasswordAuthenticatedEntry(string, n, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
    }

    public GnuPublicKeyring() {
    }
}

