/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.HTTPDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Headers {
    private static final DateFormat dateFormat = new HTTPDateFormat();
    private final ArrayList headers;

    Iterator iterator() {
        return this.headers.iterator();
    }

    public String getValue(String string) {
        int n = this.headers.size() - 1;
        while (n >= 0) {
            HeaderElement headerElement = (HeaderElement)this.headers.get(n);
            if (headerElement.name.equalsIgnoreCase(string)) {
                return headerElement.value;
            }
            --n;
        }
        return null;
    }

    public int getIntValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public long getLongValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Date getDateValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void put(String string, String string2) {
        int n = this.headers.size() - 1;
        while (n >= 0) {
            HeaderElement headerElement = (HeaderElement)this.headers.get(n);
            if (headerElement.name.equalsIgnoreCase(string)) {
                headerElement.value = string2;
                return;
            }
            --n;
        }
        this.addValue(string, string2);
    }

    public void putAll(Headers headers) {
        Iterator iterator = headers.iterator();
        while (iterator.hasNext()) {
            HeaderElement headerElement = (HeaderElement)iterator.next();
            this.remove(headerElement.name);
            this.addValue(headerElement.name, headerElement.value);
        }
    }

    public void remove(String string) {
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            HeaderElement headerElement = (HeaderElement)iterator.next();
            if (!headerElement.name.equalsIgnoreCase(string)) continue;
            iterator.remove();
        }
    }

    public void parse(InputStream inputStream) throws IOException {
        LineInputStream lineInputStream = inputStream instanceof LineInputStream ? (LineInputStream)inputStream : new LineInputStream(inputStream);
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            String string2;
            if ((string2 = lineInputStream.readLine()) == null) {
                if (string == null) break;
                this.addValue(string, stringBuilder.toString());
                break;
            }
            int n2 = string2.length();
            if (n2 < 2) {
                if (string == null) break;
                this.addValue(string, stringBuilder.toString());
                break;
            }
            char c = string2.charAt(0);
            if (c == ' ' || c == '\t') {
                n = n2 - 1;
                if (string2.charAt(n) != '\r') {
                    ++n;
                }
                stringBuilder.append(string2.substring(0, n));
                continue;
            }
            if (string != null) {
                this.addValue(string, stringBuilder.toString());
            }
            n = string2.indexOf(58);
            string = string2.substring(0, n);
            stringBuilder.setLength(0);
            while (++n < n2 && string2.charAt(n) == ' ') {
            }
            int n3 = n2 - 1;
            if (string2.charAt(n3) != '\r') {
                ++n3;
            }
            stringBuilder.append(string2.substring(n, n3));
        }
    }

    public void addValue(String string, String string2) {
        this.headers.add(this.headers.size(), new HeaderElement(string, string2));
    }

    public Map getAsMap() {
        ArrayList arrayList;
        Object object;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            object = (HeaderElement)iterator.next();
            arrayList = (ArrayList)linkedHashMap.get(((HeaderElement)object).name);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                arrayList.add(((HeaderElement)object).value);
                linkedHashMap.put(((HeaderElement)object).name, arrayList);
                continue;
            }
            arrayList.add(0, ((HeaderElement)object).value);
        }
        iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            arrayList = (ArrayList)object.getValue();
            object.setValue(Collections.unmodifiableList(arrayList));
        }
        return linkedHashMap;
    }

    public String getHeaderName(int n) {
        if (n >= this.headers.size() || n < 0) {
            return null;
        }
        return ((HeaderElement)this.headers.get((int)n)).name;
    }

    public String getHeaderValue(int n) {
        if (n >= this.headers.size() || n < 0) {
            return null;
        }
        return ((HeaderElement)this.headers.get((int)n)).value;
    }

    private final /* synthetic */ void this() {
        this.headers = new ArrayList();
    }

    public Headers() {
        this.this();
    }

    static class HeaderElement {
        String name;
        String value;

        HeaderElement(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

