/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.util;

import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;

public class ValueConversions {
    private static final Access IMPL_TOKEN = Access.getToken();
    private static final MethodHandles.Lookup IMPL_LOOKUP = MethodHandleImpl.getLookup(IMPL_TOKEN);
    private static final EnumMap<Wrapper, MethodHandle>[] UNBOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
    private static final EnumMap<Wrapper, MethodHandle>[] BOX_CONVERSIONS = ValueConversions.newWrapperCaches(4);
    private static final EnumMap<Wrapper, MethodHandle>[] REBOX_CONVERSIONS = ValueConversions.newWrapperCaches(2);
    private static final EnumMap<Wrapper, MethodHandle>[] ZERO_CONSTANT_FUNCTIONS = ValueConversions.newWrapperCaches(1);
    private static final MethodHandle IDENTITY;
    private static final MethodHandle CAST_REFERENCE;
    private static final MethodHandle ALWAYS_NULL;
    private static final MethodHandle ALWAYS_ZERO;
    private static final MethodHandle ZERO_OBJECT;
    private static final MethodHandle IGNORE;
    private static final MethodHandle EMPTY;
    private static final EnumMap<Wrapper, MethodHandle> WRAPPER_CASTS;
    private static final EnumMap<Wrapper, MethodHandle> EXACT_WRAPPER_CASTS;
    private static final Object[] NO_ARGS_ARRAY;
    static final MethodHandle[] ARRAYS;
    private static final List<Object> NO_ARGS_LIST;
    static final MethodHandle[] LISTS;

    private static EnumMap<Wrapper, MethodHandle>[] newWrapperCaches(int n) {
        EnumMap[] enumMapArray = new EnumMap[n];
        for (int i = 0; i < n; ++i) {
            enumMapArray[i] = new EnumMap(Wrapper.class);
        }
        return enumMapArray;
    }

    static int unboxInteger(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static byte unboxByte(Object object) {
        if (object == null) {
            return 0;
        }
        return (Byte)object;
    }

    static short unboxShort(Object object) {
        if (object == null) {
            return 0;
        }
        return (Short)object;
    }

    static boolean unboxBoolean(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    static char unboxCharacter(Object object) {
        if (object == null) {
            return '\u0000';
        }
        return ((Character)object).charValue();
    }

    static long unboxLong(Object object) {
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    static float unboxFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    static double unboxDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    static int unboxByteRaw(Object object) {
        return ValueConversions.unboxByte(object);
    }

    static int unboxShortRaw(Object object) {
        return ValueConversions.unboxShort(object);
    }

    static int unboxBooleanRaw(Object object) {
        return ValueConversions.unboxBoolean(object) ? 1 : 0;
    }

    static int unboxCharacterRaw(Object object) {
        return ValueConversions.unboxCharacter(object);
    }

    static int unboxFloatRaw(Object object) {
        return Float.floatToIntBits(ValueConversions.unboxFloat(object));
    }

    static long unboxDoubleRaw(Object object) {
        return Double.doubleToRawLongBits(ValueConversions.unboxDouble(object));
    }

    private static MethodType unboxType(Wrapper wrapper, boolean bl) {
        return MethodType.methodType(ValueConversions.rawWrapper(wrapper, bl).primitiveType(), wrapper.wrapperType());
    }

    private static MethodHandle unbox(Wrapper wrapper, boolean bl, boolean bl2) {
        EnumMap<Wrapper, MethodHandle> enumMap = UNBOX_CONVERSIONS[(bl ? 1 : 0) + (bl2 ? 2 : 0)];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                methodHandle = bl2 ? ALWAYS_ZERO : IGNORE;
                break;
            }
            case INT: 
            case LONG: {
                if (!bl2) break;
                methodHandle = ValueConversions.unbox(wrapper, bl, false);
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "unbox" + wrapper.simpleName() + (bl2 ? "Raw" : "");
        MethodType methodType = ValueConversions.unboxType(wrapper, bl2);
        if (!bl) {
            try {
                methodHandle = IMPL_LOOKUP.findStatic(ValueConversions.class, string, methodType.erase());
            }
            catch (NoAccessException noAccessException) {
                methodHandle = null;
            }
        } else {
            methodHandle = ValueConversions.retype(methodType, ValueConversions.unbox(wrapper, !bl, bl2));
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find unbox adapter for " + (Object)((Object)wrapper) + (bl2 ? " (raw)" : ""));
    }

    public static MethodHandle unbox(Wrapper wrapper, boolean bl) {
        return ValueConversions.unbox(wrapper, bl, false);
    }

    public static MethodHandle unboxRaw(Wrapper wrapper, boolean bl) {
        return ValueConversions.unbox(wrapper, bl, true);
    }

    public static MethodHandle unbox(Class<?> clazz, boolean bl) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), bl, false);
    }

    public static MethodHandle unboxRaw(Class<?> clazz, boolean bl) {
        return ValueConversions.unbox(Wrapper.forPrimitiveType(clazz), bl, true);
    }

    static Integer boxInteger(int n) {
        return n;
    }

    static Byte boxByte(byte by) {
        return by;
    }

    static Short boxShort(short s) {
        return s;
    }

    static Boolean boxBoolean(boolean bl) {
        return bl;
    }

    static Character boxCharacter(char c) {
        return Character.valueOf(c);
    }

    static Long boxLong(long l) {
        return l;
    }

    static Float boxFloat(float f) {
        return Float.valueOf(f);
    }

    static Double boxDouble(double d) {
        return d;
    }

    static Byte boxByteRaw(int n) {
        return ValueConversions.boxByte((byte)n);
    }

    static Short boxShortRaw(int n) {
        return ValueConversions.boxShort((short)n);
    }

    static Boolean boxBooleanRaw(int n) {
        return ValueConversions.boxBoolean(n != 0);
    }

    static Character boxCharacterRaw(int n) {
        return ValueConversions.boxCharacter((char)n);
    }

    static Float boxFloatRaw(int n) {
        return ValueConversions.boxFloat(Float.intBitsToFloat(n));
    }

    static Double boxDoubleRaw(long l) {
        return ValueConversions.boxDouble(Double.longBitsToDouble(l));
    }

    static Void boxVoidRaw(int n) {
        return null;
    }

    private static MethodType boxType(Wrapper wrapper, boolean bl) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, ValueConversions.rawWrapper(wrapper, bl).primitiveType());
    }

    private static Wrapper rawWrapper(Wrapper wrapper, boolean bl) {
        if (bl) {
            return wrapper.isDoubleWord() ? Wrapper.LONG : Wrapper.INT;
        }
        return wrapper;
    }

    private static MethodHandle box(Wrapper wrapper, boolean bl, boolean bl2) {
        EnumMap<Wrapper, MethodHandle> enumMap = BOX_CONVERSIONS[(bl ? 1 : 0) + (bl2 ? 2 : 0)];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                if (bl2) break;
                methodHandle = ZERO_OBJECT;
                break;
            }
            case INT: 
            case LONG: {
                if (!bl2) break;
                methodHandle = ValueConversions.box(wrapper, bl, false);
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "box" + wrapper.simpleName() + (bl2 ? "Raw" : "");
        MethodType methodType = ValueConversions.boxType(wrapper, bl2);
        if (bl) {
            try {
                methodHandle = IMPL_LOOKUP.findStatic(ValueConversions.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                methodHandle = null;
            }
        } else {
            methodHandle = ValueConversions.retype(methodType.erase(), ValueConversions.box(wrapper, !bl, bl2));
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find box adapter for " + (Object)((Object)wrapper) + (bl2 ? " (raw)" : ""));
    }

    public static MethodHandle box(Class<?> clazz, boolean bl) {
        return ValueConversions.box(Wrapper.forPrimitiveType(clazz), bl, false);
    }

    public static MethodHandle boxRaw(Class<?> clazz, boolean bl) {
        return ValueConversions.box(Wrapper.forPrimitiveType(clazz), bl, true);
    }

    public static MethodHandle box(Wrapper wrapper, boolean bl) {
        return ValueConversions.box(wrapper, bl, false);
    }

    public static MethodHandle boxRaw(Wrapper wrapper, boolean bl) {
        return ValueConversions.box(wrapper, bl, true);
    }

    static int unboxRawInteger(Object object) {
        if (object instanceof Integer) {
            return ValueConversions.unboxInteger(object);
        }
        return (int)ValueConversions.unboxLong(object);
    }

    static Integer reboxRawInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return (int)ValueConversions.unboxLong(object);
    }

    static Byte reboxRawByte(Object object) {
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return ValueConversions.boxByteRaw(ValueConversions.unboxRawInteger(object));
    }

    static Short reboxRawShort(Object object) {
        if (object instanceof Short) {
            return (Short)object;
        }
        return ValueConversions.boxShortRaw(ValueConversions.unboxRawInteger(object));
    }

    static Boolean reboxRawBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return ValueConversions.boxBooleanRaw(ValueConversions.unboxRawInteger(object));
    }

    static Character reboxRawCharacter(Object object) {
        if (object instanceof Character) {
            return (Character)object;
        }
        return ValueConversions.boxCharacterRaw(ValueConversions.unboxRawInteger(object));
    }

    static Float reboxRawFloat(Object object) {
        if (object instanceof Float) {
            return (Float)object;
        }
        return ValueConversions.boxFloatRaw(ValueConversions.unboxRawInteger(object));
    }

    static Long reboxRawLong(Object object) {
        return (Long)object;
    }

    static Double reboxRawDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        return ValueConversions.boxDoubleRaw(ValueConversions.unboxLong(object));
    }

    private static MethodType reboxType(Wrapper wrapper) {
        Class<?> clazz = wrapper.wrapperType();
        return MethodType.methodType(clazz, Object.class);
    }

    public static MethodHandle rebox(Wrapper wrapper, boolean bl) {
        EnumMap<Wrapper, MethodHandle> enumMap = REBOX_CONVERSIONS[bl ? 1 : 0];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        switch (wrapper) {
            case OBJECT: {
                methodHandle = IDENTITY;
                break;
            }
            case VOID: {
                throw new IllegalArgumentException("cannot rebox a void");
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        String string = "reboxRaw" + wrapper.simpleName();
        MethodType methodType = ValueConversions.reboxType(wrapper);
        if (bl) {
            try {
                methodHandle = IMPL_LOOKUP.findStatic(ValueConversions.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                methodHandle = null;
            }
        } else {
            methodHandle = ValueConversions.retype(IDENTITY.type(), ValueConversions.rebox(wrapper, !bl));
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find rebox adapter for " + (Object)((Object)wrapper));
    }

    public static MethodHandle rebox(Class<?> clazz, boolean bl) {
        return ValueConversions.rebox(Wrapper.forPrimitiveType(clazz), bl);
    }

    static long widenInt(int n) {
        return n;
    }

    static Long widenBoxedInt(Integer n) {
        return (long)n;
    }

    static int narrowLong(long l) {
        return (int)l;
    }

    static Integer narrowBoxedLong(Long l) {
        return (int)l.longValue();
    }

    static void ignore(Object object) {
    }

    static void empty() {
    }

    static Object zeroObject() {
        return null;
    }

    static int zeroInteger() {
        return 0;
    }

    static long zeroLong() {
        return 0L;
    }

    static float zeroFloat() {
        return 0.0f;
    }

    static double zeroDouble() {
        return 0.0;
    }

    public static MethodHandle zeroConstantFunction(Wrapper wrapper) {
        EnumMap<Wrapper, MethodHandle> enumMap = ZERO_CONSTANT_FUNCTIONS[0];
        MethodHandle methodHandle = enumMap.get((Object)wrapper);
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = MethodType.methodType(wrapper.primitiveType());
        switch (wrapper) {
            case VOID: {
                methodHandle = EMPTY;
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                try {
                    methodHandle = IMPL_LOOKUP.findStatic(ValueConversions.class, "zero" + wrapper.simpleName(), methodType);
                    break;
                }
                catch (NoAccessException noAccessException) {
                    methodHandle = null;
                }
            }
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        Wrapper wrapper2 = wrapper.rawPrimitive();
        if (wrapper2 != wrapper) {
            methodHandle = ValueConversions.retype(methodType, ValueConversions.zeroConstantFunction(wrapper2));
        }
        if (methodHandle != null) {
            enumMap.put(wrapper, methodHandle);
            return methodHandle;
        }
        throw new IllegalArgumentException("cannot find zero constant for " + (Object)((Object)wrapper));
    }

    static Object alwaysNull(Object object) {
        return null;
    }

    static int alwaysZero(Object object) {
        return 0;
    }

    static <T> T identity(T t) {
        return t;
    }

    static <T, U> T castReference(Class<? extends T> clazz, U u) {
        return clazz.cast(u);
    }

    public static MethodHandle cast(Class<?> clazz, boolean bl) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("cannot cast primitive type " + clazz);
        }
        MethodHandle methodHandle = null;
        Wrapper wrapper = null;
        EnumMap<Wrapper, MethodHandle> enumMap = null;
        if (Wrapper.isWrapperType(clazz) && (methodHandle = (enumMap = bl ? EXACT_WRAPPER_CASTS : WRAPPER_CASTS).get((Object)(wrapper = Wrapper.forWrapperType(clazz)))) != null) {
            return methodHandle;
        }
        methodHandle = VerifyType.isNullReferenceConversion(Object.class, clazz) ? IDENTITY : (VerifyType.isNullType(clazz) ? ALWAYS_NULL : MethodHandles.insertArguments(CAST_REFERENCE, 0, clazz));
        if (bl) {
            MethodType methodType = MethodType.methodType(clazz, Object.class);
            methodHandle = AdapterMethodHandle.makeRetypeRaw(IMPL_TOKEN, methodType, methodHandle);
        }
        if (enumMap != null) {
            enumMap.put(wrapper, methodHandle);
        }
        return methodHandle;
    }

    public static MethodHandle identity() {
        return IDENTITY;
    }

    private static MethodHandle retype(MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetypeOnly(IMPL_TOKEN, methodType, methodHandle);
    }

    private static Object[] makeArray(Object ... objectArray) {
        return objectArray;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object object) {
        return ValueConversions.makeArray(object);
    }

    private static Object[] array(Object object, Object object2) {
        return ValueConversions.makeArray(object, object2);
    }

    private static Object[] array(Object object, Object object2, Object object3) {
        return ValueConversions.makeArray(object, object2, object3);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeArray(object, object2, object3, object4);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static Object[] array(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeArray(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    static MethodHandle[] makeArrays() {
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        MethodHandles.Lookup lookup = IMPL_LOOKUP;
        while (true) {
            int n = arrayList.size();
            MethodType methodType = MethodType.genericMethodType(n).changeReturnType(Object[].class);
            String string = "array";
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findStatic(ValueConversions.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                // empty catch block
            }
            if (methodHandle == null) break;
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[0]);
    }

    public static MethodHandle varargsArray(int n) {
        if (n < ARRAYS.length) {
            return ARRAYS[n];
        }
        throw new UnsupportedOperationException("NYI: cannot form a varargs array of length " + n);
    }

    private static List<Object> makeList(Object ... objectArray) {
        return Arrays.asList(objectArray);
    }

    private static List<Object> list() {
        return NO_ARGS_LIST;
    }

    private static List<Object> list(Object object) {
        return ValueConversions.makeList(object);
    }

    private static List<Object> list(Object object, Object object2) {
        return ValueConversions.makeList(object, object2);
    }

    private static List<Object> list(Object object, Object object2, Object object3) {
        return ValueConversions.makeList(object, object2, object3);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4) {
        return ValueConversions.makeList(object, object2, object3, object4);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return ValueConversions.makeList(object, object2, object3, object4, object5);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    private static List<Object> list(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return ValueConversions.makeList(object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    static MethodHandle[] makeLists() {
        ArrayList<MethodHandle> arrayList = new ArrayList<MethodHandle>();
        MethodHandles.Lookup lookup = IMPL_LOOKUP;
        while (true) {
            int n = arrayList.size();
            MethodType methodType = MethodType.genericMethodType(n).changeReturnType(List.class);
            String string = "list";
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findStatic(ValueConversions.class, string, methodType);
            }
            catch (NoAccessException noAccessException) {
                // empty catch block
            }
            if (methodHandle == null) break;
            arrayList.add(methodHandle);
        }
        assert (arrayList.size() == 11);
        return arrayList.toArray(new MethodHandle[0]);
    }

    public static MethodHandle varargsList(int n) {
        if (n < LISTS.length) {
            return LISTS[n];
        }
        throw new UnsupportedOperationException("NYI");
    }

    static {
        try {
            MethodType methodType = MethodType.genericMethodType(1);
            MethodType methodType2 = methodType.insertParameterTypes(0, Class.class);
            MethodType methodType3 = methodType.changeReturnType(Integer.TYPE);
            MethodType methodType4 = methodType.changeReturnType(Void.TYPE);
            MethodType methodType5 = MethodType.genericMethodType(0);
            IDENTITY = IMPL_LOOKUP.findStatic(ValueConversions.class, "identity", methodType);
            CAST_REFERENCE = IMPL_LOOKUP.findStatic(ValueConversions.class, "castReference", methodType2);
            ALWAYS_NULL = IMPL_LOOKUP.findStatic(ValueConversions.class, "alwaysNull", methodType);
            ALWAYS_ZERO = IMPL_LOOKUP.findStatic(ValueConversions.class, "alwaysZero", methodType3);
            ZERO_OBJECT = IMPL_LOOKUP.findStatic(ValueConversions.class, "zeroObject", methodType5);
            IGNORE = IMPL_LOOKUP.findStatic(ValueConversions.class, "ignore", methodType4);
            EMPTY = IMPL_LOOKUP.findStatic(ValueConversions.class, "empty", methodType4.dropParameterTypes(0, 1));
        }
        catch (Exception exception) {
            throw MemberName.uncaughtException(exception);
        }
        WRAPPER_CASTS = new EnumMap(Wrapper.class);
        EXACT_WRAPPER_CASTS = new EnumMap(Wrapper.class);
        NO_ARGS_ARRAY = new Object[0];
        ARRAYS = ValueConversions.makeArrays();
        NO_ARGS_LIST = Arrays.asList(NO_ARGS_ARRAY);
        LISTS = ValueConversions.makeLists();
    }
}

