/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.WrongMethodTypeException;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.DirectMethodHandle;
import sun.dyn.JavaMethodHandle;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleNatives;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;

public class BoundMethodHandle
extends MethodHandle {
    private final Object argument;
    private final int vmargslot;
    private static final Access IMPL_TOKEN = Access.getToken();
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory(IMPL_TOKEN);

    BoundMethodHandle(DirectMethodHandle directMethodHandle, Object object) {
        super(Access.TOKEN, directMethodHandle.type().dropParameterTypes(0, 1));
        this.argument = BoundMethodHandle.checkReferenceArgument(object, directMethodHandle, 0);
        this.vmargslot = this.type().parameterSlotCount();
        if (MethodHandleNatives.JVM_SUPPORT) {
            this.vmtarget = null;
            MethodHandleNatives.init(this, (Object)directMethodHandle, 0);
        } else {
            this.vmtarget = directMethodHandle;
        }
    }

    BoundMethodHandle(MethodHandle methodHandle, Object object, int n) {
        this(methodHandle.type().dropParameterTypes(n, n + 1), methodHandle, object, n);
    }

    BoundMethodHandle(MethodType methodType, MethodHandle methodHandle, Object object, int n) {
        super(Access.TOKEN, methodType);
        this.argument = methodHandle.type().parameterType(n).isPrimitive() ? BoundMethodHandle.bindPrimitiveArgument(object, methodHandle, n) : BoundMethodHandle.checkReferenceArgument(object, methodHandle, n);
        this.vmargslot = methodType.parameterSlotDepth(n);
        this.initTarget(methodHandle, n);
    }

    private void initTarget(MethodHandle methodHandle, int n) {
        if (MethodHandleNatives.JVM_SUPPORT) {
            this.vmtarget = null;
            MethodHandleNatives.init(this, (Object)methodHandle, n);
        } else {
            this.vmtarget = methodHandle;
        }
    }

    BoundMethodHandle(MethodType methodType, Object object, int n) {
        super(Access.TOKEN, methodType);
        this.argument = object;
        this.vmargslot = n;
        assert (this.getClass() == AdapterMethodHandle.class);
    }

    protected BoundMethodHandle(MethodHandle methodHandle) {
        super(Access.TOKEN, methodHandle.type().dropParameterTypes(0, 1));
        this.argument = this;
        this.vmargslot = this.type().parameterSlotDepth(0);
        this.initTarget(methodHandle, 0);
        assert (this instanceof JavaMethodHandle);
    }

    static final Object checkReferenceArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        if (!clazz.isPrimitive()) {
            if (object == null) {
                return null;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), clazz)) {
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final Object bindPrimitiveArgument(Object object, MethodHandle methodHandle, int n) {
        Class<?> clazz = methodHandle.type().parameterType(n);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
        Object object2 = wrapper.zero();
        if (object2 != null) {
            if (object == null) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return 0;
                }
                return object2;
            }
            if (VerifyType.isNullReferenceConversion(object.getClass(), object2.getClass())) {
                if (clazz != Integer.TYPE && wrapper.isSubwordOrInt()) {
                    return Wrapper.INT.wrap(object);
                }
                return object;
            }
        }
        throw BoundMethodHandle.badBoundArgumentException(object, methodHandle, n);
    }

    static final RuntimeException badBoundArgumentException(Object object, MethodHandle methodHandle, int n) {
        String string = object == null ? "null" : object.getClass().toString();
        return new WrongMethodTypeException("cannot bind " + string + " argument to parameter #" + n + " of " + methodHandle.type());
    }

    @Override
    public String toString() {
        MethodHandle methodHandle = this;
        while (methodHandle instanceof BoundMethodHandle) {
            Object object = MethodHandleNatives.getTargetInfo(methodHandle);
            if (!(object instanceof MethodHandle)) {
                String string = null;
                if (object instanceof MemberName) {
                    string = ((MemberName)object).getName();
                }
                if (string != null) {
                    return string;
                }
                return super.toString();
            }
            methodHandle = (MethodHandle)object;
            assert (methodHandle != this);
            if (!(methodHandle instanceof JavaMethodHandle)) continue;
            break;
        }
        return ((MethodHandle)methodHandle).toString();
    }
}

