/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Set;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.font.FontDesignMetrics;
import sun.java2d.BackBufferCapsProvider;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

public class XComponentPeer
extends XWindow
implements ComponentPeer,
DropTargetPeer,
BackBufferCapsProvider {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XComponentPeer");
    private static final PlatformLogger buffersLog = PlatformLogger.getLogger("sun.awt.X11.XComponentPeer.multibuffer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XComponentPeer");
    private static final PlatformLogger fontLog = PlatformLogger.getLogger("sun.awt.X11.font.XComponentPeer");
    private static final PlatformLogger enableLog = PlatformLogger.getLogger("sun.awt.X11.enable.XComponentPeer");
    private static final PlatformLogger shapeLog = PlatformLogger.getLogger("sun.awt.X11.shape.XComponentPeer");
    boolean paintPending = false;
    boolean isLayouting = false;
    boolean enabled;
    protected int boundsOperation;
    Color foreground;
    Color background;
    Color darkShadow;
    Color lightShadow;
    Color selectColor;
    Font font;
    private long backBuffer = 0L;
    private VolatileImage xBackBuffer = null;
    static Color[] systemColors;
    boolean bHasFocus = false;
    private static Class seClass;
    private static Constructor seCtor;
    static final int BACKGROUND_COLOR = 0;
    static final int HIGHLIGHT_COLOR = 1;
    static final int SHADOW_COLOR = 2;
    static final int FOREGROUND_COLOR = 3;
    private BufferCapabilities backBufferCaps;

    XComponentPeer() {
    }

    XComponentPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XComponentPeer(Component component, long l, Rectangle rectangle) {
        super(component, l, rectangle);
    }

    XComponentPeer(Component component) {
        super(component);
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.boundsOperation = 3;
    }

    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        Serializable serializable;
        super.postInit(xCreateWindowParams);
        this.pSetCursor(this.target.getCursor());
        this.foreground = this.target.getForeground();
        this.background = this.target.getBackground();
        this.font = this.target.getFont();
        if (this.isInitialReshape()) {
            serializable = this.target.getBounds();
            this.reshape(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
        }
        this.enabled = this.target.isEnabled();
        serializable = this.target;
        while (serializable != null && !(serializable instanceof Window)) {
            if ((serializable = ((Component)serializable).getParent()) == null || ((Component)serializable).isEnabled() || ((Component)serializable).isLightweight()) continue;
            this.setEnabled(false);
            break;
        }
        enableLog.fine("Initial enable state: {0}", this.enabled);
        if (this.target.isVisible()) {
            this.setVisible(true);
        }
    }

    protected boolean isInitialReshape() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reparent(ContainerPeer containerPeer) {
        XComponentPeer xComponentPeer = (XComponentPeer)((Object)containerPeer);
        XToolkit.awtLock();
        try {
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.getWindow(), xComponentPeer.getContentWindow(), this.x, this.y);
            this.parentWindow = xComponentPeer;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public boolean isReparentSupported() {
        return System.getProperty("sun.awt.X11.XComponentPeer.reparentNotSupported", "false").equals("false");
    }

    @Override
    public boolean isObscured() {
        XWindowPeer xWindowPeer;
        Container container;
        Container container2;
        Container container3 = container2 = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container2 == null) {
            return true;
        }
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        if (container2 instanceof Window && (xWindowPeer = (XWindowPeer)container2.getPeer()) != null) {
            XWindowAttributesData cfr_ignored_0 = xWindowPeer.winAttr;
            return xWindowPeer.winAttr.visibilityState != XWindowAttributesData.AWT_UNOBSCURED;
        }
        return true;
    }

    @Override
    public boolean canDetermineObscurity() {
        return true;
    }

    public final boolean hasFocus() {
        return this.bHasFocus;
    }

    public void focusGained(FocusEvent focusEvent) {
        focusLog.fine("{0}", focusEvent);
        this.bHasFocus = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        focusLog.fine("{0}", focusEvent);
        this.bHasFocus = false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    static final AWTEvent wrapInSequenced(AWTEvent aWTEvent) {
        block10: {
            try {
                if (seClass == null) {
                    seClass = Class.forName("java.awt.SequencedEvent");
                }
                if (seCtor == null) {
                    seCtor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Constructor constructor = seClass.getConstructor(AWTEvent.class);
                            constructor.setAccessible(true);
                            return constructor;
                        }
                    });
                }
                return (AWTEvent)seCtor.newInstance(aWTEvent);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (InstantiationException instantiationException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        return null;
    }

    @Override
    public final boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        if (XKeyboardFocusManagerPeer.processSynchronousLightweightTransfer(this.target, component, bl, bl2, l)) {
            return true;
        }
        int n = XKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.target, component, bl, bl2, l, cause);
        switch (n) {
            case 0: {
                return false;
            }
            case 2: {
                Window window;
                if (focusLog.isLoggable(400)) {
                    focusLog.finer("Proceeding with request to " + component + " in " + this.target);
                }
                if ((window = SunToolkit.getContainingWindow(this.target)) == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window is null");
                }
                XWindowPeer xWindowPeer = (XWindowPeer)window.getPeer();
                if (xWindowPeer == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window's peer is null");
                }
                boolean bl3 = xWindowPeer.requestWindowFocus(null);
                if (focusLog.isLoggable(400)) {
                    focusLog.finer("Requested window focus: " + bl3);
                }
                if (!bl3 || !window.isFocused()) {
                    return this.rejectFocusRequestHelper("Waiting for asynchronous processing of the request");
                }
                return XKeyboardFocusManagerPeer.deliverFocus(component, this.target, bl, bl2, l, cause);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean rejectFocusRequestHelper(String string) {
        if (focusLog.isLoggable(400)) {
            focusLog.finer(string);
        }
        XKeyboardFocusManagerPeer.removeLastFocusRequest(this.target);
        return false;
    }

    void handleJavaFocusEvent(AWTEvent aWTEvent) {
        if (focusLog.isLoggable(400)) {
            focusLog.finer(aWTEvent.toString());
        }
        if (aWTEvent.getID() == 1004) {
            this.focusGained((FocusEvent)aWTEvent);
        } else {
            this.focusLost((FocusEvent)aWTEvent);
        }
    }

    void handleJavaWindowFocusEvent(AWTEvent aWTEvent) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.xSetVisible(bl);
    }

    public void hide() {
        this.setVisible(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        enableLog.fine("{0}ing {1}", bl ? "Enabl" : "Disabl", this);
        boolean bl2 = this.enabled != bl;
        this.enabled = bl;
        if (this.target instanceof Container) {
            Component[] componentArray = ((Container)this.target).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                boolean bl3 = componentArray[i].isEnabled();
                ComponentPeer componentPeer = componentArray[i].getPeer();
                if (componentPeer == null) continue;
                componentPeer.setEnabled(bl && bl3);
            }
        }
        if (bl2) {
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void paint(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.repaint();
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.getPeerForeground(), this.getPeerBackground(), this.getPeerFont());
    }

    @Override
    public void print(Graphics graphics) {
        graphics.setColor(this.target.getBackground());
        graphics.fillRect(0, 0, this.target.getWidth(), this.target.getHeight());
        graphics.setColor(this.target.getForeground());
        this.paint(graphics);
        this.target.print(graphics);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.xSetBounds(n, n2, n3, n4);
        this.validateSurface();
        this.layout();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    @Override
    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        if (!(paintEvent instanceof IgnorePaintEvent)) {
            this.paintArea.add(rectangle, paintEvent.getID());
        }
        switch (paintEvent.getID()) {
            case 801: {
                log.finer("XCP coalescePaintEvent : UPDATE : add : x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ",height = " + rectangle.height);
                return;
            }
            case 800: {
                log.finer("XCP coalescePaintEvent : PAINT : add : x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ",height = " + rectangle.height);
                return;
            }
        }
    }

    XWindowPeer getParentTopLevel() {
        Container container;
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        Container container2 = container = this.target instanceof Container ? (Container)this.target : componentAccessor.getParent(this.target);
        while (container != null && !(container instanceof Window)) {
            container = componentAccessor.getParent(container);
        }
        if (container != null) {
            return (XWindowPeer)componentAccessor.getPeer(container);
        }
        return null;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.target != mouseEvent.getSource() || this.target.isFocusOwner() || !XKeyboardFocusManagerPeer.shouldFocusOnClick(this.target)) break;
                XWindowPeer xWindowPeer = this.getParentTopLevel();
                Window window = (Window)xWindowPeer.getTarget();
                XKeyboardFocusManagerPeer.requestFocusFor(this.target, CausedFocusEvent.Cause.MOUSE_EVENT);
            }
        }
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
    }

    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
    }

    void handleF10JavaKeyEvent(KeyEvent keyEvent) {
        XMenuBarPeer xMenuBarPeer;
        XWindowPeer xWindowPeer;
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 121 && (xWindowPeer = this.getToplevelXWindow()) instanceof XFramePeer && (xMenuBarPeer = ((XFramePeer)xWindowPeer).getMenubarPeer()) != null) {
            xMenuBarPeer.handleF10KeyPress(keyEvent);
        }
    }

    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent && !((InputEvent)aWTEvent).isConsumed() && this.target.isEnabled()) {
            if (aWTEvent instanceof MouseEvent) {
                if (aWTEvent instanceof MouseWheelEvent) {
                    this.handleJavaMouseWheelEvent((MouseWheelEvent)aWTEvent);
                } else {
                    this.handleJavaMouseEvent((MouseEvent)aWTEvent);
                }
            } else if (aWTEvent instanceof KeyEvent) {
                this.handleF10JavaKeyEvent((KeyEvent)aWTEvent);
                this.handleJavaKeyEvent((KeyEvent)aWTEvent);
            }
        } else if (aWTEvent instanceof KeyEvent && !((InputEvent)aWTEvent).isConsumed()) {
            this.handleF10JavaKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.handleJavaInputMethodEvent((InputMethodEvent)aWTEvent);
        }
        int n = aWTEvent.getID();
        switch (n) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent(aWTEvent);
                break;
            }
            case 207: 
            case 208: {
                this.handleJavaWindowFocusEvent(aWTEvent);
                break;
            }
        }
    }

    @Override
    public void handleButtonPressRelease(XEvent xEvent) {
        if (xEvent.get_type() == 4) {
            final XWindowPeer xWindowPeer = this.getParentTopLevel();
            Window window = (Window)xWindowPeer.getTarget();
            if (xWindowPeer.isFocusableWindow() && xWindowPeer.isSimpleWindow() && XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow() != window) {
                this.postEvent(new InvocationEvent((Object)window, new Runnable(){

                    @Override
                    public void run() {
                        xWindowPeer.requestXFocus();
                    }
                }));
            }
        }
        super.handleButtonPressRelease(xEvent);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void layout() {
    }

    @Override
    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    void updateMotifColors(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.darkShadow = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(n, n2, n3));
        this.lightShadow = new Color(MotifColorUtilities.calculateTopShadowFromBackground(n, n2, n3));
        this.selectColor = new Color(MotifColorUtilities.calculateSelectFromBackground(n, n2, n3));
    }

    public void drawMotif3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(bl ? this.darkShadow : this.lightShadow);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2 + n4, n, n2);
        graphics.setColor(bl ? this.lightShadow : this.darkShadow);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4, n + n3, n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color color) {
        if (log.isLoggable(500)) {
            log.fine("Set background to " + color);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.background = color;
        }
        super.setBackground(color);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForeground(Color color) {
        if (log.isLoggable(500)) {
            log.fine("Set foreground to " + color);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.foreground = color;
        }
        this.repaint();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (fontLog.isLoggable(500)) {
            fontLog.fine("Getting font metrics for " + font);
        }
        return FontDesignMetrics.getMetrics(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (font == null) {
                font = XWindow.getDefaultFont();
            }
            this.font = font;
        }
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void updateCursorImmediately() {
        XGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pSetCursor(Cursor cursor) {
        XToolkit.awtLock();
        try {
            long l = XGlobalCursorManager.getCursor(cursor);
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.set_cursor(l);
            long l2 = 16384L;
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), this.getWindow(), l2, xSetWindowAttributes.pData);
            XlibWrapper.XFlush(XToolkit.getDisplay());
            xSetWindowAttributes.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    @Override
    public Image createImage(int n, int n2) {
        return this.graphicsConfig.createAcceleratedImage(this.target, n, n2);
    }

    @Override
    public VolatileImage createVolatileImage(int n, int n2) {
        return new SunVolatileImage(this.target, n, n2);
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public Insets insets() {
        return this.getInsets();
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || AWTAccessor.getComponentAccessor().getIgnoreRepaint(this.target))) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    @Override
    public Color getWinBackground() {
        return this.getPeerBackground();
    }

    static int[] getRGBvals(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        return nArray;
    }

    public Color[] getGUIcolors() {
        Color[] colorArray = new Color[4];
        colorArray[0] = this.getWinBackground();
        if (colorArray[0] == null) {
            colorArray[0] = super.getWinBackground();
        }
        if (colorArray[0] == null) {
            colorArray[0] = Color.lightGray;
        }
        int[] nArray = XComponentPeer.getRGBvals(colorArray[0]);
        float[] fArray = Color.RGBtoHSB(nArray[0], nArray[1], nArray[2], null);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = f3 + 0.2f;
        float f5 = f3 - 0.4f;
        if ((double)f4 > 1.0) {
            f4 = 1.0 - (double)f3 < 0.05 ? f5 + 0.25f : 1.0f;
        } else if ((double)f5 < 0.0) {
            if ((double)f3 - 0.0 < 0.25) {
                f4 = f3 + 0.75f;
                f5 = f4 - 0.2f;
            } else {
                f5 = 0.0f;
            }
        }
        colorArray[1] = Color.getHSBColor(f, f2, f4);
        colorArray[2] = Color.getHSBColor(f, f2, f5);
        colorArray[3] = this.getPeerForeground();
        if (colorArray[3] == null) {
            colorArray[3] = Color.black;
        }
        if (!this.isEnabled()) {
            colorArray[0] = colorArray[0].darker();
            Color color = colorArray[0];
            int n = color.getRed() * 30 + color.getGreen() * 59 + color.getBlue() * 11;
            color = colorArray[3];
            int n2 = color.getRed() * 30 + color.getGreen() * 59 + color.getBlue() * 11;
            float f6 = (float)((double)(n2 + n) / 51000.0);
            Color color2 = new Color((int)((float)color.getRed() * f6), (int)((float)color.getGreen() * f6), (int)((float)color.getBlue() * f6));
            if (color2.equals(colorArray[3])) {
                color2 = new Color(f6, f6, f6);
            }
            colorArray[3] = color2;
        }
        return colorArray;
    }

    static Color[] getSystemColors() {
        if (systemColors == null) {
            systemColors = new Color[4];
            XComponentPeer.systemColors[0] = SystemColor.window;
            XComponentPeer.systemColors[1] = SystemColor.controlLtHighlight;
            XComponentPeer.systemColors[2] = SystemColor.controlShadow;
            XComponentPeer.systemColors[3] = SystemColor.windowText;
        }
        return systemColors;
    }

    public void draw3DOval(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        graphics.setColor(bl ? colorArray[1] : colorArray[2]);
        graphics.drawArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(bl ? colorArray[2] : colorArray[1]);
        graphics.drawArc(n, n2, n3, n4, 225, 180);
        graphics.setColor(color);
    }

    public void draw3DRect(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        graphics.setColor(bl ? colorArray[1] : colorArray[2]);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? colorArray[2] : colorArray[1]);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color);
    }

    void draw3DOval(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawArc(n, n2, n3, n4, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color2 = graphics.getColor();
        double d = (double)(n2 - 2 * (n - 1)) / (double)Math.max(1, n4 - n3 + n6);
        int n7 = n + (int)(d * (double)(n5 - n3));
        int n8 = (int)(d * (double)n6);
        int n9 = n - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n2 < 3 * n9) {
            n8 = 0;
            n7 = 0;
            if (n2 < 2 * n9 + 2) {
                n9 = (n2 - 2) / 2;
            }
        } else if (n8 < 7) {
            n7 = Math.max(0, n7 - (7 - n8 >> 1));
            n8 = 7;
        }
        int n10 = n / 2;
        int n11 = n10 - n9 / 2;
        int n12 = n10 + n9 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl) {
            graphics.fillRect(0, 0, n2, n);
        } else {
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color);
        if (n7 > 0) {
            if (bl) {
                graphics.fillRect(n7, 3, n8, n - 3);
            } else {
                graphics.fillRect(3, n7, n - 3, n8);
            }
        }
        nArray[0] = n10;
        nArray2[0] = 2;
        nArray[1] = n11;
        nArray2[1] = n9;
        nArray[2] = n12;
        nArray2[2] = n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n2 - 2;
        nArray2[1] = n2 - n9;
        nArray2[2] = n2 - n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl) {
            graphics.drawLine(1, n, n2 - 1, n);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n);
            graphics.drawLine(1, n10, n9, n11);
            graphics.drawLine(n2 - n9, n11, n2 - n9, n12);
            graphics.drawLine(n2 - n9, n11, n2 - 2, n10);
        } else {
            graphics.drawLine(n, 1, n, n2 - 1);
            graphics.drawLine(1, n2 - 1, n, n2 - 1);
            graphics.drawLine(n10, 1, n11, n9);
            graphics.drawLine(n11, n2 - n9, n12, n2 - n9);
            graphics.drawLine(n11, n2 - n9, n10, n2 - 2);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7, 2, n7 + n8, 2);
                graphics.drawLine(n7, 2, n7, n - 3);
            } else {
                graphics.drawLine(2, n7, 2, n7 + n8);
                graphics.drawLine(2, n7, n - 3, n7);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl) {
            graphics.drawLine(0, 0, 0, n);
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(n9, n11, n9, n12);
            graphics.drawLine(n9, n12, 1, n10);
            graphics.drawLine(n2 - 2, n10, n2 - n9, n12);
        } else {
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n11, n9, n12, n9);
            graphics.drawLine(n12, n9, n10, 1);
            graphics.drawLine(n10, n2 - 2, n12, n2 - n9);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7 + n8, 2, n7 + n8, n - 2);
                graphics.drawLine(n7, n - 2, n7 + n8, n - 2);
            } else {
                graphics.drawLine(2, n7 + n8, n - 2, n7 + n8);
                graphics.drawLine(n - 2, n7, n - 2, n7 + n8);
            }
        }
        graphics.setColor(color2);
    }

    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (buffersLog.isLoggable(500)) {
            buffersLog.fine("createBuffers(" + n + ", " + bufferCapabilities + ")");
        }
        this.backBufferCaps = bufferCapabilities;
        this.backBuffer = this.graphicsConfig.createBackBuffer(this, n, bufferCapabilities);
        this.xBackBuffer = this.graphicsConfig.createBackBufferImage(this.target, this.backBuffer);
    }

    @Override
    public BufferCapabilities getBackBufferCaps() {
        return this.backBufferCaps;
    }

    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        if (buffersLog.isLoggable(500)) {
            buffersLog.fine("flip(" + flipContents + ")");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        this.graphicsConfig.flip(this, this.target, this.xBackBuffer, n, n2, n3, n4, flipContents);
    }

    @Override
    public Image getBackBuffer() {
        if (buffersLog.isLoggable(500)) {
            buffersLog.fine("getBackBuffer()");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    @Override
    public void destroyBuffers() {
        if (buffersLog.isLoggable(500)) {
            buffersLog.fine("destroyBuffers()");
        }
        this.graphicsConfig.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    public void notifyTextComponentChange(boolean bl) {
        Container container = AWTAccessor.getComponentAccessor().getParent(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = AWTAccessor.getComponentAccessor().getParent(container);
        }
    }

    @Override
    protected boolean isEventDisabled(XEvent xEvent) {
        enableLog.finest("Component is {1}, checking for disabled event {0}", xEvent, this.isEnabled() ? "enabled" : "disable");
        if (!this.isEnabled()) {
            switch (xEvent.get_type()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    enableLog.finer("Event {0} is disable", xEvent);
                    return true;
                }
            }
        }
        switch (xEvent.get_type()) {
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(xEvent);
    }

    Color getPeerBackground() {
        return this.background;
    }

    Color getPeerForeground() {
        return this.foreground;
    }

    Font getPeerFont() {
        return this.font;
    }

    Dimension getPeerSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoundsOperation(int n) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.boundsOperation == 3) {
                this.boundsOperation = n;
            } else if (n == 5) {
                this.boundsOperation = 3;
            }
        }
    }

    static String operationToString(int n) {
        switch (n) {
            case 1: {
                return "SET_LOCATION";
            }
            case 2: {
                return "SET_SIZE";
            }
            case 4: {
                return "SET_CLIENT_SIZE";
            }
        }
        return "SET_BOUNDS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZOrder(ComponentPeer componentPeer) {
        long l = componentPeer != null ? ((XComponentPeer)componentPeer).getWindow() : 0L;
        XToolkit.awtLock();
        try {
            XlibWrapper.SetZOrder(XToolkit.getDisplay(), this.getWindow(), l);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void addTree(Collection collection, Set set, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            ComponentPeer componentPeer = component.getPeer();
            if (componentPeer instanceof XComponentPeer) {
                Long l = ((XComponentPeer)componentPeer).getWindow();
                if (set.contains(l)) continue;
                set.add(l);
                collection.add(l);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.addTree(collection, set, (Container)component);
        }
    }

    @Override
    public void addDropTarget(DropTarget dropTarget) {
        XWindowPeer xWindowPeer;
        Component component;
        for (component = this.target; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component instanceof Window && (xWindowPeer = (XWindowPeer)component.getPeer()) != null) {
            xWindowPeer.addDropTarget();
        }
    }

    @Override
    public void removeDropTarget(DropTarget dropTarget) {
        XWindowPeer xWindowPeer;
        Component component;
        for (component = this.target; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component instanceof Window && (xWindowPeer = (XWindowPeer)component.getPeer()) != null) {
            xWindowPeer.removeDropTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyShape(Region region) {
        if (XlibUtil.isShapingSupported()) {
            if (shapeLog.isLoggable(400)) {
                shapeLog.finer("*** INFO: Setting shape: PEER: " + this + "; WINDOW: " + this.getWindow() + "; TARGET: " + this.target + "; SHAPE: " + region);
            }
            XToolkit.awtLock();
            try {
                if (region != null) {
                    XlibWrapper.SetRectangularShape(XToolkit.getDisplay(), this.getWindow(), region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region);
                }
                XlibWrapper.SetRectangularShape(XToolkit.getDisplay(), this.getWindow(), 0, 0, 0, 0, null);
            }
            finally {
                XToolkit.awtUnlock();
            }
        } else if (shapeLog.isLoggable(400)) {
            shapeLog.finer("*** WARNING: Shaping is NOT supported!");
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        int n = -1;
        int n2 = -1;
        if (this.graphicsConfig != null) {
            n = this.graphicsConfig.getVisual();
        }
        if (graphicsConfiguration != null && graphicsConfiguration instanceof X11GraphicsConfig) {
            n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        }
        if (n != -1 && n != n2) {
            return true;
        }
        this.initGraphicsConfiguration();
        this.doValidateSurface();
        return false;
    }
}

