/*
 * Decompiled with CFR 0.152.
 */
package java.util;

final class DualPivotQuicksort {
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 29;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 3200;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    public static void sort(int[] nArray) {
        DualPivotQuicksort.sort(nArray, 0, nArray.length - 1, true);
    }

    public static void sort(int[] nArray, int n, int n2) {
        DualPivotQuicksort.sort(nArray, n, n2, true);
    }

    private static void sort(int[] nArray, int n, int n2, boolean bl) {
        int n3;
        int n4 = n2 - n + 1;
        if (n4 < 47) {
            if (bl) {
                int n5;
                int n6 = n5 = n;
                while (n5 < n2) {
                    int n7 = nArray[n5 + 1];
                    while (n7 < nArray[n6]) {
                        nArray[n6 + 1] = nArray[n6];
                        if (n6-- != n) continue;
                    }
                    nArray[n6 + 1] = n7;
                    n6 = ++n5;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (nArray[n - 1] <= nArray[n]);
                int n8 = n--;
                while ((n += 2) <= n2) {
                    int n9;
                    int n10;
                    n8 = n - 1;
                    if (nArray[n8] < nArray[n]) {
                        n10 = nArray[n8];
                        n9 = nArray[n];
                    } else {
                        n9 = nArray[n8];
                        n10 = nArray[n];
                    }
                    while (n9 < nArray[--n8]) {
                        nArray[n8 + 2] = nArray[n8];
                    }
                    nArray[++n8 + 1] = n9;
                    while (n10 < nArray[--n8]) {
                        nArray[n8 + 1] = nArray[n8];
                    }
                    nArray[n8 + 1] = n10;
                }
                n8 = nArray[n2];
                while (n8 < nArray[--n2]) {
                    nArray[n2 + 1] = nArray[n2];
                }
                nArray[n2 + 1] = n8;
            }
            return;
        }
        int n11 = (n4 >> 3) + (n4 >> 6) + 1;
        int n12 = n + n2 >>> 1;
        int n13 = n12 - n11;
        int n14 = n13 - n11;
        int n15 = n12 + n11;
        int n16 = n15 + n11;
        if (nArray[n13] < nArray[n14]) {
            n3 = nArray[n13];
            nArray[n13] = nArray[n14];
            nArray[n14] = n3;
        }
        if (nArray[n12] < nArray[n13]) {
            n3 = nArray[n12];
            nArray[n12] = nArray[n13];
            nArray[n13] = n3;
            if (n3 < nArray[n14]) {
                nArray[n13] = nArray[n14];
                nArray[n14] = n3;
            }
        }
        if (nArray[n15] < nArray[n12]) {
            n3 = nArray[n15];
            nArray[n15] = nArray[n12];
            nArray[n12] = n3;
            if (n3 < nArray[n13]) {
                nArray[n12] = nArray[n13];
                nArray[n13] = n3;
                if (n3 < nArray[n14]) {
                    nArray[n13] = nArray[n14];
                    nArray[n14] = n3;
                }
            }
        }
        if (nArray[n16] < nArray[n15]) {
            n3 = nArray[n16];
            nArray[n16] = nArray[n15];
            nArray[n15] = n3;
            if (n3 < nArray[n12]) {
                nArray[n15] = nArray[n12];
                nArray[n12] = n3;
                if (n3 < nArray[n13]) {
                    nArray[n12] = nArray[n13];
                    nArray[n13] = n3;
                    if (n3 < nArray[n14]) {
                        nArray[n13] = nArray[n14];
                        nArray[n14] = n3;
                    }
                }
            }
        }
        n3 = nArray[n13];
        int n17 = nArray[n15];
        int n18 = n;
        int n19 = n2;
        if (n3 != n17) {
            int n20;
            nArray[n13] = nArray[n];
            nArray[n15] = nArray[n2];
            while (nArray[++n18] < n3) {
            }
            while (nArray[--n19] > n17) {
            }
            int n21 = n18 - 1;
            block9: while (++n21 <= n19) {
                n20 = nArray[n21];
                if (n20 < n3) {
                    nArray[n21] = nArray[n18];
                    nArray[n18] = n20;
                    ++n18;
                    continue;
                }
                if (n20 <= n17) continue;
                while (nArray[n19] > n17) {
                    if (n19-- != n21) continue;
                    break block9;
                }
                if (nArray[n19] < n3) {
                    nArray[n21] = nArray[n18];
                    nArray[n18] = nArray[n19];
                    ++n18;
                } else {
                    nArray[n21] = nArray[n19];
                }
                nArray[n19] = n20;
                --n19;
            }
            nArray[n] = nArray[n18 - 1];
            nArray[n18 - 1] = n3;
            nArray[n2] = nArray[n19 + 1];
            nArray[n19 + 1] = n17;
            DualPivotQuicksort.sort(nArray, n, n18 - 2, bl);
            DualPivotQuicksort.sort(nArray, n19 + 2, n2, false);
            if (n18 < n14 && n16 < n19) {
                while (nArray[n18] == n3) {
                    ++n18;
                }
                while (nArray[n19] == n17) {
                    --n19;
                }
                n21 = n18 - 1;
                block13: while (++n21 <= n19) {
                    n20 = nArray[n21];
                    if (n20 == n3) {
                        nArray[n21] = nArray[n18];
                        nArray[n18] = n20;
                        ++n18;
                        continue;
                    }
                    if (n20 != n17) continue;
                    while (nArray[n19] == n17) {
                        if (n19-- != n21) continue;
                        break block13;
                    }
                    if (nArray[n19] == n3) {
                        nArray[n21] = nArray[n18];
                        nArray[n18] = n3;
                        ++n18;
                    } else {
                        nArray[n21] = nArray[n19];
                    }
                    nArray[n19] = n20;
                    --n19;
                }
            }
            DualPivotQuicksort.sort(nArray, n18, n19, false);
        } else {
            for (int i = n18; i <= n19; ++i) {
                if (nArray[i] == n3) continue;
                int n22 = nArray[i];
                if (n22 < n3) {
                    nArray[i] = nArray[n18];
                    nArray[n18] = n22;
                    ++n18;
                    continue;
                }
                while (nArray[n19] > n3) {
                    --n19;
                }
                if (nArray[n19] < n3) {
                    nArray[i] = nArray[n18];
                    nArray[n18] = nArray[n19];
                    ++n18;
                } else {
                    nArray[i] = n3;
                }
                nArray[n19] = n22;
                --n19;
            }
            DualPivotQuicksort.sort(nArray, n, n18 - 1, bl);
            DualPivotQuicksort.sort(nArray, n19 + 1, n2, false);
        }
    }

    public static void sort(long[] lArray) {
        DualPivotQuicksort.sort(lArray, 0, lArray.length - 1, true);
    }

    public static void sort(long[] lArray, int n, int n2) {
        DualPivotQuicksort.sort(lArray, n, n2, true);
    }

    private static void sort(long[] lArray, int n, int n2, boolean bl) {
        long l;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    long l2 = lArray[n4 + 1];
                    while (l2 < lArray[n5]) {
                        lArray[n5 + 1] = lArray[n5];
                        if (n5-- != n) continue;
                    }
                    lArray[n5 + 1] = l2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (lArray[n - 1] <= lArray[n]);
                int n6 = n--;
                while ((n += 2) <= n2) {
                    long l3;
                    long l4;
                    n6 = n - 1;
                    if (lArray[n6] < lArray[n]) {
                        l4 = lArray[n6];
                        l3 = lArray[n];
                    } else {
                        l3 = lArray[n6];
                        l4 = lArray[n];
                    }
                    while (l3 < lArray[--n6]) {
                        lArray[n6 + 2] = lArray[n6];
                    }
                    lArray[++n6 + 1] = l3;
                    while (l4 < lArray[--n6]) {
                        lArray[n6 + 1] = lArray[n6];
                    }
                    lArray[n6 + 1] = l4;
                }
                long l5 = lArray[n2];
                while (l5 < lArray[--n2]) {
                    lArray[n2 + 1] = lArray[n2];
                }
                lArray[n2 + 1] = l5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (lArray[n9] < lArray[n10]) {
            l = lArray[n9];
            lArray[n9] = lArray[n10];
            lArray[n10] = l;
        }
        if (lArray[n8] < lArray[n9]) {
            l = lArray[n8];
            lArray[n8] = lArray[n9];
            lArray[n9] = l;
            if (l < lArray[n10]) {
                lArray[n9] = lArray[n10];
                lArray[n10] = l;
            }
        }
        if (lArray[n11] < lArray[n8]) {
            l = lArray[n11];
            lArray[n11] = lArray[n8];
            lArray[n8] = l;
            if (l < lArray[n9]) {
                lArray[n8] = lArray[n9];
                lArray[n9] = l;
                if (l < lArray[n10]) {
                    lArray[n9] = lArray[n10];
                    lArray[n10] = l;
                }
            }
        }
        if (lArray[n12] < lArray[n11]) {
            l = lArray[n12];
            lArray[n12] = lArray[n11];
            lArray[n11] = l;
            if (l < lArray[n8]) {
                lArray[n11] = lArray[n8];
                lArray[n8] = l;
                if (l < lArray[n9]) {
                    lArray[n8] = lArray[n9];
                    lArray[n9] = l;
                    if (l < lArray[n10]) {
                        lArray[n9] = lArray[n10];
                        lArray[n10] = l;
                    }
                }
            }
        }
        l = lArray[n9];
        long l6 = lArray[n11];
        int n13 = n;
        int n14 = n2;
        if (l != l6) {
            long l7;
            lArray[n9] = lArray[n];
            lArray[n11] = lArray[n2];
            while (lArray[++n13] < l) {
            }
            while (lArray[--n14] > l6) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                l7 = lArray[n15];
                if (l7 < l) {
                    lArray[n15] = lArray[n13];
                    lArray[n13] = l7;
                    ++n13;
                    continue;
                }
                if (l7 <= l6) continue;
                while (lArray[n14] > l6) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (lArray[n14] < l) {
                    lArray[n15] = lArray[n13];
                    lArray[n13] = lArray[n14];
                    ++n13;
                } else {
                    lArray[n15] = lArray[n14];
                }
                lArray[n14] = l7;
                --n14;
            }
            lArray[n] = lArray[n13 - 1];
            lArray[n13 - 1] = l;
            lArray[n2] = lArray[n14 + 1];
            lArray[n14 + 1] = l6;
            DualPivotQuicksort.sort(lArray, n, n13 - 2, bl);
            DualPivotQuicksort.sort(lArray, n14 + 2, n2, false);
            if (n13 < n10 && n12 < n14) {
                while (lArray[n13] == l) {
                    ++n13;
                }
                while (lArray[n14] == l6) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    l7 = lArray[n15];
                    if (l7 == l) {
                        lArray[n15] = lArray[n13];
                        lArray[n13] = l7;
                        ++n13;
                        continue;
                    }
                    if (l7 != l6) continue;
                    while (lArray[n14] == l6) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (lArray[n14] == l) {
                        lArray[n15] = lArray[n13];
                        lArray[n13] = l;
                        ++n13;
                    } else {
                        lArray[n15] = lArray[n14];
                    }
                    lArray[n14] = l7;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(lArray, n13, n14, false);
        } else {
            for (int i = n13; i <= n14; ++i) {
                if (lArray[i] == l) continue;
                long l8 = lArray[i];
                if (l8 < l) {
                    lArray[i] = lArray[n13];
                    lArray[n13] = l8;
                    ++n13;
                    continue;
                }
                while (lArray[n14] > l) {
                    --n14;
                }
                if (lArray[n14] < l) {
                    lArray[i] = lArray[n13];
                    lArray[n13] = lArray[n14];
                    ++n13;
                } else {
                    lArray[i] = l;
                }
                lArray[n14] = l8;
                --n14;
            }
            DualPivotQuicksort.sort(lArray, n, n13 - 1, bl);
            DualPivotQuicksort.sort(lArray, n14 + 1, n2, false);
        }
    }

    public static void sort(short[] sArray) {
        DualPivotQuicksort.sort(sArray, 0, sArray.length - 1);
    }

    public static void sort(short[] sArray, int n, int n2) {
        if (n2 - n > 3200) {
            int[] nArray = new int[65536];
            int n3 = n - 1;
            while (++n3 <= n2) {
                int n4 = sArray[n3] - Short.MIN_VALUE;
                nArray[n4] = nArray[n4] + 1;
            }
            n3 = 65536;
            int n5 = n2 + 1;
            while (n5 > n) {
                while (nArray[--n3] == 0) {
                }
                short s = (short)(n3 + Short.MIN_VALUE);
                int n6 = nArray[n3];
                do {
                    sArray[--n5] = s;
                } while (--n6 > 0);
            }
        } else {
            DualPivotQuicksort.sort(sArray, n, n2, true);
        }
    }

    private static void sort(short[] sArray, int n, int n2, boolean bl) {
        short s;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    short s2 = sArray[n4 + 1];
                    while (s2 < sArray[n5]) {
                        sArray[n5 + 1] = sArray[n5];
                        if (n5-- != n) continue;
                    }
                    sArray[n5 + 1] = s2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (sArray[n - 1] <= sArray[n]);
                int n6 = n--;
                while ((n += 2) <= n2) {
                    short s3;
                    short s4;
                    n6 = n - 1;
                    if (sArray[n6] < sArray[n]) {
                        s4 = sArray[n6];
                        s3 = sArray[n];
                    } else {
                        s3 = sArray[n6];
                        s4 = sArray[n];
                    }
                    while (s3 < sArray[--n6]) {
                        sArray[n6 + 2] = sArray[n6];
                    }
                    sArray[++n6 + 1] = s3;
                    while (s4 < sArray[--n6]) {
                        sArray[n6 + 1] = sArray[n6];
                    }
                    sArray[n6 + 1] = s4;
                }
                n6 = sArray[n2];
                while (n6 < sArray[--n2]) {
                    sArray[n2 + 1] = sArray[n2];
                }
                sArray[n2 + 1] = n6;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (sArray[n9] < sArray[n10]) {
            s = sArray[n9];
            sArray[n9] = sArray[n10];
            sArray[n10] = s;
        }
        if (sArray[n8] < sArray[n9]) {
            s = sArray[n8];
            sArray[n8] = sArray[n9];
            sArray[n9] = s;
            if (s < sArray[n10]) {
                sArray[n9] = sArray[n10];
                sArray[n10] = s;
            }
        }
        if (sArray[n11] < sArray[n8]) {
            s = sArray[n11];
            sArray[n11] = sArray[n8];
            sArray[n8] = s;
            if (s < sArray[n9]) {
                sArray[n8] = sArray[n9];
                sArray[n9] = s;
                if (s < sArray[n10]) {
                    sArray[n9] = sArray[n10];
                    sArray[n10] = s;
                }
            }
        }
        if (sArray[n12] < sArray[n11]) {
            s = sArray[n12];
            sArray[n12] = sArray[n11];
            sArray[n11] = s;
            if (s < sArray[n8]) {
                sArray[n11] = sArray[n8];
                sArray[n8] = s;
                if (s < sArray[n9]) {
                    sArray[n8] = sArray[n9];
                    sArray[n9] = s;
                    if (s < sArray[n10]) {
                        sArray[n9] = sArray[n10];
                        sArray[n10] = s;
                    }
                }
            }
        }
        s = sArray[n9];
        short s5 = sArray[n11];
        int n13 = n;
        int n14 = n2;
        if (s != s5) {
            short s6;
            sArray[n9] = sArray[n];
            sArray[n11] = sArray[n2];
            while (sArray[++n13] < s) {
            }
            while (sArray[--n14] > s5) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                s6 = sArray[n15];
                if (s6 < s) {
                    sArray[n15] = sArray[n13];
                    sArray[n13] = s6;
                    ++n13;
                    continue;
                }
                if (s6 <= s5) continue;
                while (sArray[n14] > s5) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (sArray[n14] < s) {
                    sArray[n15] = sArray[n13];
                    sArray[n13] = sArray[n14];
                    ++n13;
                } else {
                    sArray[n15] = sArray[n14];
                }
                sArray[n14] = s6;
                --n14;
            }
            sArray[n] = sArray[n13 - 1];
            sArray[n13 - 1] = s;
            sArray[n2] = sArray[n14 + 1];
            sArray[n14 + 1] = s5;
            DualPivotQuicksort.sort(sArray, n, n13 - 2, bl);
            DualPivotQuicksort.sort(sArray, n14 + 2, n2, false);
            if (n13 < n10 && n12 < n14) {
                while (sArray[n13] == s) {
                    ++n13;
                }
                while (sArray[n14] == s5) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    s6 = sArray[n15];
                    if (s6 == s) {
                        sArray[n15] = sArray[n13];
                        sArray[n13] = s6;
                        ++n13;
                        continue;
                    }
                    if (s6 != s5) continue;
                    while (sArray[n14] == s5) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (sArray[n14] == s) {
                        sArray[n15] = sArray[n13];
                        sArray[n13] = s;
                        ++n13;
                    } else {
                        sArray[n15] = sArray[n14];
                    }
                    sArray[n14] = s6;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(sArray, n13, n14, false);
        } else {
            for (int i = n13; i <= n14; ++i) {
                if (sArray[i] == s) continue;
                short s7 = sArray[i];
                if (s7 < s) {
                    sArray[i] = sArray[n13];
                    sArray[n13] = s7;
                    ++n13;
                    continue;
                }
                while (sArray[n14] > s) {
                    --n14;
                }
                if (sArray[n14] < s) {
                    sArray[i] = sArray[n13];
                    sArray[n13] = sArray[n14];
                    ++n13;
                } else {
                    sArray[i] = s;
                }
                sArray[n14] = s7;
                --n14;
            }
            DualPivotQuicksort.sort(sArray, n, n13 - 1, bl);
            DualPivotQuicksort.sort(sArray, n14 + 1, n2, false);
        }
    }

    public static void sort(char[] cArray) {
        DualPivotQuicksort.sort(cArray, 0, cArray.length - 1);
    }

    public static void sort(char[] cArray, int n, int n2) {
        if (n2 - n > 3200) {
            int[] nArray = new int[65536];
            int n3 = n - 1;
            while (++n3 <= n2) {
                char c = cArray[n3];
                nArray[c] = nArray[c] + 1;
            }
            n3 = 65536;
            int n4 = n2 + 1;
            while (n4 > n) {
                while (nArray[--n3] == 0) {
                }
                char c = (char)n3;
                int n5 = nArray[n3];
                do {
                    cArray[--n4] = c;
                } while (--n5 > 0);
            }
        } else {
            DualPivotQuicksort.sort(cArray, n, n2, true);
        }
    }

    private static void sort(char[] cArray, int n, int n2, boolean bl) {
        char c;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    char c2 = cArray[n4 + 1];
                    while (c2 < cArray[n5]) {
                        cArray[n5 + 1] = cArray[n5];
                        if (n5-- != n) continue;
                    }
                    cArray[n5 + 1] = c2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (cArray[n - 1] <= cArray[n]);
                int n6 = n--;
                while ((n += 2) <= n2) {
                    char c3;
                    char c4;
                    n6 = n - 1;
                    if (cArray[n6] < cArray[n]) {
                        c4 = cArray[n6];
                        c3 = cArray[n];
                    } else {
                        c3 = cArray[n6];
                        c4 = cArray[n];
                    }
                    while (c3 < cArray[--n6]) {
                        cArray[n6 + 2] = cArray[n6];
                    }
                    cArray[++n6 + 1] = c3;
                    while (c4 < cArray[--n6]) {
                        cArray[n6 + 1] = cArray[n6];
                    }
                    cArray[n6 + 1] = c4;
                }
                n6 = cArray[n2];
                while (n6 < cArray[--n2]) {
                    cArray[n2 + 1] = cArray[n2];
                }
                cArray[n2 + 1] = n6;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (cArray[n9] < cArray[n10]) {
            c = cArray[n9];
            cArray[n9] = cArray[n10];
            cArray[n10] = c;
        }
        if (cArray[n8] < cArray[n9]) {
            c = cArray[n8];
            cArray[n8] = cArray[n9];
            cArray[n9] = c;
            if (c < cArray[n10]) {
                cArray[n9] = cArray[n10];
                cArray[n10] = c;
            }
        }
        if (cArray[n11] < cArray[n8]) {
            c = cArray[n11];
            cArray[n11] = cArray[n8];
            cArray[n8] = c;
            if (c < cArray[n9]) {
                cArray[n8] = cArray[n9];
                cArray[n9] = c;
                if (c < cArray[n10]) {
                    cArray[n9] = cArray[n10];
                    cArray[n10] = c;
                }
            }
        }
        if (cArray[n12] < cArray[n11]) {
            c = cArray[n12];
            cArray[n12] = cArray[n11];
            cArray[n11] = c;
            if (c < cArray[n8]) {
                cArray[n11] = cArray[n8];
                cArray[n8] = c;
                if (c < cArray[n9]) {
                    cArray[n8] = cArray[n9];
                    cArray[n9] = c;
                    if (c < cArray[n10]) {
                        cArray[n9] = cArray[n10];
                        cArray[n10] = c;
                    }
                }
            }
        }
        c = cArray[n9];
        char c5 = cArray[n11];
        int n13 = n;
        int n14 = n2;
        if (c != c5) {
            char c6;
            cArray[n9] = cArray[n];
            cArray[n11] = cArray[n2];
            while (cArray[++n13] < c) {
            }
            while (cArray[--n14] > c5) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                c6 = cArray[n15];
                if (c6 < c) {
                    cArray[n15] = cArray[n13];
                    cArray[n13] = c6;
                    ++n13;
                    continue;
                }
                if (c6 <= c5) continue;
                while (cArray[n14] > c5) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (cArray[n14] < c) {
                    cArray[n15] = cArray[n13];
                    cArray[n13] = cArray[n14];
                    ++n13;
                } else {
                    cArray[n15] = cArray[n14];
                }
                cArray[n14] = c6;
                --n14;
            }
            cArray[n] = cArray[n13 - 1];
            cArray[n13 - 1] = c;
            cArray[n2] = cArray[n14 + 1];
            cArray[n14 + 1] = c5;
            DualPivotQuicksort.sort(cArray, n, n13 - 2, bl);
            DualPivotQuicksort.sort(cArray, n14 + 2, n2, false);
            if (n13 < n10 && n12 < n14) {
                while (cArray[n13] == c) {
                    ++n13;
                }
                while (cArray[n14] == c5) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    c6 = cArray[n15];
                    if (c6 == c) {
                        cArray[n15] = cArray[n13];
                        cArray[n13] = c6;
                        ++n13;
                        continue;
                    }
                    if (c6 != c5) continue;
                    while (cArray[n14] == c5) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (cArray[n14] == c) {
                        cArray[n15] = cArray[n13];
                        cArray[n13] = c;
                        ++n13;
                    } else {
                        cArray[n15] = cArray[n14];
                    }
                    cArray[n14] = c6;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(cArray, n13, n14, false);
        } else {
            for (int i = n13; i <= n14; ++i) {
                if (cArray[i] == c) continue;
                char c7 = cArray[i];
                if (c7 < c) {
                    cArray[i] = cArray[n13];
                    cArray[n13] = c7;
                    ++n13;
                    continue;
                }
                while (cArray[n14] > c) {
                    --n14;
                }
                if (cArray[n14] < c) {
                    cArray[i] = cArray[n13];
                    cArray[n13] = cArray[n14];
                    ++n13;
                } else {
                    cArray[i] = c;
                }
                cArray[n14] = c7;
                --n14;
            }
            DualPivotQuicksort.sort(cArray, n, n13 - 1, bl);
            DualPivotQuicksort.sort(cArray, n14 + 1, n2, false);
        }
    }

    public static void sort(byte[] byArray) {
        DualPivotQuicksort.sort(byArray, 0, byArray.length - 1);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        if (n2 - n > 29) {
            int[] nArray = new int[256];
            int n3 = n - 1;
            while (++n3 <= n2) {
                int n4 = byArray[n3] - -128;
                nArray[n4] = nArray[n4] + 1;
            }
            n3 = 256;
            int n5 = n2 + 1;
            while (n5 > n) {
                while (nArray[--n3] == 0) {
                }
                byte by = (byte)(n3 + -128);
                int n6 = nArray[n3];
                do {
                    byArray[--n5] = by;
                } while (--n6 > 0);
            }
        } else {
            int n7;
            int n8 = n7 = n;
            while (n7 < n2) {
                byte by = byArray[n7 + 1];
                while (by < byArray[n8]) {
                    byArray[n8 + 1] = byArray[n8];
                    if (n8-- != n) continue;
                }
                byArray[n8 + 1] = by;
                n8 = ++n7;
            }
        }
    }

    public static void sort(float[] fArray) {
        DualPivotQuicksort.sort(fArray, 0, fArray.length - 1);
    }

    public static void sort(float[] fArray, int n, int n2) {
        float f;
        while (n <= n2 && Float.isNaN(fArray[n2])) {
            --n2;
        }
        int n3 = n2;
        while (--n3 >= n) {
            float f2 = fArray[n3];
            if (f2 == f2) continue;
            fArray[n3] = fArray[n2];
            fArray[n2] = f2;
            --n2;
        }
        DualPivotQuicksort.sort(fArray, n, n2, true);
        n3 = n2;
        while (n < n3) {
            int n4 = n + n3 >>> 1;
            float f3 = fArray[n4];
            if (f3 < 0.0f) {
                n = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        while (n <= n2 && Float.floatToRawIntBits(fArray[n]) < 0) {
            ++n;
        }
        int n5 = n;
        int n6 = n - 1;
        while (++n5 <= n2 && (f = fArray[n5]) == 0.0f) {
            if (Float.floatToRawIntBits(f) >= 0) continue;
            fArray[n5] = 0.0f;
            fArray[++n6] = -0.0f;
        }
    }

    private static void sort(float[] fArray, int n, int n2, boolean bl) {
        float f;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    float f2 = fArray[n4 + 1];
                    while (f2 < fArray[n5]) {
                        fArray[n5 + 1] = fArray[n5];
                        if (n5-- != n) continue;
                    }
                    fArray[n5 + 1] = f2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (fArray[n - 1] <= fArray[n]);
                int n6 = n--;
                while ((n += 2) <= n2) {
                    float f3;
                    float f4;
                    n6 = n - 1;
                    if (fArray[n6] < fArray[n]) {
                        f4 = fArray[n6];
                        f3 = fArray[n];
                    } else {
                        f3 = fArray[n6];
                        f4 = fArray[n];
                    }
                    while (f3 < fArray[--n6]) {
                        fArray[n6 + 2] = fArray[n6];
                    }
                    fArray[++n6 + 1] = f3;
                    while (f4 < fArray[--n6]) {
                        fArray[n6 + 1] = fArray[n6];
                    }
                    fArray[n6 + 1] = f4;
                }
                float f5 = fArray[n2];
                while (f5 < fArray[--n2]) {
                    fArray[n2 + 1] = fArray[n2];
                }
                fArray[n2 + 1] = f5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (fArray[n9] < fArray[n10]) {
            f = fArray[n9];
            fArray[n9] = fArray[n10];
            fArray[n10] = f;
        }
        if (fArray[n8] < fArray[n9]) {
            f = fArray[n8];
            fArray[n8] = fArray[n9];
            fArray[n9] = f;
            if (f < fArray[n10]) {
                fArray[n9] = fArray[n10];
                fArray[n10] = f;
            }
        }
        if (fArray[n11] < fArray[n8]) {
            f = fArray[n11];
            fArray[n11] = fArray[n8];
            fArray[n8] = f;
            if (f < fArray[n9]) {
                fArray[n8] = fArray[n9];
                fArray[n9] = f;
                if (f < fArray[n10]) {
                    fArray[n9] = fArray[n10];
                    fArray[n10] = f;
                }
            }
        }
        if (fArray[n12] < fArray[n11]) {
            f = fArray[n12];
            fArray[n12] = fArray[n11];
            fArray[n11] = f;
            if (f < fArray[n8]) {
                fArray[n11] = fArray[n8];
                fArray[n8] = f;
                if (f < fArray[n9]) {
                    fArray[n8] = fArray[n9];
                    fArray[n9] = f;
                    if (f < fArray[n10]) {
                        fArray[n9] = fArray[n10];
                        fArray[n10] = f;
                    }
                }
            }
        }
        f = fArray[n9];
        float f6 = fArray[n11];
        int n13 = n;
        int n14 = n2;
        if (f != f6) {
            float f7;
            fArray[n9] = fArray[n];
            fArray[n11] = fArray[n2];
            while (fArray[++n13] < f) {
            }
            while (fArray[--n14] > f6) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                f7 = fArray[n15];
                if (f7 < f) {
                    fArray[n15] = fArray[n13];
                    fArray[n13] = f7;
                    ++n13;
                    continue;
                }
                if (!(f7 > f6)) continue;
                while (fArray[n14] > f6) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (fArray[n14] < f) {
                    fArray[n15] = fArray[n13];
                    fArray[n13] = fArray[n14];
                    ++n13;
                } else {
                    fArray[n15] = fArray[n14];
                }
                fArray[n14] = f7;
                --n14;
            }
            fArray[n] = fArray[n13 - 1];
            fArray[n13 - 1] = f;
            fArray[n2] = fArray[n14 + 1];
            fArray[n14 + 1] = f6;
            DualPivotQuicksort.sort(fArray, n, n13 - 2, bl);
            DualPivotQuicksort.sort(fArray, n14 + 2, n2, false);
            if (n13 < n10 && n12 < n14) {
                while (fArray[n13] == f) {
                    ++n13;
                }
                while (fArray[n14] == f6) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    f7 = fArray[n15];
                    if (f7 == f) {
                        fArray[n15] = fArray[n13];
                        fArray[n13] = f7;
                        ++n13;
                        continue;
                    }
                    if (f7 != f6) continue;
                    while (fArray[n14] == f6) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (fArray[n14] == f) {
                        fArray[n15] = fArray[n13];
                        fArray[n13] = fArray[n14];
                        ++n13;
                    } else {
                        fArray[n15] = fArray[n14];
                    }
                    fArray[n14] = f7;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(fArray, n13, n14, false);
        } else {
            for (int i = n13; i <= n14; ++i) {
                if (fArray[i] == f) continue;
                float f8 = fArray[i];
                if (f8 < f) {
                    fArray[i] = fArray[n13];
                    fArray[n13] = f8;
                    ++n13;
                    continue;
                }
                while (fArray[n14] > f) {
                    --n14;
                }
                if (fArray[n14] < f) {
                    fArray[i] = fArray[n13];
                    fArray[n13] = fArray[n14];
                    ++n13;
                } else {
                    fArray[i] = fArray[n14];
                }
                fArray[n14] = f8;
                --n14;
            }
            DualPivotQuicksort.sort(fArray, n, n13 - 1, bl);
            DualPivotQuicksort.sort(fArray, n14 + 1, n2, false);
        }
    }

    public static void sort(double[] dArray) {
        DualPivotQuicksort.sort(dArray, 0, dArray.length - 1);
    }

    public static void sort(double[] dArray, int n, int n2) {
        double d;
        while (n <= n2 && Double.isNaN(dArray[n2])) {
            --n2;
        }
        int n3 = n2;
        while (--n3 >= n) {
            double d2 = dArray[n3];
            if (d2 == d2) continue;
            dArray[n3] = dArray[n2];
            dArray[n2] = d2;
            --n2;
        }
        DualPivotQuicksort.sort(dArray, n, n2, true);
        n3 = n2;
        while (n < n3) {
            int n4 = n + n3 >>> 1;
            double d3 = dArray[n4];
            if (d3 < 0.0) {
                n = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        while (n <= n2 && Double.doubleToRawLongBits(dArray[n]) < 0L) {
            ++n;
        }
        int n5 = n;
        int n6 = n - 1;
        while (++n5 <= n2 && (d = dArray[n5]) == 0.0) {
            if (Double.doubleToRawLongBits(d) >= 0L) continue;
            dArray[n5] = 0.0;
            dArray[++n6] = -0.0;
        }
    }

    private static void sort(double[] dArray, int n, int n2, boolean bl) {
        double d;
        int n3 = n2 - n + 1;
        if (n3 < 47) {
            if (bl) {
                int n4;
                int n5 = n4 = n;
                while (n4 < n2) {
                    double d2 = dArray[n4 + 1];
                    while (d2 < dArray[n5]) {
                        dArray[n5 + 1] = dArray[n5];
                        if (n5-- != n) continue;
                    }
                    dArray[n5 + 1] = d2;
                    n5 = ++n4;
                }
            } else {
                do {
                    if (n++ < n2) continue;
                    return;
                } while (dArray[n - 1] <= dArray[n]);
                int n6 = n--;
                while ((n += 2) <= n2) {
                    double d3;
                    double d4;
                    n6 = n - 1;
                    if (dArray[n6] < dArray[n]) {
                        d4 = dArray[n6];
                        d3 = dArray[n];
                    } else {
                        d3 = dArray[n6];
                        d4 = dArray[n];
                    }
                    while (d3 < dArray[--n6]) {
                        dArray[n6 + 2] = dArray[n6];
                    }
                    dArray[++n6 + 1] = d3;
                    while (d4 < dArray[--n6]) {
                        dArray[n6 + 1] = dArray[n6];
                    }
                    dArray[n6 + 1] = d4;
                }
                double d5 = dArray[n2];
                while (d5 < dArray[--n2]) {
                    dArray[n2 + 1] = dArray[n2];
                }
                dArray[n2 + 1] = d5;
            }
            return;
        }
        int n7 = (n3 >> 3) + (n3 >> 6) + 1;
        int n8 = n + n2 >>> 1;
        int n9 = n8 - n7;
        int n10 = n9 - n7;
        int n11 = n8 + n7;
        int n12 = n11 + n7;
        if (dArray[n9] < dArray[n10]) {
            d = dArray[n9];
            dArray[n9] = dArray[n10];
            dArray[n10] = d;
        }
        if (dArray[n8] < dArray[n9]) {
            d = dArray[n8];
            dArray[n8] = dArray[n9];
            dArray[n9] = d;
            if (d < dArray[n10]) {
                dArray[n9] = dArray[n10];
                dArray[n10] = d;
            }
        }
        if (dArray[n11] < dArray[n8]) {
            d = dArray[n11];
            dArray[n11] = dArray[n8];
            dArray[n8] = d;
            if (d < dArray[n9]) {
                dArray[n8] = dArray[n9];
                dArray[n9] = d;
                if (d < dArray[n10]) {
                    dArray[n9] = dArray[n10];
                    dArray[n10] = d;
                }
            }
        }
        if (dArray[n12] < dArray[n11]) {
            d = dArray[n12];
            dArray[n12] = dArray[n11];
            dArray[n11] = d;
            if (d < dArray[n8]) {
                dArray[n11] = dArray[n8];
                dArray[n8] = d;
                if (d < dArray[n9]) {
                    dArray[n8] = dArray[n9];
                    dArray[n9] = d;
                    if (d < dArray[n10]) {
                        dArray[n9] = dArray[n10];
                        dArray[n10] = d;
                    }
                }
            }
        }
        d = dArray[n9];
        double d6 = dArray[n11];
        int n13 = n;
        int n14 = n2;
        if (d != d6) {
            double d7;
            dArray[n9] = dArray[n];
            dArray[n11] = dArray[n2];
            while (dArray[++n13] < d) {
            }
            while (dArray[--n14] > d6) {
            }
            int n15 = n13 - 1;
            block9: while (++n15 <= n14) {
                d7 = dArray[n15];
                if (d7 < d) {
                    dArray[n15] = dArray[n13];
                    dArray[n13] = d7;
                    ++n13;
                    continue;
                }
                if (!(d7 > d6)) continue;
                while (dArray[n14] > d6) {
                    if (n14-- != n15) continue;
                    break block9;
                }
                if (dArray[n14] < d) {
                    dArray[n15] = dArray[n13];
                    dArray[n13] = dArray[n14];
                    ++n13;
                } else {
                    dArray[n15] = dArray[n14];
                }
                dArray[n14] = d7;
                --n14;
            }
            dArray[n] = dArray[n13 - 1];
            dArray[n13 - 1] = d;
            dArray[n2] = dArray[n14 + 1];
            dArray[n14 + 1] = d6;
            DualPivotQuicksort.sort(dArray, n, n13 - 2, bl);
            DualPivotQuicksort.sort(dArray, n14 + 2, n2, false);
            if (n13 < n10 && n12 < n14) {
                while (dArray[n13] == d) {
                    ++n13;
                }
                while (dArray[n14] == d6) {
                    --n14;
                }
                n15 = n13 - 1;
                block13: while (++n15 <= n14) {
                    d7 = dArray[n15];
                    if (d7 == d) {
                        dArray[n15] = dArray[n13];
                        dArray[n13] = d7;
                        ++n13;
                        continue;
                    }
                    if (d7 != d6) continue;
                    while (dArray[n14] == d6) {
                        if (n14-- != n15) continue;
                        break block13;
                    }
                    if (dArray[n14] == d) {
                        dArray[n15] = dArray[n13];
                        dArray[n13] = dArray[n14];
                        ++n13;
                    } else {
                        dArray[n15] = dArray[n14];
                    }
                    dArray[n14] = d7;
                    --n14;
                }
            }
            DualPivotQuicksort.sort(dArray, n13, n14, false);
        } else {
            for (int i = n13; i <= n14; ++i) {
                if (dArray[i] == d) continue;
                double d8 = dArray[i];
                if (d8 < d) {
                    dArray[i] = dArray[n13];
                    dArray[n13] = d8;
                    ++n13;
                    continue;
                }
                while (dArray[n14] > d) {
                    --n14;
                }
                if (dArray[n14] < d) {
                    dArray[i] = dArray[n13];
                    dArray[n13] = dArray[n14];
                    ++n13;
                } else {
                    dArray[i] = dArray[n14];
                }
                dArray[n14] = d8;
                --n14;
            }
            DualPivotQuicksort.sort(dArray, n, n13 - 1, bl);
            DualPivotQuicksort.sort(dArray, n14 + 1, n2, false);
        }
    }
}

