/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.ConstantCallSite;
import java.dyn.InvokeDynamicBootstrapError;
import java.dyn.MethodHandle;
import java.dyn.MethodHandleProvider;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.dyn.WrongMethodTypeException;
import sun.dyn.Access;
import sun.dyn.CallSiteImpl;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;

public class CallSite
implements MethodHandleProvider {
    private static final Access IMPL_TOKEN = Access.getToken();
    private MemberName vmmethod;
    private int vmindex;
    private MethodHandle target;
    private MemberName calleeNameRemoveForPFD;
    private static final MethodHandle GET_TARGET;

    public CallSite() {
    }

    public CallSite(MethodHandle methodHandle) {
        this.target = methodHandle;
    }

    public CallSite(Class<?> clazz, String string, MethodType methodType) {
        this.calleeNameRemoveForPFD = new MemberName(clazz, string, methodType);
    }

    public Class<?> callerClass() {
        MemberName memberName = this.calleeNameRemoveForPFD;
        return memberName == null ? null : memberName.getDeclaringClass();
    }

    public String name() {
        MemberName memberName = this.calleeNameRemoveForPFD;
        return memberName == null ? null : memberName.getName();
    }

    public MethodType type() {
        MemberName memberName = this.calleeNameRemoveForPFD;
        return memberName == null ? (this.target == null ? null : this.target.type()) : memberName.getMethodType();
    }

    protected MethodHandle initialTarget() {
        return this.initialTarget(this.callerClass(), this.name(), this.type());
    }

    private boolean isLinked() {
        return this.vmmethod != null;
    }

    void initializeFromJVM(String string, MethodType methodType, MemberName memberName, int n) {
        if (this.isLinked()) {
            throw new InvokeDynamicBootstrapError("call site has already been linked to an invokedynamic instruction");
        }
        MethodHandle methodHandle = this.target;
        if (methodHandle == null) {
            this.target = methodHandle = this.initialTarget(memberName.getDeclaringClass(), string, methodType);
        }
        if (!methodHandle.type().equals((Object)methodType)) {
            throw CallSite.wrongTargetType(methodHandle, methodType);
        }
        this.vmindex = n;
        this.vmmethod = memberName;
        assert (this.isLinked());
    }

    protected MethodHandle initialTarget(Class<?> clazz, String string, MethodType methodType) {
        throw new InvokeDynamicBootstrapError("target must be initialized before call site is linked: " + string + methodType);
    }

    public MethodHandle getTarget() {
        return this.target;
    }

    public void setTarget(MethodHandle methodHandle) {
        MethodType methodType = methodHandle.type();
        MethodHandle methodHandle2 = this.target;
        if (methodHandle2 == null) {
            assert (!this.isLinked());
            this.target = methodHandle;
            return;
        }
        MethodType methodType2 = methodHandle2.type();
        if (!methodHandle.type().equals((Object)methodType2)) {
            throw CallSite.wrongTargetType(methodHandle, methodType2);
        }
        if (methodHandle2 != methodHandle) {
            CallSiteImpl.setCallSiteTarget(IMPL_TOKEN, this, methodHandle);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle methodHandle, MethodType methodType) {
        return new WrongMethodTypeException(String.valueOf(methodHandle) + methodHandle.type() + " should be of type " + methodType);
    }

    public String toString() {
        return "CallSite" + (this.target == null ? "" : this.target.type());
    }

    public final MethodHandle dynamicInvoker() {
        if (this instanceof ConstantCallSite) {
            return this.getTarget();
        }
        MethodHandle methodHandle = MethodHandleImpl.bindReceiver(IMPL_TOKEN, GET_TARGET, this);
        MethodHandle methodHandle2 = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(methodHandle2, methodHandle);
    }

    @Override
    public final MethodHandle asMethodHandle() {
        return this.dynamicInvoker();
    }

    @Override
    public final MethodHandle asMethodHandle(MethodType methodType) {
        return this.dynamicInvoker().asType(methodType);
    }

    static {
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
        }
        catch (NoAccessException noAccessException) {
            throw new InternalError();
        }
    }
}

