/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Utils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

abstract class ConstantPool
implements Constants {
    protected static final Entry[] noRefs = new Entry[0];
    protected static final ClassEntry[] noClassRefs = new ClassEntry[0];
    static final byte[] TAGS_IN_ORDER = new byte[]{1, 3, 4, 5, 6, 8, 7, 13, 12, 9, 10, 11};
    static final byte[] TAG_ORDER = new byte[14];

    private ConstantPool() {
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    public static synchronized Utf8Entry getUtf8Entry(String string) {
        Map<String, Utf8Entry> map = Utils.getUtf8Entries();
        Utf8Entry utf8Entry = map.get(string);
        if (utf8Entry == null) {
            utf8Entry = new Utf8Entry(string);
            map.put(utf8Entry.stringValue(), utf8Entry);
        }
        return utf8Entry;
    }

    public static synchronized ClassEntry getClassEntry(String string) {
        Map<String, ClassEntry> map = Utils.getClassEntries();
        ClassEntry classEntry = map.get(string);
        if (classEntry == null) {
            classEntry = new ClassEntry(ConstantPool.getUtf8Entry(string));
            assert (string.equals(classEntry.stringValue()));
            map.put(classEntry.stringValue(), classEntry);
        }
        return classEntry;
    }

    public static synchronized LiteralEntry getLiteralEntry(Comparable comparable) {
        Map<Object, LiteralEntry> map = Utils.getLiteralEntries();
        LiteralEntry literalEntry = map.get(comparable);
        if (literalEntry == null) {
            literalEntry = comparable instanceof String ? new StringEntry(ConstantPool.getUtf8Entry((String)((Object)comparable))) : new NumberEntry((Number)((Object)comparable));
            map.put(comparable, literalEntry);
        }
        return literalEntry;
    }

    public static synchronized StringEntry getStringEntry(String string) {
        return (StringEntry)ConstantPool.getLiteralEntry((Comparable)((Object)string));
    }

    public static synchronized SignatureEntry getSignatureEntry(String string) {
        Map<String, SignatureEntry> map = Utils.getSignatureEntries();
        SignatureEntry signatureEntry = map.get(string);
        if (signatureEntry == null) {
            signatureEntry = new SignatureEntry(string);
            assert (signatureEntry.stringValue().equals(string));
            map.put(string, signatureEntry);
        }
        return signatureEntry;
    }

    public static SignatureEntry getSignatureEntry(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
        return ConstantPool.getSignatureEntry(SignatureEntry.stringValueOf(utf8Entry, classEntryArray));
    }

    public static synchronized DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, SignatureEntry signatureEntry) {
        String string;
        Map<String, DescriptorEntry> map = Utils.getDescriptorEntries();
        DescriptorEntry descriptorEntry = map.get(string = DescriptorEntry.stringValueOf(utf8Entry, signatureEntry));
        if (descriptorEntry == null) {
            descriptorEntry = new DescriptorEntry(utf8Entry, signatureEntry);
            assert (descriptorEntry.stringValue().equals(string)) : descriptorEntry.stringValue() + " != " + string;
            map.put(string, descriptorEntry);
        }
        return descriptorEntry;
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, Utf8Entry utf8Entry2) {
        return ConstantPool.getDescriptorEntry(utf8Entry, ConstantPool.getSignatureEntry(utf8Entry2.stringValue()));
    }

    public static synchronized MemberEntry getMemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
        String string;
        Map<String, MemberEntry> map = Utils.getMemberEntries();
        MemberEntry memberEntry = map.get(string = MemberEntry.stringValueOf(by, classEntry, descriptorEntry));
        if (memberEntry == null) {
            memberEntry = new MemberEntry(by, classEntry, descriptorEntry);
            assert (memberEntry.stringValue().equals(string)) : memberEntry.stringValue() + " != " + string;
            map.put(string, memberEntry);
        }
        return memberEntry;
    }

    static boolean isMemberTag(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static byte numberTagOf(Number number) {
        if (number instanceof Integer) {
            return 3;
        }
        if (number instanceof Float) {
            return 4;
        }
        if (number instanceof Long) {
            return 5;
        }
        if (number instanceof Double) {
            return 6;
        }
        throw new RuntimeException("bad literal value " + number);
    }

    static int compareSignatures(String string, String string2) {
        return ConstantPool.compareSignatures(string, string2, null, null);
    }

    static int compareSignatures(String string, String string2, String[] stringArray, String[] stringArray2) {
        int n;
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        if (c != '(' && c2 == '(') {
            return -1;
        }
        if (c2 != '(' && c == '(') {
            return 1;
        }
        if (stringArray == null) {
            stringArray = ConstantPool.structureSignature(string);
        }
        if (stringArray2 == null) {
            stringArray2 = ConstantPool.structureSignature(string2);
        }
        if (stringArray.length != stringArray2.length) {
            return stringArray.length - stringArray2.length;
        }
        int n2 = n = stringArray.length;
        while (--n2 >= 0) {
            int n3 = stringArray[n2].compareTo(stringArray2[n2]);
            if (n3 == 0) continue;
            return n3;
        }
        assert (string.equals(string2));
        return 0;
    }

    static int countClassParts(Utf8Entry utf8Entry) {
        int n = 0;
        String string = utf8Entry.stringValue();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'L') continue;
            ++n;
        }
        return n;
    }

    static String flattenSignature(String[] stringArray) {
        String string = stringArray[0];
        if (stringArray.length == 1) {
            return string;
        }
        int n = string.length();
        for (int i = 1; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            cArray[n2++] = c;
            if (c != 'L') continue;
            String string2 = stringArray[n3++];
            string2.getChars(0, string2.length(), cArray, n2);
            n2 += string2.length();
        }
        assert (n2 == n);
        assert (n3 == stringArray.length);
        return new String(cArray);
    }

    private static int skipClassNameChars(String string, int n) {
        char c;
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) > ' ' && (c < ';' || c > '@')) {
            ++n;
        }
        return n;
    }

    static String[] structureSignature(String string) {
        int n;
        int n2;
        string = string.intern();
        int n3 = 0;
        int n4 = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            ++n3;
            if (c != 'L') continue;
            ++n4;
            n2 = ConstantPool.skipClassNameChars(string, i + 1);
            n = string.indexOf(60, (i = n2 - 1) + 1);
            if (n <= 0 || n >= n2) continue;
            i = n - 1;
        }
        char[] cArray = new char[n3];
        if (n4 == 1) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        String[] stringArray = new String[n4];
        n2 = 0;
        n = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            cArray[n2++] = c;
            if (c != 'L') continue;
            int n5 = ConstantPool.skipClassNameChars(string, i + 1);
            stringArray[n++] = string.substring(i + 1, n5);
            i = n5;
            --i;
        }
        assert (n2 == n3);
        assert (n == stringArray.length);
        stringArray[0] = new String(cArray);
        return stringArray;
    }

    public static Index makeIndex(String string, Entry[] entryArray) {
        return new Index(string, entryArray);
    }

    public static Index makeIndex(String string, Collection collection) {
        return new Index(string, collection);
    }

    public static void sort(Index index) {
        index.clearIndex();
        Arrays.sort(index.cpMap);
        if (ConstantPool.verbose() > 2) {
            System.out.println("sorted " + index.dumpString());
        }
    }

    public static Index[] partition(Index index, int[] nArray) {
        List<Entry> list;
        int n;
        ArrayList<ArrayList<Entry>> arrayList = new ArrayList<ArrayList<Entry>>();
        Entry[] entryArray = index.cpMap;
        assert (nArray.length == entryArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n < 0) continue;
            while (n >= arrayList.size()) {
                arrayList.add(null);
            }
            list = (ArrayList<Entry>)arrayList.get(n);
            if (list == null) {
                list = new ArrayList<Entry>();
                arrayList.set(n, (ArrayList<Entry>)list);
            }
            list.add(entryArray[i]);
        }
        Index[] indexArray = new Index[arrayList.size()];
        for (n = 0; n < indexArray.length; ++n) {
            list = (List)arrayList.get(n);
            if (list == null) continue;
            indexArray[n] = new Index(index.debugName + "/part#" + n, list);
            assert (indexArray[n].indexOf((Entry)list.get(0)) == 0);
        }
        return indexArray;
    }

    public static Index[] partitionByTag(Index index) {
        Entry[] entryArray = index.cpMap;
        int[] nArray = new int[entryArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Entry entry = entryArray[i];
            nArray[i] = entry == null ? -1 : (int)entry.tag;
        }
        Index[] indexArray = ConstantPool.partition(index, nArray);
        for (int i = 0; i < indexArray.length; ++i) {
            if (indexArray[i] == null) continue;
            indexArray[i].debugName = ConstantPool.tagName(i);
        }
        if (indexArray.length < 14) {
            Index[] indexArray2 = new Index[14];
            System.arraycopy(indexArray, 0, indexArray2, 0, indexArray.length);
            indexArray = indexArray2;
        }
        return indexArray;
    }

    public static void completeReferencesIn(Set<Entry> set, boolean bl) {
        set.remove(null);
        ListIterator<Entry> listIterator = new ArrayList<Entry>(set).listIterator(set.size());
        while (listIterator.hasPrevious()) {
            Entry entry;
            Entry entry2 = listIterator.previous();
            listIterator.remove();
            assert (entry2 != null);
            if (bl && entry2.tag == 13) {
                SignatureEntry signatureEntry = (SignatureEntry)entry2;
                entry = signatureEntry.asUtf8Entry();
                set.remove(signatureEntry);
                set.add(entry);
                entry2 = entry;
            }
            int n = 0;
            while ((entry = entry2.getRef(n)) != null) {
                if (set.add(entry)) {
                    listIterator.add(entry);
                }
                ++n;
            }
        }
    }

    static double percent(int n, int n2) {
        return (double)((int)(10000.0 * (double)n / (double)n2 + 0.5)) / 100.0;
    }

    public static String tagName(int n) {
        switch (n) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameandType";
            }
            case 19: {
                return "*All";
            }
            case 0: {
                return "*None";
            }
            case 13: {
                return "*Signature";
            }
        }
        return "tag#" + n;
    }

    static {
        for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
            ConstantPool.TAG_ORDER[ConstantPool.TAGS_IN_ORDER[i]] = (byte)(i + 1);
        }
    }

    public static class IndexGroup {
        private Index indexUntyped;
        private Index[] indexByTag = new Index[14];
        private int[] untypedFirstIndexByTag;
        private int totalSize;
        private Index[][] indexByTagAndClass;

        public Index getUntypedIndex() {
            if (this.indexUntyped == null) {
                this.untypedIndexOf(null);
                Entry[] entryArray = new Entry[this.totalSize];
                for (int i = 0; i < this.indexByTag.length; ++i) {
                    int n;
                    Index index = this.indexByTag[i];
                    if (index == null || (n = index.cpMap.length) == 0) continue;
                    int n2 = this.untypedFirstIndexByTag[i];
                    assert (entryArray[n2] == null);
                    assert (entryArray[n2 + n - 1] == null);
                    System.arraycopy(index.cpMap, 0, entryArray, n2, n);
                }
                this.indexUntyped = new Index("untyped", entryArray);
            }
            return this.indexUntyped;
        }

        public int untypedIndexOf(Entry entry) {
            int n;
            int n2;
            if (this.untypedFirstIndexByTag == null) {
                this.untypedFirstIndexByTag = new int[14];
                n2 = 0;
                for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
                    n = TAGS_IN_ORDER[i];
                    Index index = this.indexByTag[n];
                    if (index == null) continue;
                    int n3 = index.cpMap.length;
                    this.untypedFirstIndexByTag[n] = n2;
                    n2 += n3;
                }
                this.totalSize = n2;
            }
            if (entry == null) {
                return -1;
            }
            n2 = entry.tag;
            Index index = this.indexByTag[n2];
            if (index == null) {
                return -1;
            }
            n = index.findIndexOf(entry);
            if (n >= 0) {
                n += this.untypedFirstIndexByTag[n2];
            }
            return n;
        }

        public void initIndexByTag(byte by, Index index) {
            assert (this.indexByTag[by] == null);
            Entry[] entryArray = index.cpMap;
            for (int i = 0; i < entryArray.length; ++i) {
                assert (entryArray[i].tag == by);
            }
            if (by == 1) assert (entryArray.length == 0 || entryArray[0].stringValue().equals(""));
            this.indexByTag[by] = index;
            this.untypedFirstIndexByTag = null;
            this.indexUntyped = null;
            if (this.indexByTagAndClass != null) {
                this.indexByTagAndClass[by] = null;
            }
        }

        public Index getIndexByTag(byte by) {
            if (by == 19) {
                return this.getUntypedIndex();
            }
            Index index = this.indexByTag[by];
            if (index == null) {
                this.indexByTag[by] = index = new Index(ConstantPool.tagName(by), new Entry[0]);
            }
            return index;
        }

        public Index getMemberIndex(byte by, ClassEntry classEntry) {
            if (this.indexByTagAndClass == null) {
                this.indexByTagAndClass = new Index[14][];
            }
            Index index = this.getIndexByTag((byte)7);
            Index[] indexArray = this.indexByTagAndClass[by];
            if (indexArray == null) {
                int n;
                Index index2 = this.getIndexByTag(by);
                int[] nArray = new int[index2.size()];
                for (n = 0; n < nArray.length; ++n) {
                    int n2;
                    MemberEntry memberEntry = (MemberEntry)index2.get(n);
                    nArray[n] = n2 = index.indexOf(memberEntry.classRef);
                }
                indexArray = ConstantPool.partition(index2, nArray);
                for (n = 0; n < indexArray.length; ++n) {
                    assert (indexArray[n] == null || indexArray[n].assertIsSorted());
                }
                this.indexByTagAndClass[by] = indexArray;
            }
            int n = index.indexOf(classEntry);
            return indexArray[n];
        }

        public int getOverloadingIndex(MemberEntry memberEntry) {
            Index index = this.getMemberIndex(memberEntry.tag, memberEntry.classRef);
            Utf8Entry utf8Entry = memberEntry.descRef.nameRef;
            int n = 0;
            for (int i = 0; i < index.cpMap.length; ++i) {
                MemberEntry memberEntry2 = (MemberEntry)index.cpMap[i];
                if (memberEntry2.equals(memberEntry)) {
                    return n;
                }
                if (!memberEntry2.descRef.nameRef.equals(utf8Entry)) continue;
                ++n;
            }
            throw new RuntimeException("should not reach here");
        }

        public MemberEntry getOverloadingForIndex(byte by, ClassEntry classEntry, String string, int n) {
            assert (string == string.intern());
            Index index = this.getMemberIndex(by, classEntry);
            int n2 = 0;
            for (int i = 0; i < index.cpMap.length; ++i) {
                MemberEntry memberEntry = (MemberEntry)index.cpMap[i];
                if (memberEntry.descRef.nameRef.stringValue() != string) continue;
                if (n2 == n) {
                    return memberEntry;
                }
                ++n2;
            }
            throw new RuntimeException("should not reach here");
        }

        public boolean haveNumbers() {
            for (byte by = 3; by <= 6; by = (byte)(by + 1)) {
                switch (by) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.getIndexByTag(by).size() <= 0) continue;
                return true;
            }
            return false;
        }
    }

    public static class Index
    extends AbstractList {
        protected String debugName;
        protected Entry[] cpMap;
        protected boolean flattenSigs;
        protected Entry[] indexKey;
        protected int[] indexValue;

        protected Entry[] getMap() {
            return this.cpMap;
        }

        protected Index(String string) {
            this.debugName = string;
        }

        protected Index(String string, Entry[] entryArray) {
            this(string);
            this.setMap(entryArray);
        }

        protected void setMap(Entry[] entryArray) {
            this.clearIndex();
            this.cpMap = entryArray;
        }

        protected Index(String string, Collection<Entry> collection) {
            this(string);
            this.setMap(collection);
        }

        protected void setMap(Collection<Entry> collection) {
            this.cpMap = new Entry[collection.size()];
            collection.toArray(this.cpMap);
            this.setMap(this.cpMap);
        }

        @Override
        public int size() {
            return this.cpMap.length;
        }

        @Override
        public Object get(int n) {
            return this.cpMap[n];
        }

        public Entry getEntry(int n) {
            return this.cpMap[n];
        }

        private int findIndexOf(Entry entry) {
            int n;
            if (this.indexKey == null) {
                this.initializeIndex();
            }
            if (this.indexKey[n = this.findIndexLocation(entry)] != entry) {
                if (this.flattenSigs && entry.tag == 13) {
                    SignatureEntry signatureEntry = (SignatureEntry)entry;
                    return this.findIndexOf(signatureEntry.asUtf8Entry());
                }
                return -1;
            }
            int n2 = this.indexValue[n];
            assert (entry.equals(this.cpMap[n2]));
            return n2;
        }

        public boolean contains(Entry entry) {
            return this.findIndexOf(entry) >= 0;
        }

        public int indexOf(Entry entry) {
            int n = this.findIndexOf(entry);
            if (n < 0 && ConstantPool.verbose() > 0) {
                System.out.println("not found: " + entry);
                System.out.println("       in: " + this.dumpString());
                Thread.dumpStack();
            }
            assert (n >= 0);
            return n;
        }

        @Override
        public boolean contains(Object object) {
            return this.findIndexOf((Entry)object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            return this.findIndexOf((Entry)object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.indexOf(object);
        }

        public boolean assertIsSorted() {
            for (int i = 1; i < this.cpMap.length; ++i) {
                if (this.cpMap[i - 1].compareTo(this.cpMap[i]) <= 0) continue;
                System.out.println("Not sorted at " + (i - 1) + "/" + i + ": " + this.dumpString());
                return false;
            }
            return true;
        }

        protected void clearIndex() {
            this.indexKey = null;
            this.indexValue = null;
        }

        private int findIndexLocation(Entry entry) {
            int n = this.indexKey.length;
            int n2 = entry.hashCode();
            int n3 = n2 & n - 1;
            int n4 = (n2 >>> 8 | 1) & n - 1;
            Entry entry2;
            while ((entry2 = this.indexKey[n3]) != entry && entry2 != null) {
                if ((n3 += n4) < n) continue;
                n3 -= n;
            }
            return n3;
        }

        private void initializeIndex() {
            int n;
            if (ConstantPool.verbose() > 2) {
                System.out.println("initialize Index " + this.debugName + " [" + this.size() + "]");
            }
            int n2 = (int)((double)(this.cpMap.length + 10) * 1.5);
            for (n = 1; n < n2; n <<= 1) {
            }
            this.indexKey = new Entry[n];
            this.indexValue = new int[n];
            for (int i = 0; i < this.cpMap.length; ++i) {
                Entry entry = this.cpMap[i];
                if (entry == null) continue;
                int n3 = this.findIndexLocation(entry);
                assert (this.indexKey[n3] == null);
                this.indexKey[n3] = entry;
                this.indexValue[n3] = i;
            }
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            int n = this.size();
            if (objectArray.length < n) {
                return super.toArray(objectArray);
            }
            System.arraycopy(this.cpMap, 0, objectArray, 0, n);
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Entry[this.size()]);
        }

        public Object clone() {
            return new Index(this.debugName, (Entry[])this.cpMap.clone());
        }

        @Override
        public String toString() {
            return "Index " + this.debugName + " [" + this.size() + "]";
        }

        public String dumpString() {
            String string = this.toString();
            string = string + " {\n";
            for (int i = 0; i < this.cpMap.length; ++i) {
                string = string + "    " + i + ": " + this.cpMap[i] + "\n";
            }
            string = string + "}";
            return string;
        }
    }

    public static class SignatureEntry
    extends Entry {
        final Utf8Entry formRef;
        final ClassEntry[] classRefs;
        String value;
        Utf8Entry asUtf8Entry;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.formRef;
            }
            return n - 1 < this.classRefs.length ? this.classRefs[n - 1] : null;
        }

        SignatureEntry(String string) {
            super((byte)13);
            this.value = string = string.intern();
            String[] stringArray = ConstantPool.structureSignature(string);
            this.formRef = ConstantPool.getUtf8Entry(stringArray[0]);
            this.classRefs = new ClassEntry[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                this.classRefs[i - 1] = ConstantPool.getClassEntry(stringArray[i]);
            }
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            this.stringValue();
            return this.value.hashCode() + this.tag;
        }

        public Utf8Entry asUtf8Entry() {
            if (this.asUtf8Entry == null) {
                this.asUtf8Entry = ConstantPool.getUtf8Entry(this.stringValue());
            }
            return this.asUtf8Entry;
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((SignatureEntry)object).value == this.value;
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                SignatureEntry signatureEntry = (SignatureEntry)object;
                n = ConstantPool.compareSignatures(this.value, signatureEntry.value);
            }
            return n;
        }

        @Override
        public String stringValue() {
            if (this.value == null) {
                this.value = SignatureEntry.stringValueOf(this.formRef, this.classRefs);
            }
            return this.value;
        }

        static String stringValueOf(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
            String[] stringArray = new String[1 + classEntryArray.length];
            stringArray[0] = utf8Entry.stringValue();
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = classEntryArray[i - 1].stringValue();
            }
            return ConstantPool.flattenSignature(stringArray).intern();
        }

        public int computeSize(boolean bl) {
            String string = this.formRef.stringValue();
            int n = 0;
            int n2 = 1;
            if (this.isMethod()) {
                n = 1;
                n2 = string.indexOf(41);
            }
            int n3 = 0;
            block5: for (int i = n; i < n2; ++i) {
                switch (string.charAt(i)) {
                    case 'D': 
                    case 'J': {
                        if (!bl) break;
                        ++n3;
                        break;
                    }
                    case '[': {
                        while (string.charAt(i) == '[') {
                            ++i;
                        }
                        break;
                    }
                    case ';': {
                        continue block5;
                    }
                    default: {
                        assert (0 <= "BSCIJFDZLV([".indexOf(string.charAt(i)));
                        break;
                    }
                }
                ++n3;
            }
            return n3;
        }

        public boolean isMethod() {
            return this.formRef.stringValue().charAt(0) == '(';
        }

        public byte getLiteralTag() {
            switch (this.formRef.stringValue().charAt(0)) {
                case 'L': {
                    return 8;
                }
                case 'I': {
                    return 3;
                }
                case 'J': {
                    return 5;
                }
                case 'F': {
                    return 4;
                }
                case 'D': {
                    return 6;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return 3;
                }
            }
            assert (false);
            return 0;
        }

        public String prettyString() {
            int n;
            String string;
            if (this.isMethod()) {
                string = this.formRef.stringValue();
                string = string.substring(0, 1 + string.indexOf(41));
            } else {
                string = "/" + this.formRef.stringValue();
            }
            while ((n = string.indexOf(59)) >= 0) {
                string = string.substring(0, n) + string.substring(n + 1);
            }
            return string;
        }
    }

    public static class MemberEntry
    extends Entry {
        final ClassEntry classRef;
        final DescriptorEntry descRef;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.classRef;
            }
            if (n == 1) {
                return this.descRef;
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int n = this.descRef.hashCode();
            return this.classRef.hashCode() + (n << 8) ^ n;
        }

        MemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            super(by);
            assert (ConstantPool.isMemberTag(by));
            this.classRef = classEntry;
            this.descRef = descriptorEntry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            MemberEntry memberEntry = (MemberEntry)object;
            return this.classRef.eq(memberEntry.classRef) && this.descRef.eq(memberEntry.descRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                MemberEntry memberEntry = (MemberEntry)object;
                n = this.classRef.compareTo(memberEntry.classRef);
                if (n == 0) {
                    n = this.descRef.compareTo(memberEntry.descRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return MemberEntry.stringValueOf(this.tag, this.classRef, this.descRef);
        }

        static String stringValueOf(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            String string;
            assert (ConstantPool.isMemberTag(by));
            switch (by) {
                case 9: {
                    string = "Field:";
                    break;
                }
                case 10: {
                    string = "Method:";
                    break;
                }
                case 11: {
                    string = "IMethod:";
                    break;
                }
                default: {
                    string = by + "???";
                }
            }
            return string + classEntry.stringValue() + "," + descriptorEntry.stringValue();
        }

        public boolean isMethod() {
            return this.descRef.isMethod();
        }
    }

    public static class DescriptorEntry
    extends Entry {
        final Utf8Entry nameRef;
        final SignatureEntry typeRef;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.nameRef;
            }
            if (n == 1) {
                return this.typeRef;
            }
            return null;
        }

        DescriptorEntry(Entry entry, Entry entry2) {
            super((byte)12);
            if (entry2 instanceof Utf8Entry) {
                entry2 = ConstantPool.getSignatureEntry(entry2.stringValue());
            }
            this.nameRef = (Utf8Entry)entry;
            this.typeRef = (SignatureEntry)entry2;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            int n = this.typeRef.hashCode();
            return this.nameRef.hashCode() + (n << 8) ^ n;
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            DescriptorEntry descriptorEntry = (DescriptorEntry)object;
            return this.nameRef.eq(descriptorEntry.nameRef) && this.typeRef.eq(descriptorEntry.typeRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                DescriptorEntry descriptorEntry = (DescriptorEntry)object;
                n = this.typeRef.compareTo(descriptorEntry.typeRef);
                if (n == 0) {
                    n = this.nameRef.compareTo(descriptorEntry.nameRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return DescriptorEntry.stringValueOf(this.nameRef, this.typeRef);
        }

        static String stringValueOf(Entry entry, Entry entry2) {
            return entry2.stringValue() + "," + entry.stringValue();
        }

        public String prettyString() {
            return this.nameRef.stringValue() + this.typeRef.prettyString();
        }

        public boolean isMethod() {
            return this.typeRef.isMethod();
        }

        public byte getLiteralTag() {
            return this.typeRef.getLiteralTag();
        }
    }

    public static class ClassEntry
    extends Entry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.ref : null;
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        ClassEntry(Entry entry) {
            super((byte)7);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((ClassEntry)object).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.ref.compareTo(((ClassEntry)object).ref);
            }
            return n;
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class StringEntry
    extends LiteralEntry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.ref : null;
        }

        StringEntry(Entry entry) {
            super((byte)8);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((StringEntry)object).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.ref.compareTo(((StringEntry)object).ref);
            }
            return n;
        }

        @Override
        public Comparable literalValue() {
            return this.ref.stringValue();
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class NumberEntry
    extends LiteralEntry {
        final Number value;

        NumberEntry(Number number) {
            super(ConstantPool.numberTagOf(number));
            this.value = number;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((NumberEntry)object).value.equals(this.value);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = ((Comparable)((Object)this.value)).compareTo(((NumberEntry)object).value);
            }
            return n;
        }

        public Number numberValue() {
            return this.value;
        }

        @Override
        public Comparable literalValue() {
            return (Comparable)((Object)this.value);
        }

        @Override
        public String stringValue() {
            return this.value.toString();
        }
    }

    public static abstract class LiteralEntry
    extends Entry {
        protected LiteralEntry(byte by) {
            super(by);
        }

        public abstract Comparable literalValue();
    }

    public static class Utf8Entry
    extends Entry {
        final String value;

        Utf8Entry(String string) {
            super((byte)1);
            this.value = string.intern();
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (!this.sameTagAs(object)) {
                return false;
            }
            return ((Utf8Entry)object).value == this.value;
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.value.compareTo(((Utf8Entry)object).value);
            }
            return n;
        }

        @Override
        public String stringValue() {
            return this.value;
        }
    }

    public static abstract class Entry
    implements Comparable {
        protected final byte tag;
        protected int valueHash;

        protected Entry(byte by) {
            this.tag = by;
        }

        public final byte getTag() {
            return this.tag;
        }

        public Entry getRef(int n) {
            return null;
        }

        public boolean sameTagAs(Object object) {
            return object instanceof Entry && ((Entry)object).tag == this.tag;
        }

        public boolean eq(Entry entry) {
            assert (entry != null);
            return this == entry || this.equals(entry);
        }

        public abstract boolean equals(Object var1);

        public final int hashCode() {
            if (this.valueHash == 0) {
                this.valueHash = this.computeValueHash();
                if (this.valueHash == 0) {
                    this.valueHash = 1;
                }
            }
            return this.valueHash;
        }

        protected abstract int computeValueHash();

        public abstract int compareTo(Object var1);

        protected int superCompareTo(Object object) {
            Entry entry = (Entry)object;
            if (this.tag != entry.tag) {
                return TAG_ORDER[this.tag] - TAG_ORDER[entry.tag];
            }
            return 0;
        }

        public final boolean isDoubleWord() {
            return this.tag == 6 || this.tag == 5;
        }

        public final boolean tagMatches(int n) {
            return this.tag == n;
        }

        public String toString() {
            String string = this.stringValue();
            if (ConstantPool.verbose() > 4) {
                if (this.valueHash != 0) {
                    string = string + " hash=" + this.valueHash;
                }
                string = string + " id=" + System.identityHashCode(this);
            }
            return ConstantPool.tagName(this.tag) + "=" + string;
        }

        public abstract String stringValue();
    }
}

