/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.File;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.openstreetmap.josm.Main;

public class AudioUtil {
    public static double getCalibratedDuration(File wavFile) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new URL("file:".concat(wavFile.getAbsolutePath())));
            AudioFormat audioFormat = audioInputStream.getFormat();
            long filesize = wavFile.length();
            double bytesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getFrameSize();
            double naturalLength = (double)filesize / bytesPerSecond;
            audioInputStream.close();
            double calibration = Main.pref.getDouble("audio.calibration", "1.0");
            return naturalLength / calibration;
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

