/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;

public class PluginUpdatePolicyPanel
extends JPanel {
    private ButtonGroup bgVersionBasedUpdatePolicy;
    private ButtonGroup bgTimeBasedUpdatePolicy;
    private Map<Policy, JRadioButton> rbVersionBasedUpatePolicy;
    private Map<Policy, JRadioButton> rbTimeBasedUpatePolicy;
    private JTextField tfUpdateInterval;
    private JLabel lblUpdateInterval;

    protected JPanel buildVersionBasedUpdatePolicyPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.bgVersionBasedUpdatePolicy = new ButtonGroup();
        this.rbVersionBasedUpatePolicy = new HashMap<Policy, JRadioButton>();
        JRadioButton btn = new JRadioButton(I18n.tr("Ask before updating"));
        this.rbVersionBasedUpatePolicy.put(Policy.ASK, btn);
        this.bgVersionBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Always update withouth asking"));
        this.rbVersionBasedUpatePolicy.put(Policy.ALWAYS, btn);
        this.bgVersionBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Never update"));
        this.rbVersionBasedUpatePolicy.put(Policy.NEVER, btn);
        this.bgVersionBasedUpdatePolicy.add(btn);
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins at startup after an update of JOSM itself."));
        gc.gridy = 0;
        pnl.add((Component)lbl, gc);
        for (Policy p : Policy.values()) {
            ++gc.gridy;
            pnl.add((Component)this.rbVersionBasedUpatePolicy.get((Object)p), gc);
        }
        return pnl;
    }

    protected JPanel buildUpdateIntervalPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        this.lblUpdateInterval = new JLabel(I18n.tr("Update interval (in days):"));
        pnl.add(this.lblUpdateInterval);
        this.tfUpdateInterval = new JTextField(5);
        pnl.add(this.tfUpdateInterval);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUpdateInterval);
        return pnl;
    }

    protected JPanel buildTimeBasedUpdatePolicyPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        TimeBasedPolicyChangeListener changeListener = new TimeBasedPolicyChangeListener();
        this.bgTimeBasedUpdatePolicy = new ButtonGroup();
        this.rbTimeBasedUpatePolicy = new HashMap<Policy, JRadioButton>();
        JRadioButton btn = new JRadioButton(I18n.tr("Ask before updating"));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ASK, btn);
        this.bgTimeBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Always update withouth asking"));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ALWAYS, btn);
        this.bgTimeBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Never update"));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.NEVER, btn);
        this.bgTimeBasedUpdatePolicy.add(btn);
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins after a certain periode of time."));
        gc.gridy = 0;
        pnl.add((Component)lbl, gc);
        for (Policy p : Policy.values()) {
            ++gc.gridy;
            pnl.add((Component)this.rbTimeBasedUpatePolicy.get((Object)p), gc);
        }
        ++gc.gridy;
        pnl.add((Component)this.buildUpdateIntervalPanel(), gc);
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.buildVersionBasedUpdatePolicyPanel(), gc);
        gc.gridy = 1;
        this.add((Component)this.buildTimeBasedUpdatePolicyPanel(), gc);
        gc.gridy = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
    }

    public PluginUpdatePolicyPanel() {
        this.build();
        this.initFromPreferences();
    }

    public void initFromPreferences() {
        String pref = Main.pref.get("pluginmanager.version-based-update.policy", "ask");
        Policy p = Policy.fromPreferenceValue(pref);
        if (p == null) {
            p = Policy.ASK;
        }
        this.rbVersionBasedUpatePolicy.get((Object)p).setSelected(true);
        pref = Main.pref.get("pluginmanager.time-based-update.policy", "ask");
        p = Policy.fromPreferenceValue(pref);
        if (p == null) {
            p = Policy.ASK;
        }
        this.rbTimeBasedUpatePolicy.get((Object)p).setSelected(true);
        pref = Main.pref.get("pluginmanager.warntime", null);
        int days = 0;
        if (pref != null) {
            Main.pref.put("pluginmanager.warntime", null);
            pref = pref.trim();
            try {
                days = Integer.parseInt(pref);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (days <= 0) {
                days = 60;
            }
        }
        if (days == 0) {
            days = Main.pref.getInteger("pluginmanager.time-based-update.interval", 60);
        }
        this.tfUpdateInterval.setText(Integer.toString(days));
    }

    public void rememberInPreferences() {
        for (Policy p : Policy.values()) {
            if (!this.rbVersionBasedUpatePolicy.get((Object)p).isSelected()) continue;
            Main.pref.put("pluginmanager.version-based-update.policy", p.getPreferencesValue());
            break;
        }
        for (Policy p : Policy.values()) {
            if (!this.rbTimeBasedUpatePolicy.get((Object)p).isSelected()) continue;
            Main.pref.put("pluginmanager.time-based-update.policy", p.getPreferencesValue());
            break;
        }
        int days = 0;
        try {
            days = Integer.parseInt(this.tfUpdateInterval.getText().trim());
            if (days <= 0) {
                days = 60;
            }
        }
        catch (NumberFormatException e) {
            days = 60;
        }
        Main.pref.putInteger("pluginmanager.time-based-update.interval", days);
    }

    class TimeBasedPolicyChangeListener
    implements ChangeListener {
        TimeBasedPolicyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            PluginUpdatePolicyPanel.this.lblUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
            PluginUpdatePolicyPanel.this.tfUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Policy {
        ASK("ask"),
        ALWAYS("always"),
        NEVER("never");

        private String preferenceValue;

        private Policy(String preferenceValue) {
            this.preferenceValue = preferenceValue;
        }

        public String getPreferencesValue() {
            return this.preferenceValue;
        }

        static Policy fromPreferenceValue(String preferenceValue) {
            if (preferenceValue == null) {
                return null;
            }
            preferenceValue = preferenceValue.trim().toLowerCase();
            for (Policy p : Policy.values()) {
                if (!p.getPreferencesValue().equals(preferenceValue)) continue;
                return p;
            }
            return null;
        }
    }
}

