/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;

public class SimpleNodeElemStyle
extends ElemStyle {
    public static final SimpleNodeElemStyle INSTANCE = new SimpleNodeElemStyle();

    private SimpleNodeElemStyle() {
        this.minScale = 0L;
        this.maxScale = 1500L;
    }

    private static final int max(int a, int b, int c, int d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings settings, MapPainter painter, boolean selected, boolean member) {
        String name;
        Node n = (Node)primitive;
        String string = name = painter.isShowNames() ? painter.getNodeName(n) : null;
        if (n.isHighlighted()) {
            painter.drawNode(n, settings.getHighlightColor(), settings.getSelectedNodeSize(), settings.isFillSelectedNode(), name);
        } else {
            Color color = painter.isInactive() || n.isDisabled() ? settings.getInactiveColor() : (selected ? (member ? settings.getRelationSelectedColor() : settings.getSelectedColor()) : (n.isConnectionNode() ? (n.isTagged() ? settings.getTaggedConnectionColor() : settings.getConnectionColor()) : (n.isTagged() ? settings.getTaggedColor() : settings.getNodeColor())));
            int size = SimpleNodeElemStyle.max(selected ? settings.getSelectedNodeSize() : 0, n.isTagged() ? settings.getTaggedNodeSize() : 0, n.isConnectionNode() ? settings.getConnectionNodeSize() : 0, settings.getUnselectedNodeSize());
            boolean fill = selected && settings.isFillSelectedNode() || n.isTagged() && settings.isFillTaggedNode() || n.isConnectionNode() && settings.isFillConnectionNode() || settings.isFillUnselectedNode();
            painter.drawNode(n, color, size, fill, name);
        }
    }
}

