/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.tools.I18n;

class FilenameCellEditor
extends JPanel
implements TableCellEditor {
    private JTextField tfFileName;
    private CopyOnWriteArrayList<CellEditorListener> listeners = new CopyOnWriteArrayList();
    private File value;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.tfFileName = new JTextField();
        this.add((Component)this.tfFileName, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.fill = 1;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        this.add(new JButton(new LaunchFileChooserAction()));
        this.tfFileName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilenameCellEditor.this.tfFileName.selectAll();
            }
        });
    }

    public FilenameCellEditor() {
        this.build();
    }

    public void addCellEditorListener(CellEditorListener l) {
        if (l != null) {
            this.listeners.addIfAbsent(l);
        }
    }

    protected void fireEditingCanceled() {
        for (CellEditorListener l : this.listeners) {
            l.editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        for (CellEditorListener l : this.listeners) {
            l.editingStopped(new ChangeEvent(this));
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.value = this.tfFileName.getText() == null || this.tfFileName.getText().trim().equals("") ? null : new File(this.tfFileName.getText());
        this.fireEditingStopped();
        return true;
    }

    public void setInitialValue(File initialValue) {
        this.value = initialValue;
        if (initialValue == null) {
            this.tfFileName.setText("");
        } else {
            this.tfFileName.setText(initialValue.toString());
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        SaveLayerInfo info = (SaveLayerInfo)value;
        this.setInitialValue(info.getFile());
        this.tfFileName.selectAll();
        return this;
    }

    class LaunchFileChooserAction
    extends AbstractAction {
        public LaunchFileChooserAction() {
            this.putValue("Name", "...");
            this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file"));
        }

        public void actionPerformed(ActionEvent e) {
            File f = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Select filename"), "osm");
            if (f != null) {
                FilenameCellEditor.this.tfFileName.setText(f.toString());
                FilenameCellEditor.this.tfFileName.selectAll();
            }
        }
    }
}

