/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTable
extends JTable
implements Observer {
    private VersionTablePopupMenu popupMenu;

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new MouseHandler());
        this.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.popupMenu = new VersionTablePopupMenu();
        this.addMouseListener(new PopupMenuTrigger());
    }

    public VersionTable(HistoryBrowserModel model) {
        super(model.getVersionTableModel(), new VersionTableColumnModel());
        model.addObserver(this);
        this.build();
    }

    protected void handleSelectReferencePointInTime(int row) {
        this.getVersionTableModel().setReferencePointInTime(row);
    }

    protected void handleSelectCurrentPointInTime(int row) {
        this.getVersionTableModel().setCurrentPointInTime(row);
    }

    protected HistoryBrowserModel.VersionTableModel getVersionTableModel() {
        return (HistoryBrowserModel.VersionTableModel)this.getModel();
    }

    public void update(Observable o, Object arg) {
        this.repaint();
    }

    protected void showPopupMenu(MouseEvent evt) {
        HistoryBrowserModel.VersionTableModel model = this.getVersionTableModel();
        int row = this.getSelectedRow();
        if (row == -1) {
            row = this.rowAtPoint(evt.getPoint());
        }
        if (!model.isLatest(row)) {
            HistoryOsmPrimitive primitive = model.getPrimitive(row);
            this.popupMenu.prepare(primitive);
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    static class VersionTablePopupMenu
    extends JPopupMenu {
        private ChangesetInfoAction changesetInfoAction;

        protected void build() {
            this.changesetInfoAction = new ChangesetInfoAction();
            this.add(this.changesetInfoAction);
        }

        public VersionTablePopupMenu() {
            this.build();
        }

        public void prepare(HistoryOsmPrimitive primitive) {
            this.changesetInfoAction.prepare(primitive);
            this.invalidate();
        }
    }

    static class ChangesetInfoAction
    extends AbstractInfoAction {
        private HistoryOsmPrimitive primitive;

        public ChangesetInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("Changeset info"));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the changeset"));
            this.putValue("SmallIcon", ImageProvider.get("about"));
        }

        protected String createInfoUrl(Object infoObject) {
            HistoryOsmPrimitive primitive = (HistoryOsmPrimitive)infoObject;
            return ChangesetInfoAction.getBaseBrowseUrl() + "/changeset/" + primitive.getChangesetId();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            String url = this.createInfoUrl(this.primitive);
            this.launchBrowser(url);
        }

        public void prepare(HistoryOsmPrimitive primitive) {
            this.putValue("Name", I18n.tr("Show changeset {0}", primitive.getChangesetId()));
            this.primitive = primitive;
        }
    }

    class PopupMenuTrigger
    extends MouseAdapter {
        PopupMenuTrigger() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                VersionTable.this.showPopupMenu(e);
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
            if (model.getMinSelectionIndex() >= 0) {
                VersionTable.this.handleSelectCurrentPointInTime(model.getMinSelectionIndex());
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        protected void handleDoubleClick(MouseEvent e) {
            int row = VersionTable.this.rowAtPoint(e.getPoint());
            VersionTable.this.handleSelectReferencePointInTime(row);
        }

        public void mouseClicked(MouseEvent e) {
            switch (e.getClickCount()) {
                case 2: {
                    this.handleDoubleClick(e);
                }
            }
        }
    }
}

