/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesetHeaderDownloadTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private Set<Integer> idsToDownload;
    private OsmServerChangesetReader reader;
    private boolean canceled;
    private Exception lastException;
    private Set<Changeset> downloadedChangesets;

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Collection<Changeset> changesets) {
        return ChangesetHeaderDownloadTask.buildTaskForChangesets(Main.parent, changesets);
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Component parent, Collection<Changeset> changesets) {
        CheckParameterUtil.ensureParameterNotNull(parent, "parent");
        if (changesets == null) {
            changesets = Collections.emptyList();
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Changeset cs : changesets) {
            if (cs == null || cs.isNew()) continue;
            ids.add(cs.getId());
        }
        if (parent == null) {
            return new ChangesetHeaderDownloadTask(ids);
        }
        return new ChangesetHeaderDownloadTask(parent, ids);
    }

    protected void init(Collection<Integer> ids) {
        if (ids == null) {
            ids = Collections.emptyList();
        }
        this.idsToDownload = new HashSet<Integer>();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        for (int id : ids) {
            if (id <= 0) continue;
            this.idsToDownload.add(id);
        }
    }

    public ChangesetHeaderDownloadTask(Collection<Integer> ids) {
        super(I18n.tr("Download changesets"), false);
        this.init(ids);
    }

    public ChangesetHeaderDownloadTask(Component dialogParent, Collection<Integer> ids) throws IllegalArgumentException {
        super(dialogParent, I18n.tr("Download changesets"), false);
        this.init(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetHeaderDownloadTask changesetHeaderDownloadTask = this;
        synchronized (changesetHeaderDownloadTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
        Runnable r = new Runnable(){

            public void run() {
                ChangesetCache.getInstance().update(ChangesetHeaderDownloadTask.this.downloadedChangesets);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    BugReportExceptionHandler.handleException(t);
                }
                if (t instanceof Exception) {
                    ExceptionUtil.explainException(e);
                }
                BugReportExceptionHandler.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = this;
            synchronized (changesetHeaderDownloadTask) {
                this.reader = new OsmServerChangesetReader();
            }
            this.downloadedChangesets = new HashSet<Changeset>();
            this.downloadedChangesets.addAll(this.reader.readChangesets(this.idsToDownload, this.getProgressMonitor().createSubTaskMonitor(0, false)));
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

