/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.text.View;

public class JMultilineLabel
extends JLabel {
    private int maxWidth = Integer.MAX_VALUE;
    private Dimension superPreferred = null;
    private Rectangle oldbounds = null;
    private Dimension oldPreferred = null;

    public JMultilineLabel(String text) {
        text = text.trim().replaceAll("\n", "<br>");
        if (!text.startsWith("<html>")) {
            text = "<html>" + text + "</html>";
        }
        super.setText(text);
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public Dimension getPreferredSize() {
        if (this.getBounds().equals(this.oldbounds) && this.oldPreferred != null) {
            return this.oldPreferred;
        }
        this.oldbounds = this.getBounds();
        this.superPreferred = super.getPreferredSize();
        int width = Math.min(this.superPreferred.width, this.maxWidth);
        View v = (View)super.getClientProperty("html");
        if (v == null) {
            return this.superPreferred;
        }
        v.setSize(width, 0.0f);
        int w = (int)Math.ceil(v.getPreferredSpan(0));
        int h = (int)Math.ceil(v.getPreferredSpan(1));
        this.oldPreferred = new Dimension(w, h);
        return this.oldPreferred;
    }
}

