/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected String decorateNameWithId(String name, OsmPrimitive primitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            if (Main.pref.getBoolean("osm-primitives.showid.new-primitives")) {
                return name + I18n.tr(" [id: {0}]", primitive.getUniqueId());
            }
            return name + I18n.tr(" [id: {0}]", primitive.getId());
        }
        return name;
    }

    @Override
    public String format(Node node) {
        String name = "";
        if (node.isIncomplete()) {
            name = I18n.tr("incomplete");
        } else {
            name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
            if (name == null) {
                name = node.isNew() ? I18n.tr("node") : "" + node.getId();
            }
            name = name + " (" + node.getCoor().latToString(CoordinateFormat.getDefaultFormat()) + ", " + node.getCoor().lonToString(CoordinateFormat.getDefaultFormat()) + ")";
        }
        name = this.decorateNameWithId(name, node);
        return name;
    }

    @Override
    public String format(Way way) {
        String name = "";
        if (way.isIncomplete()) {
            name = I18n.tr("incomplete");
        } else {
            int nodesNo;
            name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
            if (name == null) {
                name = way.get("ref");
            }
            if (name == null) {
                String string = way.get("highway") != null ? I18n.tr("highway") : (way.get("railway") != null ? I18n.tr("railway") : (way.get("waterway") != null ? I18n.tr("waterway") : (name = way.get("landuse") != null ? I18n.tr("landuse") : "")));
            }
            if ((nodesNo = way.getNodesCount()) > 1 && way.isClosed()) {
                --nodesNo;
            }
            if (name.length() == 0) {
                name = String.valueOf(way.getId());
            }
            String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
            name = name + (name.length() > 0 ? " (" + nodes + ")" : nodes);
        }
        name = this.decorateNameWithId(name, way);
        return name;
    }

    @Override
    public String format(Relation relation) {
        String name;
        if (relation.isIncomplete()) {
            name = I18n.tr("incomplete");
        } else {
            String admin_level;
            name = I18n.trc("Relation type", relation.get("type"));
            if (name == null) {
                String string = name = relation.get("public_transport") != null ? I18n.tr("public transport") : "";
            }
            if (name == null) {
                String building = relation.get("building");
                if (OsmUtils.isTrue(building)) {
                    name = I18n.tr("building");
                } else if (building != null) {
                    name = I18n.tr(building);
                }
            }
            if (name == null) {
                name = I18n.tr("relation");
            }
            if ((admin_level = relation.get("admin_level")) != null) {
                name = name + "[" + admin_level + "]";
            }
            name = name + " (";
            String nameTag = null;
            for (String n : DefaultNameFormatter.getNamingtagsForRelations()) {
                if (n.equals("name")) {
                    nameTag = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName();
                } else if (n.equals(":LocationCode")) {
                    for (String string : relation.keySet()) {
                        if (!string.endsWith(n)) continue;
                        nameTag = relation.get(string);
                        break;
                    }
                } else {
                    String str = relation.get(n);
                    if (str != null) {
                        nameTag = I18n.tr(str);
                    }
                }
                if (nameTag == null) continue;
                break;
            }
            name = nameTag == null ? name + Long.toString(relation.getId()) + ", " : name + "\"" + nameTag + "\", ";
            int mbno = relation.getMembersCount();
            name = name + I18n.trn("{0} member", "{0} members", mbno, mbno);
            boolean incomplete = false;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getMember().isIncomplete()) continue;
                incomplete = true;
                break;
            }
            if (incomplete) {
                name = name + ", " + I18n.tr("incomplete");
            }
            name = name + ")";
        }
        name = this.decorateNameWithId(name, relation);
        return name;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(OsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void decorateNameWithId(StringBuilder name, HistoryOsmPrimitive primitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            name.append(I18n.tr(" [id: {0}]", primitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode node) {
        StringBuilder sb = new StringBuilder();
        String name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
        if (name == null) {
            sb.append(node.getId());
        } else {
            sb.append(name);
        }
        sb.append(" (").append(node.getCoords().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(node.getCoords().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        this.decorateNameWithId(sb, node);
        return sb.toString();
    }

    @Override
    public String format(HistoryWay way) {
        StringBuilder sb = new StringBuilder();
        String name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
        if (name != null) {
            sb.append(name);
        }
        if (sb.length() == 0 && way.get("ref") != null) {
            sb.append(way.get("ref"));
        }
        if (sb.length() == 0) {
            sb.append(way.get("highway") != null ? I18n.tr("highway") : (way.get("railway") != null ? I18n.tr("railway") : (way.get("waterway") != null ? I18n.tr("waterway") : (way.get("landuse") != null ? I18n.tr("landuse") : ""))));
        }
        int nodesNo = way.isClosed() ? way.getNumNodes() - 1 : way.getNumNodes();
        String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
        if (sb.length() == 0) {
            sb.append(way.getId());
        }
        sb.append(sb.length() > 0 ? " (" + nodes + ")" : nodes);
        this.decorateNameWithId(sb, way);
        return sb.toString();
    }

    @Override
    public String format(HistoryRelation relation) {
        StringBuilder sb = new StringBuilder();
        if (relation.get("type") != null) {
            sb.append(relation.get("type"));
        } else {
            sb.append(I18n.tr("relation"));
        }
        sb.append(" (");
        String nameTag = null;
        HashSet<String> namingTags = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String n : relation.getTags().keySet()) {
            if (namingTags.contains(n.trim()) && (nameTag = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName()) == null) {
                nameTag = relation.get(n);
            }
            if (nameTag == null) continue;
            break;
        }
        if (nameTag == null) {
            sb.append(Long.toString(relation.getId())).append(", ");
        } else {
            sb.append("\"").append(nameTag).append("\", ");
        }
        int mbno = relation.getNumMembers();
        sb.append(I18n.trn("{0} member", "{0} members", mbno, mbno)).append(")");
        this.decorateNameWithId(sb, relation);
        return sb.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.getTags().keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    static {
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "public_transport", ":LocationCode", "note"};
        namingTagsForRelations = null;
    }
}

