/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissGrid
implements Projection,
ProjectionSubPrefs {
    private static final double dX = 674.374;
    private static final double dY = 15.056;
    private static final double dZ = 405.346;
    private static final double phi0 = Math.toRadians(46.95240555555556);
    private static final double lambda0 = Math.toRadians(7.439583333333333);
    private static final double R = Ellipsoid.Bessel1841.a * Math.sqrt(1.0 - Ellipsoid.Bessel1841.e2) / (1.0 - Ellipsoid.Bessel1841.e2 * Math.pow(Math.sin(phi0), 2.0));
    private static final double alpha = Math.sqrt(1.0 + Ellipsoid.Bessel1841.eb2 * Math.pow(Math.cos(phi0), 4.0));
    private static final double b0 = Math.asin(Math.sin(phi0) / alpha);
    private static final double K = Math.log(Math.tan(0.7853981633974483 + b0 / 2.0)) - alpha * Math.log(Math.tan(0.7853981633974483 + phi0 / 2.0)) + alpha * Ellipsoid.Bessel1841.e / 2.0 * Math.log((1.0 + Ellipsoid.Bessel1841.e * Math.sin(phi0)) / (1.0 - Ellipsoid.Bessel1841.e * Math.sin(phi0)));
    private static final double xTrans = 200000.0;
    private static final double yTrans = 600000.0;
    private static final double DELTA_PHI = 1.0E-11;

    private LatLon correctEllipoideGSR80toBressel1841(LatLon coord) {
        double[] XYZ = Ellipsoid.WGS84.latLon2Cart(coord);
        XYZ[0] = XYZ[0] - 674.374;
        XYZ[1] = XYZ[1] - 15.056;
        XYZ[2] = XYZ[2] - 405.346;
        return Ellipsoid.Bessel1841.cart2LatLon(XYZ);
    }

    private LatLon correctEllipoideBressel1841toGRS80(LatLon coord) {
        double[] XYZ = Ellipsoid.Bessel1841.latLon2Cart(coord);
        XYZ[0] = XYZ[0] + 674.374;
        XYZ[1] = XYZ[1] + 15.056;
        XYZ[2] = XYZ[2] + 405.346;
        return Ellipsoid.WGS84.cart2LatLon(XYZ);
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon wgs) {
        LatLon coord = this.correctEllipoideGSR80toBressel1841(wgs);
        double phi = Math.toRadians(coord.lat());
        double lambda = Math.toRadians(coord.lon());
        double S = alpha * Math.log(Math.tan(0.7853981633974483 + phi / 2.0)) - alpha * Ellipsoid.Bessel1841.e / 2.0 * Math.log((1.0 + Ellipsoid.Bessel1841.e * Math.sin(phi)) / (1.0 - Ellipsoid.Bessel1841.e * Math.sin(phi))) + K;
        double b = 2.0 * (Math.atan(Math.exp(S)) - 0.7853981633974483);
        double l = alpha * (lambda - lambda0);
        double lb = Math.atan2(Math.sin(l), Math.sin(b0) * Math.tan(b) + Math.cos(b0) * Math.cos(l));
        double bb = Math.asin(Math.cos(b0) * Math.sin(b) - Math.sin(b0) * Math.cos(b) * Math.cos(l));
        double y = R * lb;
        double x = R / 2.0 * Math.log((1.0 + Math.sin(bb)) / (1.0 - Math.sin(bb)));
        return new EastNorth(y + 600000.0, x + 200000.0);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth xy) {
        double x = xy.north() - 200000.0;
        double y = xy.east() - 600000.0;
        double lb = y / R;
        double bb = 2.0 * (Math.atan(Math.exp(x / R)) - 0.7853981633974483);
        double b = Math.asin(Math.cos(b0) * Math.sin(bb) + Math.sin(b0) * Math.cos(bb) * Math.cos(lb));
        double l = Math.atan2(Math.sin(lb), Math.cos(b0) * Math.cos(lb) - Math.sin(b0) * Math.tan(bb));
        double lambda = lambda0 + l / alpha;
        double phi = b;
        double S = 0.0;
        double prevPhi = -1000.0;
        int iteration = 0;
        while (Math.abs(phi - prevPhi) > 1.0E-11) {
            if (++iteration > 30) {
                throw new RuntimeException("Two many iterations");
            }
            prevPhi = phi;
            S = 1.0 / alpha * (Math.log(Math.tan(0.7853981633974483 + b / 2.0)) - K) + Ellipsoid.Bessel1841.e * Math.log(Math.tan(0.7853981633974483 + Math.asin(Ellipsoid.Bessel1841.e * Math.sin(phi)) / 2.0));
            phi = 2.0 * Math.atan(Math.exp(S)) - 1.5707963267948966;
        }
        LatLon coord = this.correctEllipoideBressel1841toGRS80(new LatLon(Math.toDegrees(phi), Math.toDegrees(lambda)));
        return coord;
    }

    @Override
    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)");
    }

    @Override
    public String toCode() {
        return "EPSG:21781";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6));
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 1.01;
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        p.add((Component)new HtmlPanel("<i>CH1903 / LV03 (without local corrections)</i>"), GBC.eol().fill(2));
        p.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    @Override
    public void setPreferences(Collection<String> args) {
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        return Collections.singletonList("CH1903");
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if ("EPSG:21781".equals(code)) {
            return Collections.singletonList("CH1903");
        }
        return null;
    }
}

