/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;

public class DatasetFactory {
    private final DataSet ds;

    public DatasetFactory() {
        this.ds = new DataSet();
    }

    public DatasetFactory(DataSet ds) {
        this.ds = ds;
    }

    public Node getNode(long id) {
        return (Node)this.ds.getPrimitiveById(id, OsmPrimitiveType.NODE);
    }

    public Way getWay(long id) {
        return (Way)this.ds.getPrimitiveById(id, OsmPrimitiveType.WAY);
    }

    public Relation getRelation(long id) {
        return (Relation)this.ds.getPrimitiveById(id, OsmPrimitiveType.RELATION);
    }

    public Node addNode(long id) {
        return this.addNode(id, 0);
    }

    public Way addWay(long id) {
        return this.addWay(id, 0);
    }

    public Relation addRelation(long id) {
        return this.addRelation(id, 0);
    }

    public Node addNode(long id, int version) {
        Node n = new Node(id, version);
        this.ds.addPrimitive(n);
        return n;
    }

    public Way addWay(long id, int version) {
        Way w = new Way(id, version);
        this.ds.addPrimitive(w);
        return w;
    }

    public Relation addRelation(long id, int version) {
        Relation e = new Relation(id, version);
        this.ds.addPrimitive(e);
        return e;
    }
}

