/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Changeset
implements Tagged {
    private int id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private Map<String, String> tags;
    private boolean incomplete;
    private ChangesetDataSet content = null;

    public Changeset() {
        this.id = 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(int id) {
        this.id = id;
        this.incomplete = id > 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset other) {
        if (other == null) {
            this.id = 0;
            this.tags = new HashMap<String, String>();
        } else if (other.isIncomplete()) {
            this.setId(other.getId());
            this.incomplete = true;
            this.tags = new HashMap<String, String>();
        } else {
            this.id = other.id;
            this.mergeFrom(other);
            this.incomplete = false;
        }
    }

    public void visit(Visitor v) {
        v.visit(this);
    }

    public int compareTo(Changeset other) {
        return Integer.valueOf(this.getId()).compareTo(other.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = closedAt;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon min) {
        this.min = min;
    }

    public LatLon getMax() {
        return this.max;
    }

    public Bounds getBounds() {
        if (this.min != null && this.max != null) {
            return new Bounds(this.min, this.max);
        }
        return null;
    }

    public void setMax(LatLon max) {
        this.max = max;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        this.tags = keys;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    @Override
    public void put(String key, String value) {
        this.tags.put(key, value);
    }

    @Override
    public String get(String key) {
        return this.tags.get(key);
    }

    @Override
    public void remove(String key) {
        this.tags.remove(key);
    }

    @Override
    public void removeAll() {
        this.tags.clear();
    }

    public boolean hasEqualSemanticAttributes(Changeset other) {
        if (other == null) {
            return false;
        }
        if (this.closedAt == null ? other.closedAt != null : !this.closedAt.equals(other.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        if (this.open != other.open) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !((Object)this.tags).equals(other.tags)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public int hashCode() {
        if (this.id > 0) {
            return this.id;
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Changeset other = (Changeset)obj;
        if (this.id > 0 && other.id == this.id) {
            return true;
        }
        return this == obj;
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }

    public boolean isNew() {
        return this.id <= 0;
    }

    public void mergeFrom(Changeset other) {
        if (other == null) {
            return;
        }
        if (this.id != other.id) {
            return;
        }
        this.user = other.user;
        this.createdAt = other.createdAt;
        this.closedAt = other.closedAt;
        this.open = other.open;
        this.min = other.min;
        this.max = other.max;
        this.tags = new HashMap<String, String>(other.tags);
        this.incomplete = other.incomplete;
        this.content = other.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ChangesetDataSet getContent() {
        return this.content;
    }

    public void setContent(ChangesetDataSet content) {
        this.content = content;
    }
}

