/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.List;
import org.openstreetmap.josm.corrector.CorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCorrectionTableModel
extends CorrectionTableModel<TagCorrection> {
    public TagCorrectionTableModel(List<TagCorrection> tagCorrections) {
        super(tagCorrections);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getCorrectionColumnName(int colIndex) {
        switch (colIndex) {
            case 0: {
                return I18n.tr("Old key");
            }
            case 1: {
                return I18n.tr("Old value");
            }
            case 2: {
                return I18n.tr("New key");
            }
            case 3: {
                return I18n.tr("New value");
            }
        }
        return null;
    }

    @Override
    public Object getCorrectionValueAt(int rowIndex, int colIndex) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(rowIndex);
        switch (colIndex) {
            case 0: {
                return tagCorrection.oldKey;
            }
            case 1: {
                return tagCorrection.oldValue;
            }
            case 2: {
                return tagCorrection.newKey;
            }
            case 3: {
                return tagCorrection.newValue;
            }
        }
        return null;
    }

    @Override
    protected boolean isBoldCell(int row, int column) {
        TagCorrection tagCorrection = (TagCorrection)this.getCorrections().get(row);
        return column == 2 && tagCorrection.isKeyChanged() || column == 3 && tagCorrection.isValueChanged();
    }
}

