/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberConflictResolverCommand
extends Command {
    private static final Logger logger = Logger.getLogger(RelationMemberConflictResolverCommand.class.getName());
    private final Relation my;
    private final Relation their;
    private final List<RelationMember> mergedMembers;
    private OsmDataLayer layer;

    public RelationMemberConflictResolverCommand(Relation my, Relation their, List<RelationMember> mergedMembers) {
        this.my = my;
        this.their = their;
        this.mergedMembers = mergedMembers;
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Resolve conflicts in member list of relation {0}", this.my.getId()), ImageProvider.get("data", "object"), 0);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.setMembers(this.mergedMembers);
        this.layer = Main.map.mapView.getEditLayer();
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.my);
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.layer)) {
            logger.warning(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.layer.toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.layer);
        OsmDataLayer editLayer = Main.map.mapView.getEditLayer();
        super.undoCommand();
        if (!editLayer.getConflicts().hasConflictForMy(this.my)) {
            editLayer.getConflicts().add(this.my, this.their);
        }
    }
}

