/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Interval;

public class Annotation {
    private Interval interval;
    private List strings = new ArrayList();
    private List heights = new ArrayList();
    private Color baseColor;
    private int width;
    private int height;
    private int x;
    private int y;

    public Annotation(Address lowAddress, Address highAddress, String s) {
        StringTokenizer tok = new StringTokenizer(s, "\n");
        while (tok.hasMoreTokens()) {
            this.strings.add(tok.nextToken());
        }
        if (AddressOps.lessThan(highAddress, lowAddress)) {
            Address temp = lowAddress;
            lowAddress = highAddress;
            highAddress = temp;
        }
        this.interval = new Interval(lowAddress, highAddress);
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Address getLowAddress() {
        return (Address)this.getInterval().getLowEndpoint();
    }

    public Address getHighAddress() {
        return (Address)this.getInterval().getHighEndpoint();
    }

    public void draw(Graphics g) {
        g.setColor(this.baseColor);
        int tmpY = this.y;
        for (int i = 0; i < this.strings.size(); ++i) {
            String s = (String)this.strings.get(i);
            Integer h = (Integer)this.heights.get(i);
            g.drawString(s, this.x, tmpY);
            tmpY += h.intValue();
        }
    }

    public void setColor(Color c) {
        this.baseColor = c;
    }

    public Color getColor() {
        return this.baseColor;
    }

    public void computeWidthAndHeight(Graphics g) {
        this.width = 0;
        this.height = 0;
        this.heights.clear();
        Iterator iter = this.strings.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            Rectangle2D bounds = GraphicsUtilities.getStringBounds(s, g);
            this.width = Math.max(this.width, (int)bounds.getWidth());
            this.height += (int)bounds.getHeight();
            this.heights.add(new Integer((int)bounds.getHeight()));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setXAndY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        String result = "Annotation: lowAddr: " + this.getLowAddress() + " highAddr: " + this.getHighAddress() + " strings: " + this.strings.size();
        for (int i = 0; i < this.strings.size(); ++i) {
            result = result + "\n" + (String)this.strings.get(i);
        }
        return result;
    }
}

