/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelTransform;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftMainMixer;
import com.sun.media.sound.SoftPerformer;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;

public class SoftChannel
implements MidiChannel,
ModelDirectedPlayer {
    private static boolean[] dontResetControls = new boolean[128];
    private static final int RPN_NULL_VALUE = 16383;
    private int rpn_control = 16383;
    private int nrpn_control = 16383;
    protected double portamento_time = 1.0;
    protected int[] portamento_lastnote = new int[128];
    protected int portamento_lastnote_ix = 0;
    private boolean portamento = false;
    private boolean mono = false;
    private boolean mute = false;
    private boolean solo = false;
    private boolean solomute = false;
    private Object control_mutex;
    private int channel;
    private SoftVoice[] voices;
    private int bank;
    private int program;
    private SoftSynthesizer synthesizer;
    private SoftMainMixer mainmixer;
    private int[] polypressure = new int[128];
    private int channelpressure = 0;
    private int[] controller = new int[128];
    private int pitchbend;
    private double[] co_midi_pitch = new double[1];
    private double[] co_midi_channel_pressure = new double[1];
    protected SoftTuning tuning = new SoftTuning();
    protected int tuning_bank = 0;
    protected int tuning_program = 0;
    protected SoftInstrument current_instrument = null;
    protected ModelChannelMixer current_mixer = null;
    protected ModelDirector current_director = null;
    protected int cds_control_number = -1;
    protected ModelConnectionBlock[] cds_control_connections = null;
    protected ModelConnectionBlock[] cds_channelpressure_connections = null;
    protected ModelConnectionBlock[] cds_polypressure_connections = null;
    protected boolean sustain = false;
    protected boolean[][] keybasedcontroller_active = null;
    protected double[][] keybasedcontroller_value = null;
    private SoftControl[] co_midi = new SoftControl[128];
    private double[][] co_midi_cc_cc;
    private SoftControl co_midi_cc;
    Map<Integer, int[]> co_midi_rpn_rpn_i;
    Map<Integer, double[]> co_midi_rpn_rpn;
    private SoftControl co_midi_rpn;
    Map<Integer, int[]> co_midi_nrpn_nrpn_i;
    Map<Integer, double[]> co_midi_nrpn_nrpn;
    private SoftControl co_midi_nrpn;
    private int[] lastVelocity;
    private int prevVoiceID;
    private boolean firstVoice;
    private int voiceNo;
    private int play_noteNumber;
    private int play_velocity;
    private int play_delay;
    private boolean play_releasetriggered;

    private static int restrict7Bit(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 127) {
            return 127;
        }
        return n;
    }

    private static int restrict14Bit(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 16256) {
            return 16256;
        }
        return n;
    }

    public SoftChannel(SoftSynthesizer softSynthesizer, int n) {
        for (int i = 0; i < this.co_midi.length; ++i) {
            this.co_midi[i] = new MidiControlObject();
        }
        this.co_midi_cc_cc = new double[128][1];
        this.co_midi_cc = new SoftControl(){
            double[][] cc;
            {
                this.cc = SoftChannel.this.co_midi_cc_cc;
            }

            @Override
            public double[] get(int n, String string) {
                if (string == null) {
                    return null;
                }
                return this.cc[Integer.parseInt(string)];
            }
        };
        this.co_midi_rpn_rpn_i = new HashMap<Integer, int[]>();
        this.co_midi_rpn_rpn = new HashMap<Integer, double[]>();
        this.co_midi_rpn = new SoftControl(){
            Map<Integer, double[]> rpn;
            {
                this.rpn = SoftChannel.this.co_midi_rpn_rpn;
            }

            @Override
            public double[] get(int n, String string) {
                if (string == null) {
                    return null;
                }
                int n2 = Integer.parseInt(string);
                double[] dArray = this.rpn.get(n2);
                if (dArray == null) {
                    dArray = new double[1];
                    this.rpn.put(n2, dArray);
                }
                return dArray;
            }
        };
        this.co_midi_nrpn_nrpn_i = new HashMap<Integer, int[]>();
        this.co_midi_nrpn_nrpn = new HashMap<Integer, double[]>();
        this.co_midi_nrpn = new SoftControl(){
            Map<Integer, double[]> nrpn;
            {
                this.nrpn = SoftChannel.this.co_midi_nrpn_nrpn;
            }

            @Override
            public double[] get(int n, String string) {
                if (string == null) {
                    return null;
                }
                int n2 = Integer.parseInt(string);
                double[] dArray = this.nrpn.get(n2);
                if (dArray == null) {
                    dArray = new double[1];
                    this.nrpn.put(n2, dArray);
                }
                return dArray;
            }
        };
        this.lastVelocity = new int[128];
        this.firstVoice = true;
        this.voiceNo = 0;
        this.play_noteNumber = 0;
        this.play_velocity = 0;
        this.play_delay = 0;
        this.play_releasetriggered = false;
        this.channel = n;
        this.voices = softSynthesizer.getVoices();
        this.synthesizer = softSynthesizer;
        this.mainmixer = softSynthesizer.getMainMixer();
        this.control_mutex = softSynthesizer.control_mutex;
        this.resetAllControllers(true);
    }

    private int findFreeVoice(int n) {
        int n2;
        int n3;
        if (n == -1) {
            return -1;
        }
        for (n3 = n; n3 < this.voices.length; ++n3) {
            if (this.voices[n3].active) continue;
            return n3;
        }
        n3 = this.synthesizer.getVoiceAllocationMode();
        if (n3 == 1) {
            int n4;
            int n5;
            int n6 = this.channel;
            for (n5 = 0; n5 < this.voices.length; ++n5) {
                if (this.voices[n5].stealer_channel != null) continue;
                if (n6 == 9) {
                    n6 = this.voices[n5].channel;
                    continue;
                }
                if (this.voices[n5].channel == 9 || this.voices[n5].channel <= n6) continue;
                n6 = this.voices[n5].channel;
            }
            n5 = -1;
            SoftVoice softVoice = null;
            for (n4 = 0; n4 < this.voices.length; ++n4) {
                if (this.voices[n4].channel != n6 || this.voices[n4].stealer_channel != null || this.voices[n4].on) continue;
                if (softVoice == null) {
                    softVoice = this.voices[n4];
                    n5 = n4;
                }
                if (this.voices[n4].voiceID >= softVoice.voiceID) continue;
                softVoice = this.voices[n4];
                n5 = n4;
            }
            if (n5 == -1) {
                for (n4 = 0; n4 < this.voices.length; ++n4) {
                    if (this.voices[n4].channel != n6 || this.voices[n4].stealer_channel != null) continue;
                    if (softVoice == null) {
                        softVoice = this.voices[n4];
                        n5 = n4;
                    }
                    if (this.voices[n4].voiceID >= softVoice.voiceID) continue;
                    softVoice = this.voices[n4];
                    n5 = n4;
                }
            }
            return n5;
        }
        int n7 = -1;
        SoftVoice softVoice = null;
        for (n2 = 0; n2 < this.voices.length; ++n2) {
            if (this.voices[n2].stealer_channel != null || this.voices[n2].on) continue;
            if (softVoice == null) {
                softVoice = this.voices[n2];
                n7 = n2;
            }
            if (this.voices[n2].voiceID >= softVoice.voiceID) continue;
            softVoice = this.voices[n2];
            n7 = n2;
        }
        if (n7 == -1) {
            for (n2 = 0; n2 < this.voices.length; ++n2) {
                if (this.voices[n2].stealer_channel != null) continue;
                if (softVoice == null) {
                    softVoice = this.voices[n2];
                    n7 = n2;
                }
                if (this.voices[n2].voiceID >= softVoice.voiceID) continue;
                softVoice = this.voices[n2];
                n7 = n2;
            }
        }
        return n7;
    }

    protected void initVoice(SoftVoice softVoice, SoftPerformer softPerformer, int n, int n2, int n3, int n4, ModelConnectionBlock[] modelConnectionBlockArray, ModelChannelMixer modelChannelMixer, boolean bl) {
        if (softVoice.active) {
            softVoice.stealer_channel = this;
            softVoice.stealer_performer = softPerformer;
            softVoice.stealer_voiceID = n;
            softVoice.stealer_noteNumber = n2;
            softVoice.stealer_velocity = n3;
            softVoice.stealer_extendedConnectionBlocks = modelConnectionBlockArray;
            softVoice.stealer_channelmixer = modelChannelMixer;
            softVoice.stealer_releaseTriggered = bl;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].voiceID != softVoice.voiceID) continue;
                this.voices[i].soundOff();
            }
            return;
        }
        softVoice.extendedConnectionBlocks = modelConnectionBlockArray;
        softVoice.channelmixer = modelChannelMixer;
        softVoice.releaseTriggered = bl;
        softVoice.voiceID = n;
        softVoice.tuning = this.tuning;
        softVoice.exclusiveClass = softPerformer.exclusiveClass;
        softVoice.softchannel = this;
        softVoice.channel = this.channel;
        softVoice.bank = this.bank;
        softVoice.program = this.program;
        softVoice.instrument = this.current_instrument;
        softVoice.performer = softPerformer;
        softVoice.objects.clear();
        softVoice.objects.put("midi", this.co_midi[n2]);
        softVoice.objects.put("midi_cc", this.co_midi_cc);
        softVoice.objects.put("midi_rpn", this.co_midi_rpn);
        softVoice.objects.put("midi_nrpn", this.co_midi_nrpn);
        softVoice.noteOn(n2, n3, n4);
        softVoice.setMute(this.mute);
        softVoice.setSoloMute(this.solomute);
        if (bl) {
            return;
        }
        if (this.controller[84] != 0) {
            softVoice.co_noteon_keynumber[0] = this.tuning.getTuning(this.controller[84]) / 100.0 * 0.0078125;
            softVoice.portamento = true;
            this.controlChange(84, 0);
        } else if (this.portamento) {
            if (this.mono) {
                if (this.portamento_lastnote[0] != -1) {
                    softVoice.co_noteon_keynumber[0] = this.tuning.getTuning(this.portamento_lastnote[0]) / 100.0 * 0.0078125;
                    softVoice.portamento = true;
                    this.controlChange(84, 0);
                }
                this.portamento_lastnote[0] = n2;
            } else if (this.portamento_lastnote_ix != 0) {
                --this.portamento_lastnote_ix;
                softVoice.co_noteon_keynumber[0] = this.tuning.getTuning(this.portamento_lastnote[this.portamento_lastnote_ix]) / 100.0 * 0.0078125;
                softVoice.portamento = true;
            }
        }
    }

    @Override
    public void noteOn(int n, int n2) {
        this.noteOn(n, n2, 0);
    }

    protected void noteOn(int n, int n2, int n3) {
        n = SoftChannel.restrict7Bit(n);
        n2 = SoftChannel.restrict7Bit(n2);
        this.noteOn_internal(n, n2, n3);
        if (this.current_mixer != null) {
            this.current_mixer.noteOn(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOn_internal(int n, int n2, int n3) {
        if (n2 == 0) {
            this.noteOff_internal(n, 64);
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            int n4;
            if (this.sustain) {
                this.sustain = false;
                for (n4 = 0; n4 < this.voices.length; ++n4) {
                    if (!this.voices[n4].sustain && !this.voices[n4].on || this.voices[n4].channel != this.channel || !this.voices[n4].active || this.voices[n4].note != n) continue;
                    this.voices[n4].sustain = false;
                    this.voices[n4].on = true;
                    this.voices[n4].noteOff(0);
                }
                this.sustain = true;
            }
            this.mainmixer.activity();
            if (this.mono) {
                int n5;
                if (this.portamento) {
                    n4 = 0;
                    for (n5 = 0; n5 < this.voices.length; ++n5) {
                        if (!this.voices[n5].on || this.voices[n5].channel != this.channel || !this.voices[n5].active || this.voices[n5].releaseTriggered) continue;
                        this.voices[n5].portamento = true;
                        this.voices[n5].setNote(n);
                        n4 = 1;
                    }
                    if (n4 != 0) {
                        this.portamento_lastnote[0] = n;
                        return;
                    }
                }
                if (this.controller[84] != 0) {
                    n4 = 0;
                    for (n5 = 0; n5 < this.voices.length; ++n5) {
                        if (!this.voices[n5].on || this.voices[n5].channel != this.channel || !this.voices[n5].active || this.voices[n5].note != this.controller[84] || this.voices[n5].releaseTriggered) continue;
                        this.voices[n5].portamento = true;
                        this.voices[n5].setNote(n);
                        n4 = 1;
                    }
                    this.controlChange(84, 0);
                    if (n4 != 0) {
                        return;
                    }
                }
            }
            if (this.mono) {
                this.allNotesOff();
            }
            if (this.current_instrument == null) {
                this.current_instrument = this.synthesizer.findInstrument(this.program, this.bank, this.channel);
                if (this.current_instrument == null) {
                    return;
                }
                if (this.current_mixer != null) {
                    this.mainmixer.stopMixer(this.current_mixer);
                }
                this.current_mixer = this.current_instrument.getSourceInstrument().getChannelMixer(this, this.synthesizer.getFormat());
                if (this.current_mixer != null) {
                    this.mainmixer.registerMixer(this.current_mixer);
                }
                this.current_director = this.current_instrument.getDirector(this, this);
                this.applyInstrumentCustomization();
            }
            this.prevVoiceID = this.synthesizer.voiceIDCounter++;
            this.firstVoice = true;
            this.voiceNo = 0;
            n4 = (int)Math.round(this.tuning.getTuning()[n] / 100.0);
            this.play_noteNumber = n;
            this.play_velocity = n2;
            this.play_delay = n3;
            this.play_releasetriggered = false;
            this.lastVelocity[n] = n2;
            this.current_director.noteOn(n4, n2);
        }
    }

    @Override
    public void noteOff(int n, int n2) {
        n = SoftChannel.restrict7Bit(n);
        n2 = SoftChannel.restrict7Bit(n2);
        this.noteOff_internal(n, n2);
        if (this.current_mixer != null) {
            this.current_mixer.noteOff(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOff_internal(int n, int n2) {
        Object object = this.control_mutex;
        synchronized (object) {
            int n3;
            if (!this.mono && this.portamento && this.portamento_lastnote_ix != 127) {
                this.portamento_lastnote[this.portamento_lastnote_ix] = n;
                ++this.portamento_lastnote_ix;
            }
            this.mainmixer.activity();
            for (n3 = 0; n3 < this.voices.length; ++n3) {
                if (this.voices[n3].on && this.voices[n3].channel == this.channel && this.voices[n3].note == n && !this.voices[n3].releaseTriggered) {
                    this.voices[n3].noteOff(n2);
                }
                if (this.voices[n3].stealer_channel != this || this.voices[n3].stealer_noteNumber != n) continue;
                SoftVoice softVoice = this.voices[n3];
                softVoice.stealer_releaseTriggered = false;
                softVoice.stealer_channel = null;
                softVoice.stealer_performer = null;
                softVoice.stealer_voiceID = -1;
                softVoice.stealer_noteNumber = 0;
                softVoice.stealer_velocity = 0;
                softVoice.stealer_extendedConnectionBlocks = null;
                softVoice.stealer_channelmixer = null;
            }
            if (this.current_instrument == null) {
                this.current_instrument = this.synthesizer.findInstrument(this.program, this.bank, this.channel);
                if (this.current_instrument == null) {
                    return;
                }
                if (this.current_mixer != null) {
                    this.mainmixer.stopMixer(this.current_mixer);
                }
                this.current_mixer = this.current_instrument.getSourceInstrument().getChannelMixer(this, this.synthesizer.getFormat());
                if (this.current_mixer != null) {
                    this.mainmixer.registerMixer(this.current_mixer);
                }
                this.current_director = this.current_instrument.getDirector(this, this);
                this.applyInstrumentCustomization();
            }
            this.prevVoiceID = this.synthesizer.voiceIDCounter++;
            this.firstVoice = true;
            this.voiceNo = 0;
            n3 = (int)Math.round(this.tuning.getTuning()[n] / 100.0);
            this.play_noteNumber = n;
            this.play_velocity = this.lastVelocity[n];
            this.play_releasetriggered = true;
            this.play_delay = 0;
            this.current_director.noteOff(n3, n2);
        }
    }

    @Override
    public void play(int n, ModelConnectionBlock[] modelConnectionBlockArray) {
        int n2 = this.play_noteNumber;
        int n3 = this.play_velocity;
        int n4 = this.play_delay;
        boolean bl = this.play_releasetriggered;
        SoftPerformer softPerformer = this.current_instrument.getPerformers()[n];
        if (this.firstVoice) {
            this.firstVoice = false;
            if (softPerformer.exclusiveClass != 0) {
                int n5 = softPerformer.exclusiveClass;
                for (int i = 0; i < this.voices.length; ++i) {
                    if (!this.voices[i].active || this.voices[i].channel != this.channel || this.voices[i].exclusiveClass != n5 || softPerformer.selfNonExclusive && this.voices[i].note == n2) continue;
                    this.voices[i].shutdown();
                }
            }
        }
        this.voiceNo = this.findFreeVoice(this.voiceNo);
        if (this.voiceNo == -1) {
            return;
        }
        this.initVoice(this.voices[this.voiceNo], softPerformer, this.prevVoiceID, n2, n3, n4, modelConnectionBlockArray, this.current_mixer, bl);
    }

    @Override
    public void noteOff(int n) {
        if (n < 0 || n > 127) {
            return;
        }
        this.noteOff_internal(n, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPolyPressure(int n, int n2) {
        n = SoftChannel.restrict7Bit(n);
        n2 = SoftChannel.restrict7Bit(n2);
        if (this.current_mixer != null) {
            this.current_mixer.setPolyPressure(n, n2);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi[n].get((int)0, (String)"poly_pressure")[0] = (double)n2 * 0.0078125;
            this.polypressure[n] = n2;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].note != n) continue;
                this.voices[i].setPolyPressure(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPolyPressure(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.polypressure[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChannelPressure(int n) {
        n = SoftChannel.restrict7Bit(n);
        if (this.current_mixer != null) {
            this.current_mixer.setChannelPressure(n);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi_channel_pressure[0] = (double)n * 0.0078125;
            this.channelpressure = n;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].setChannelPressure(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChannelPressure() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.channelpressure;
        }
    }

    protected void applyInstrumentCustomization() {
        if (this.cds_control_connections == null && this.cds_channelpressure_connections == null && this.cds_polypressure_connections == null) {
            return;
        }
        ModelInstrument modelInstrument = this.current_instrument.getSourceInstrument();
        ModelPerformer[] modelPerformerArray = modelInstrument.getPerformers();
        ModelPerformer[] modelPerformerArray2 = new ModelPerformer[modelPerformerArray.length];
        for (int i = 0; i < modelPerformerArray2.length; ++i) {
            int n;
            Object object;
            Iterator<ModelConnectionBlock> iterator;
            ModelPerformer modelPerformer = modelPerformerArray[i];
            ModelPerformer modelPerformer2 = new ModelPerformer();
            modelPerformer2.setName(modelPerformer.getName());
            modelPerformer2.setExclusiveClass(modelPerformer.getExclusiveClass());
            modelPerformer2.setKeyFrom(modelPerformer.getKeyFrom());
            modelPerformer2.setKeyTo(modelPerformer.getKeyTo());
            modelPerformer2.setVelFrom(modelPerformer.getVelFrom());
            modelPerformer2.setVelTo(modelPerformer.getVelTo());
            modelPerformer2.getOscillators().addAll(modelPerformer.getOscillators());
            modelPerformer2.getConnectionBlocks().addAll(modelPerformer.getConnectionBlocks());
            modelPerformerArray2[i] = modelPerformer2;
            List<ModelConnectionBlock> list = modelPerformer2.getConnectionBlocks();
            if (this.cds_control_connections != null) {
                iterator = Integer.toString(this.cds_control_number);
                object = list.iterator();
                while (object.hasNext()) {
                    ModelConnectionBlock modelConnectionBlock = object.next();
                    ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
                    n = 0;
                    if (modelSourceArray != null) {
                        for (int j = 0; j < modelSourceArray.length; ++j) {
                            ModelSource modelSource = modelSourceArray[j];
                            if (!"midi_cc".equals(modelSource.getIdentifier().getObject()) || !((String)((Object)iterator)).equals(modelSource.getIdentifier().getVariable())) continue;
                            n = 1;
                        }
                    }
                    if (n == 0) continue;
                    object.remove();
                }
                for (int j = 0; j < this.cds_control_connections.length; ++j) {
                    list.add(this.cds_control_connections[j]);
                }
            }
            if (this.cds_polypressure_connections != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ModelSource[] modelSourceArray = ((ModelConnectionBlock)object).getSources();
                    boolean bl = false;
                    if (modelSourceArray != null) {
                        for (n = 0; n < modelSourceArray.length; ++n) {
                            ModelSource modelSource = modelSourceArray[n];
                            if (!"midi".equals(modelSource.getIdentifier().getObject()) || !"poly_pressure".equals(modelSource.getIdentifier().getVariable())) continue;
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    iterator.remove();
                }
                for (int j = 0; j < this.cds_polypressure_connections.length; ++j) {
                    list.add(this.cds_polypressure_connections[j]);
                }
            }
            if (this.cds_channelpressure_connections == null) continue;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ModelSource[] modelSourceArray = ((ModelConnectionBlock)object).getSources();
                boolean bl = false;
                if (modelSourceArray != null) {
                    for (n = 0; n < modelSourceArray.length; ++n) {
                        ModelIdentifier modelIdentifier = modelSourceArray[n].getIdentifier();
                        if (!"midi".equals(modelIdentifier.getObject()) || !"channel_pressure".equals(modelIdentifier.getVariable())) continue;
                        bl = true;
                    }
                }
                if (!bl) continue;
                iterator.remove();
            }
            for (int j = 0; j < this.cds_channelpressure_connections.length; ++j) {
                list.add(this.cds_channelpressure_connections[j]);
            }
        }
        this.current_instrument = new SoftInstrument(modelInstrument, modelPerformerArray2);
    }

    private ModelConnectionBlock[] createModelConnections(ModelIdentifier modelIdentifier, int[] nArray, int[] nArray2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nArray.length; ++i) {
            ModelConnectionBlock modelConnectionBlock;
            Object object;
            double d;
            int n = nArray[i];
            int n2 = nArray2[i];
            if (n == 0) {
                d = (n2 - 64) * 100;
                object = new ModelConnectionBlock(new ModelSource(modelIdentifier, false, false, 0), d, new ModelDestination(new ModelIdentifier("osc", "pitch")));
                arrayList.add(object);
            }
            if (n == 1) {
                d = ((double)n2 / 64.0 - 1.0) * 9600.0;
                object = d > 0.0 ? new ModelConnectionBlock(new ModelSource(modelIdentifier, true, false, 0), -d, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ)) : new ModelConnectionBlock(new ModelSource(modelIdentifier, false, false, 0), d, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
                arrayList.add(object);
            }
            if (n == 2) {
                d = (double)n2 / 64.0;
                object = new ModelTransform(){
                    double s;
                    {
                        this.s = d;
                    }

                    @Override
                    public double transform(double d2) {
                        if (this.s < 1.0) {
                            d2 = this.s + d2 * (1.0 - this.s);
                        } else if (this.s > 1.0) {
                            d2 = 1.0 + d2 * (this.s - 1.0);
                        } else {
                            return 0.0;
                        }
                        return -(0.4166666666666667 / Math.log(10.0)) * Math.log(d2);
                    }
                };
                modelConnectionBlock = new ModelConnectionBlock(new ModelSource(modelIdentifier, (ModelTransform)object), -960.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
                arrayList.add(modelConnectionBlock);
            }
            if (n == 3) {
                d = ((double)n2 / 64.0 - 1.0) * 9600.0;
                object = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(modelIdentifier, false, false, 0), d, new ModelDestination(ModelDestination.DESTINATION_PITCH));
                arrayList.add(object);
            }
            if (n == 4) {
                d = (double)n2 / 128.0 * 2400.0;
                object = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(modelIdentifier, false, false, 0), d, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
                arrayList.add(object);
            }
            if (n != 5) continue;
            d = (double)n2 / 127.0;
            object = new ModelTransform(){
                double s;
                {
                    this.s = d;
                }

                @Override
                public double transform(double d2) {
                    return -(0.4166666666666667 / Math.log(10.0)) * Math.log(1.0 - d2 * this.s);
                }
            };
            modelConnectionBlock = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, false, 0), new ModelSource(modelIdentifier, (ModelTransform)object), -960.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
            arrayList.add(modelConnectionBlock);
        }
        return arrayList.toArray(new ModelConnectionBlock[arrayList.size()]);
    }

    public void mapPolyPressureToDestination(int[] nArray, int[] nArray2) {
        this.current_instrument = null;
        if (nArray.length == 0) {
            this.cds_polypressure_connections = null;
            return;
        }
        this.cds_polypressure_connections = this.createModelConnections(new ModelIdentifier("midi", "poly_pressure"), nArray, nArray2);
    }

    public void mapChannelPressureToDestination(int[] nArray, int[] nArray2) {
        this.current_instrument = null;
        if (nArray.length == 0) {
            this.cds_channelpressure_connections = null;
            return;
        }
        this.cds_channelpressure_connections = this.createModelConnections(new ModelIdentifier("midi", "channel_pressure"), nArray, nArray2);
    }

    public void mapControlToDestination(int n, int[] nArray, int[] nArray2) {
        if (!(n >= 1 && n <= 31 || n >= 64 && n <= 95)) {
            this.cds_control_connections = null;
            return;
        }
        this.current_instrument = null;
        this.cds_control_number = n;
        if (nArray.length == 0) {
            this.cds_control_connections = null;
            return;
        }
        this.cds_control_connections = this.createModelConnections(new ModelIdentifier("midi_cc", Integer.toString(n)), nArray, nArray2);
    }

    public void controlChangePerNote(int n, int n2, int n3) {
        block8: {
            block9: {
                block7: {
                    if (this.keybasedcontroller_active == null) {
                        this.keybasedcontroller_active = new boolean[128][];
                        this.keybasedcontroller_value = new double[128][];
                    }
                    if (this.keybasedcontroller_active[n] == null) {
                        this.keybasedcontroller_active[n] = new boolean[128];
                        Arrays.fill(this.keybasedcontroller_active[n], false);
                        this.keybasedcontroller_value[n] = new double[128];
                        Arrays.fill(this.keybasedcontroller_value[n], 0.0);
                    }
                    if (n3 == -1) {
                        this.keybasedcontroller_active[n][n2] = false;
                    } else {
                        this.keybasedcontroller_active[n][n2] = true;
                        this.keybasedcontroller_value[n][n2] = (double)n3 / 128.0;
                    }
                    if (n2 >= 120) break block7;
                    for (int i = 0; i < this.voices.length; ++i) {
                        if (!this.voices[i].active) continue;
                        this.voices[i].controlChange(n2, -1);
                    }
                    break block8;
                }
                if (n2 != 120) break block9;
                for (int i = 0; i < this.voices.length; ++i) {
                    if (!this.voices[i].active) continue;
                    this.voices[i].rpnChange(1, -1);
                }
                break block8;
            }
            if (n2 != 121) break block8;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].rpnChange(2, -1);
            }
        }
    }

    public int getControlPerNote(int n, int n2) {
        if (this.keybasedcontroller_active == null) {
            return -1;
        }
        if (this.keybasedcontroller_active[n] == null) {
            return -1;
        }
        if (!this.keybasedcontroller_active[n][n2]) {
            return -1;
        }
        return (int)(this.keybasedcontroller_value[n][n2] * 128.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controlChange(int n, int n2) {
        n = SoftChannel.restrict7Bit(n);
        n2 = SoftChannel.restrict7Bit(n2);
        if (this.current_mixer != null) {
            this.current_mixer.controlChange(n, n2);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            switch (n) {
                case 5: {
                    double d = -Math.asin((double)n2 / 128.0 * 2.0 - 1.0) / Math.PI + 0.5;
                    d = Math.pow(100000.0, d) / 100.0;
                    d /= 100.0;
                    d *= 1000.0;
                    this.portamento_time = d /= (double)this.synthesizer.getControlRate();
                    break;
                }
                case 6: 
                case 38: 
                case 96: 
                case 97: {
                    int[] nArray;
                    int n3 = 0;
                    if (this.nrpn_control != 16383 && (nArray = this.co_midi_nrpn_nrpn_i.get(this.nrpn_control)) != null) {
                        n3 = nArray[0];
                    }
                    if (this.rpn_control != 16383 && (nArray = this.co_midi_rpn_rpn_i.get(this.rpn_control)) != null) {
                        n3 = nArray[0];
                    }
                    if (n == 6) {
                        n3 = (n3 & 0x7F) + (n2 << 7);
                    } else if (n == 38) {
                        n3 = (n3 & 0x3F80) + n2;
                    } else if (n == 96 || n == 97) {
                        int n4 = 1;
                        if (this.rpn_control == 2 || this.rpn_control == 3 || this.rpn_control == 4) {
                            n4 = 128;
                        }
                        if (n == 96) {
                            n3 += n4;
                        }
                        if (n == 97) {
                            n3 -= n4;
                        }
                    }
                    if (this.nrpn_control != 16383) {
                        this.nrpnChange(this.nrpn_control, n3);
                    }
                    if (this.rpn_control == 16383) break;
                    this.rpnChange(this.rpn_control, n3);
                    break;
                }
                case 64: {
                    int n5;
                    boolean bl;
                    boolean bl2 = bl = n2 >= 64;
                    if (this.sustain == bl) break;
                    this.sustain = bl;
                    if (!bl) {
                        for (n5 = 0; n5 < this.voices.length; ++n5) {
                            if (!this.voices[n5].active || !this.voices[n5].sustain || this.voices[n5].channel != this.channel) continue;
                            this.voices[n5].sustain = false;
                            if (this.voices[n5].on) continue;
                            this.voices[n5].on = true;
                            this.voices[n5].noteOff(0);
                        }
                    } else {
                        for (n5 = 0; n5 < this.voices.length; ++n5) {
                            if (!this.voices[n5].active || this.voices[n5].channel != this.channel) continue;
                            this.voices[n5].redamp();
                        }
                    }
                    break;
                }
                case 65: {
                    this.portamento = n2 >= 64;
                    this.portamento_lastnote[0] = -1;
                    this.portamento_lastnote_ix = 0;
                    break;
                }
                case 66: {
                    boolean bl;
                    int n5;
                    boolean bl3 = bl = n2 >= 64;
                    if (bl) {
                        for (n5 = 0; n5 < this.voices.length; ++n5) {
                            if (!this.voices[n5].active || !this.voices[n5].on || this.voices[n5].channel != this.channel) continue;
                            this.voices[n5].sostenuto = true;
                        }
                    }
                    if (bl) break;
                    for (n5 = 0; n5 < this.voices.length; ++n5) {
                        if (!this.voices[n5].active || !this.voices[n5].sostenuto || this.voices[n5].channel != this.channel) continue;
                        this.voices[n5].sostenuto = false;
                        if (this.voices[n5].on) continue;
                        this.voices[n5].on = true;
                        this.voices[n5].noteOff(0);
                    }
                    break;
                }
                case 98: {
                    this.nrpn_control = (this.nrpn_control & 0x3F80) + n2;
                    this.rpn_control = 16383;
                    break;
                }
                case 99: {
                    this.nrpn_control = (this.nrpn_control & 0x7F) + (n2 << 7);
                    this.rpn_control = 16383;
                    break;
                }
                case 100: {
                    this.rpn_control = (this.rpn_control & 0x3F80) + n2;
                    this.nrpn_control = 16383;
                    break;
                }
                case 101: {
                    this.rpn_control = (this.rpn_control & 0x7F) + (n2 << 7);
                    this.nrpn_control = 16383;
                    break;
                }
                case 120: {
                    this.allSoundOff();
                    break;
                }
                case 121: {
                    this.resetAllControllers(n2 == 127);
                    break;
                }
                case 122: {
                    this.localControl(n2 >= 64);
                    break;
                }
                case 123: {
                    this.allNotesOff();
                    break;
                }
                case 124: {
                    this.setOmni(false);
                    break;
                }
                case 125: {
                    this.setOmni(true);
                    break;
                }
                case 126: {
                    if (n2 != 1) break;
                    this.setMono(true);
                    break;
                }
                case 127: {
                    this.setMono(false);
                    break;
                }
            }
            this.co_midi_cc_cc[n][0] = (double)n2 * 0.0078125;
            if (n == 0) {
                this.bank = n2 << 7;
                return;
            }
            if (n == 32) {
                this.bank = (this.bank & 0x3F80) + n2;
                return;
            }
            this.controller[n] = n2;
            if (n < 32) {
                this.controller[n + 32] = 0;
            }
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].controlChange(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getController(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.controller[n] & 0x7F;
        }
    }

    public void tuningChange(int n) {
        this.tuningChange(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tuningChange(int n, int n2) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.tuning = this.synthesizer.getTuning(new Patch(n, n2));
        }
    }

    @Override
    public void programChange(int n) {
        this.programChange(this.bank, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void programChange(int n, int n2) {
        n = SoftChannel.restrict14Bit(n);
        n2 = SoftChannel.restrict7Bit(n2);
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            if (this.bank != n || this.program != n2) {
                this.bank = n;
                this.program = n2;
                this.current_instrument = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProgram() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPitchBend(int n) {
        n = SoftChannel.restrict14Bit(n);
        if (this.current_mixer != null) {
            this.current_mixer.setPitchBend(n);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi_pitch[0] = (double)n * 6.103515625E-5;
            this.pitchbend = n;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].setPitchBend(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPitchBend() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.pitchbend;
        }
    }

    public void nrpnChange(int n, int n2) {
        if (this.synthesizer.getGeneralMidiMode() == 0) {
            if (n == 136) {
                this.controlChange(76, n2 >> 7);
            }
            if (n == 137) {
                this.controlChange(77, n2 >> 7);
            }
            if (n == 138) {
                this.controlChange(78, n2 >> 7);
            }
            if (n == 160) {
                this.controlChange(74, n2 >> 7);
            }
            if (n == 161) {
                this.controlChange(71, n2 >> 7);
            }
            if (n == 227) {
                this.controlChange(73, n2 >> 7);
            }
            if (n == 228) {
                this.controlChange(75, n2 >> 7);
            }
            if (n == 230) {
                this.controlChange(72, n2 >> 7);
            }
            if (n >> 7 == 24) {
                this.controlChangePerNote(n % 128, 120, n2 >> 7);
            }
            if (n >> 7 == 26) {
                this.controlChangePerNote(n % 128, 7, n2 >> 7);
            }
            if (n >> 7 == 28) {
                this.controlChangePerNote(n % 128, 10, n2 >> 7);
            }
            if (n >> 7 == 29) {
                this.controlChangePerNote(n % 128, 91, n2 >> 7);
            }
            if (n >> 7 == 30) {
                this.controlChangePerNote(n % 128, 93, n2 >> 7);
            }
        }
        int[] nArray = this.co_midi_nrpn_nrpn_i.get(n);
        double[] dArray = this.co_midi_nrpn_nrpn.get(n);
        if (nArray == null) {
            nArray = new int[1];
            this.co_midi_nrpn_nrpn_i.put(n, nArray);
        }
        if (dArray == null) {
            dArray = new double[1];
            this.co_midi_nrpn_nrpn.put(n, dArray);
        }
        nArray[0] = n2;
        dArray[0] = (double)nArray[0] * 6.103515625E-5;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].active) continue;
            this.voices[i].nrpnChange(n, nArray[0]);
        }
    }

    public void rpnChange(int n, int n2) {
        if (n == 3) {
            this.tuning_program = n2 >> 7 & 0x7F;
            this.tuningChange(this.tuning_bank, this.tuning_program);
        }
        if (n == 4) {
            this.tuning_bank = n2 >> 7 & 0x7F;
        }
        int[] nArray = this.co_midi_rpn_rpn_i.get(n);
        double[] dArray = this.co_midi_rpn_rpn.get(n);
        if (nArray == null) {
            nArray = new int[1];
            this.co_midi_rpn_rpn_i.put(n, nArray);
        }
        if (dArray == null) {
            dArray = new double[1];
            this.co_midi_rpn_rpn.put(n, dArray);
        }
        nArray[0] = n2;
        dArray[0] = (double)nArray[0] * 6.103515625E-5;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].active) continue;
            this.voices[i].rpnChange(n, nArray[0]);
        }
    }

    @Override
    public void resetAllControllers() {
        this.resetAllControllers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllControllers(boolean bl) {
        Object object = this.control_mutex;
        synchronized (object) {
            int n;
            this.mainmixer.activity();
            for (n = 0; n < 128; ++n) {
                this.setPolyPressure(n, 0);
            }
            this.setChannelPressure(0);
            this.setPitchBend(8192);
            for (n = 0; n < 128; ++n) {
                if (dontResetControls[n]) continue;
                this.controlChange(n, 0);
            }
            this.controlChange(71, 64);
            this.controlChange(72, 64);
            this.controlChange(73, 64);
            this.controlChange(74, 64);
            this.controlChange(75, 64);
            this.controlChange(76, 64);
            this.controlChange(77, 64);
            this.controlChange(78, 64);
            this.controlChange(8, 64);
            this.controlChange(11, 127);
            this.controlChange(98, 127);
            this.controlChange(99, 127);
            this.controlChange(100, 127);
            this.controlChange(101, 127);
            if (bl) {
                this.keybasedcontroller_active = null;
                this.keybasedcontroller_value = null;
                this.controlChange(7, 100);
                this.controlChange(10, 64);
                this.controlChange(91, 40);
                for (int n2 : this.co_midi_rpn_rpn.keySet()) {
                    if (n2 == 3 || n2 == 4) continue;
                    this.rpnChange(n2, 0);
                }
                for (int n2 : this.co_midi_nrpn_nrpn.keySet()) {
                    this.nrpnChange(n2, 0);
                }
                this.rpnChange(0, 256);
                this.rpnChange(1, 8192);
                this.rpnChange(2, 8192);
                this.rpnChange(5, 64);
                this.tuning_bank = 0;
                this.tuning_program = 0;
                this.tuning = new SoftTuning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allNotesOff() {
        if (this.current_mixer != null) {
            this.current_mixer.allNotesOff();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].on || this.voices[i].channel != this.channel || this.voices[i].releaseTriggered) continue;
                this.voices[i].noteOff(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allSoundOff() {
        if (this.current_mixer != null) {
            this.current_mixer.allSoundOff();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].on || this.voices[i].channel != this.channel) continue;
                this.voices[i].soundOff();
            }
        }
    }

    @Override
    public boolean localControl(boolean bl) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMono(boolean bl) {
        if (this.current_mixer != null) {
            this.current_mixer.setMono(bl);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.allNotesOff();
            this.mono = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMono() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mono;
        }
    }

    @Override
    public void setOmni(boolean bl) {
        if (this.current_mixer != null) {
            this.current_mixer.setOmni(bl);
        }
        this.allNotesOff();
    }

    @Override
    public boolean getOmni() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMute(boolean bl) {
        if (this.current_mixer != null) {
            this.current_mixer.setMute(bl);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mute = bl;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].channel != this.channel) continue;
                this.voices[i].setMute(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMute() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSolo(boolean bl) {
        if (this.current_mixer != null) {
            this.current_mixer.setSolo(bl);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.solo = bl;
            boolean bl2 = false;
            for (SoftChannel softChannel : this.synthesizer.channels) {
                if (!softChannel.solo) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                for (SoftChannel softChannel : this.synthesizer.channels) {
                    softChannel.setSoloMute(false);
                }
                return;
            }
            for (SoftChannel softChannel : this.synthesizer.channels) {
                softChannel.setSoloMute(!softChannel.solo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSoloMute(boolean bl) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.solomute == bl) {
                return;
            }
            this.solomute = bl;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].channel != this.channel) continue;
                this.voices[i].setSoloMute(this.solomute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSolo() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.solo;
        }
    }

    static {
        for (int i = 0; i < dontResetControls.length; ++i) {
            SoftChannel.dontResetControls[i] = false;
        }
        SoftChannel.dontResetControls[0] = true;
        SoftChannel.dontResetControls[32] = true;
        SoftChannel.dontResetControls[7] = true;
        SoftChannel.dontResetControls[8] = true;
        SoftChannel.dontResetControls[10] = true;
        SoftChannel.dontResetControls[11] = true;
        SoftChannel.dontResetControls[91] = true;
        SoftChannel.dontResetControls[92] = true;
        SoftChannel.dontResetControls[93] = true;
        SoftChannel.dontResetControls[94] = true;
        SoftChannel.dontResetControls[95] = true;
        SoftChannel.dontResetControls[70] = true;
        SoftChannel.dontResetControls[71] = true;
        SoftChannel.dontResetControls[72] = true;
        SoftChannel.dontResetControls[73] = true;
        SoftChannel.dontResetControls[74] = true;
        SoftChannel.dontResetControls[75] = true;
        SoftChannel.dontResetControls[76] = true;
        SoftChannel.dontResetControls[77] = true;
        SoftChannel.dontResetControls[78] = true;
        SoftChannel.dontResetControls[79] = true;
        SoftChannel.dontResetControls[120] = true;
        SoftChannel.dontResetControls[121] = true;
        SoftChannel.dontResetControls[122] = true;
        SoftChannel.dontResetControls[123] = true;
        SoftChannel.dontResetControls[124] = true;
        SoftChannel.dontResetControls[125] = true;
        SoftChannel.dontResetControls[126] = true;
        SoftChannel.dontResetControls[127] = true;
        SoftChannel.dontResetControls[6] = true;
        SoftChannel.dontResetControls[38] = true;
        SoftChannel.dontResetControls[96] = true;
        SoftChannel.dontResetControls[97] = true;
        SoftChannel.dontResetControls[98] = true;
        SoftChannel.dontResetControls[99] = true;
        SoftChannel.dontResetControls[100] = true;
        SoftChannel.dontResetControls[101] = true;
    }

    private class MidiControlObject
    implements SoftControl {
        double[] pitch;
        double[] channel_pressure;
        double[] poly_pressure;

        private MidiControlObject() {
            this.pitch = SoftChannel.this.co_midi_pitch;
            this.channel_pressure = SoftChannel.this.co_midi_channel_pressure;
            this.poly_pressure = new double[1];
        }

        @Override
        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("pitch")) {
                return this.pitch;
            }
            if (string.equals("channel_pressure")) {
                return this.channel_pressure;
            }
            if (string.equals("poly_pressure")) {
                return this.poly_pressure;
            }
            return null;
        }
    }
}

