/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

class RemoveRedundantEscapeAction
implements IntentionAction {
    private final RegExpChar myChar;

    public RemoveRedundantEscapeAction(RegExpChar ch) {
        this.myChar = ch;
    }

    @NotNull
    public String getText() {
        if ("Remove Redundant Escape" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction.getText must not return null");
        }
        return "Remove Redundant Escape";
    }

    @NotNull
    public String getFamilyName() {
        if ("Redundant Character Escape" == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction.getFamilyName must not return null");
        }
        return "Redundant Character Escape";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction.isAvailable must not be null");
        }
        return this.myChar.isValid() && this.myChar.getUnescapedText().startsWith("\\");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/lang/regexp/validation/RemoveRedundantEscapeAction.invoke must not be null");
        }
        Character v = this.myChar.getValue();
        assert (v != null);
        ASTNode node = this.myChar.getNode().getFirstChildNode();
        ASTNode parent = node.getTreeParent();
        parent.addLeaf(RegExpTT.CHARACTER, (CharSequence)this.replacement(v), node);
        parent.removeChild(node);
    }

    private String replacement(Character v) {
        PsiElement context = this.myChar.getContainingFile().getContext();
        return RegExpElementImpl.isLiteralExpression(context) ? StringUtil.escapeStringCharacters((String)v.toString()) : (context instanceof XmlElement ? XmlStringUtil.escapeString((String)v.toString()) : v.toString());
    }

    public boolean startInWriteAction() {
        return true;
    }
}

