/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.psi.PsiElement;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsPsiItem
extends BreadcrumbsItem {
    private final PsiElement myElement;
    private final BreadcrumbsInfoProvider myProvider;

    public BreadcrumbsPsiItem(@NotNull PsiElement element, @NotNull BreadcrumbsInfoProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsPsiItem.<init> must not be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/breadcrumbs/BreadcrumbsPsiItem.<init> must not be null");
        }
        this.myElement = element;
        this.myProvider = provider;
    }

    public String getDisplayText() {
        return this.isValid() ? this.myProvider.getElementInfo(this.myElement) : "INVALID";
    }

    public String getTooltip() {
        String s = this.isValid() ? this.myProvider.getElementTooltip(this.myElement) : "";
        return s == null ? "" : s;
    }

    public boolean isValid() {
        return this.myElement != null && this.myElement.isValid();
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }
}

