/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.actions.ViewBreakpointsAction;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XLineBreakpointImpl<P extends XBreakpointProperties>
extends XBreakpointBase<XLineBreakpoint<P>, P, LineBreakpointState<P>>
implements XLineBreakpoint<P> {
    @Nullable
    private RangeHighlighter myHighlighter;
    private final XLineBreakpointType<P> myType;
    private Icon myIcon;
    private XSourcePosition mySourcePosition;
    @NonNls
    private static final String BR_NBSP = "<br>&nbsp;";
    private boolean myDisposed;
    private CustomizedBreakpointPresentation myCustomizedPresentation;

    public XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, String url, int line, @Nullable P properties) {
        super(type, breakpointManager, properties, new LineBreakpointState(true, type.getId(), url, line));
        this.myType = type;
    }

    private XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, LineBreakpointState<P> breakpointState) {
        super(type, breakpointManager, breakpointState);
        this.myType = type;
    }

    public void updateUI() {
        if (this.myDisposed) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        this.removeHighlighter();
        MarkupModelEx markupModel = (MarkupModelEx)document.getMarkupModel(this.getProject());
        RangeHighlighter highlighter = markupModel.addPersistentLineHighlighter(this.getLine(), 2001, attributes);
        if (highlighter != null) {
            this.updateIcon();
            this.setupGutterRenderer(highlighter);
        }
        this.myHighlighter = highlighter;
    }

    @Nullable
    public Document getDocument() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Nullable
    private VirtualFile getFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.getFileUrl());
    }

    private void setupGutterRenderer(RangeHighlighter highlighter) {
        highlighter.setGutterIconRenderer((GutterIconRenderer)new BreakpointGutterIconRenderer());
    }

    @NotNull
    public XLineBreakpointType<P> getType() {
        XLineBreakpointType<P> xLineBreakpointType = this.myType;
        if (xLineBreakpointType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.getType must not return null");
        }
        return xLineBreakpointType;
    }

    private void updateIcon() {
        this.myIcon = this.calculateIcon();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Icon calculateIcon() {
        Icon icon;
        Icon icon2;
        if (!this.isEnabled()) {
            icon2 = this.myType.getDisabledIcon();
            if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
            return icon2;
        }
        XDebugSessionImpl session = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (session == null) {
            if (this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this) != null) {
                icon2 = this.myType.getDisabledDependentIcon();
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
                return icon2;
            }
        } else {
            Icon icon3;
            if (session.areBreakpointsMuted()) {
                icon2 = this.myType.getDisabledIcon();
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
                return icon2;
            }
            if (session.isDisabledSlaveBreakpoint(this)) {
                icon2 = this.myType.getDisabledDependentIcon();
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
                return icon2;
            }
            CustomizedBreakpointPresentation presentation = session.getBreakpointPresentation(this);
            if (presentation != null && (icon3 = presentation.getIcon()) != null) {
                icon2 = icon3;
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
                return icon2;
            }
        }
        if (this.myCustomizedPresentation != null && (icon = this.myCustomizedPresentation.getIcon()) != null) {
            icon2 = icon;
            if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
            return icon2;
        }
        icon2 = this.myType.getEnabledIcon();
        if (icon2 != null) return icon2;
        throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl.calculateIcon must not return null");
    }

    public int getLine() {
        return ((LineBreakpointState)this.myState).getLine();
    }

    public String getFileUrl() {
        return ((LineBreakpointState)this.myState).getFileUrl();
    }

    public String getPresentableFilePath() {
        String url = this.getFileUrl();
        if (url != null && "file".equals(VirtualFileManager.extractProtocol((String)url))) {
            return FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)url));
        }
        return url != null ? url : "";
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myHighlighter;
    }

    @Override
    public XSourcePosition getSourcePosition() {
        if (this.mySourcePosition == null) {
            new ReadAction(){

                protected void run(Result result) {
                    XLineBreakpointImpl.this.mySourcePosition = XSourcePositionImpl.create(XLineBreakpointImpl.this.getFile(), XLineBreakpointImpl.this.getLine());
                }
            }.execute();
        }
        return this.mySourcePosition;
    }

    @Override
    public boolean isValid() {
        return this.myHighlighter != null && this.myHighlighter.isValid();
    }

    @Override
    public void dispose() {
        this.removeHighlighter();
        this.myDisposed = true;
    }

    private void removeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighter.getDocument().getMarkupModel(this.getProject()).removeHighlighter(this.myHighlighter);
            this.myHighlighter = null;
        }
    }

    private Icon getIcon() {
        if (this.myIcon == null) {
            this.updateIcon();
        }
        return this.myIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            XBreakpoint<?> masterBreakpoint;
            String logExpression;
            SuspendPolicy suspendPolicy;
            builder.append("<html><body>");
            builder.append(this.myType.getDisplayText((XLineBreakpoint)this));
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null) {
                builder.append(BR_NBSP);
                builder.append("<font color=\"red\">");
                builder.append(errorMessage);
                builder.append("</font>");
            }
            if ((suspendPolicy = this.getSuspendPolicy()) == SuspendPolicy.THREAD) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.thread", (Object[])new Object[0]));
            } else if (suspendPolicy == SuspendPolicy.NONE) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.none", (Object[])new Object[0]));
            }
            String condition = this.getCondition();
            if (condition != null) {
                builder.append(BR_NBSP);
                builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.condition", (Object[])new Object[0]));
                builder.append("&nbsp;");
                builder.append(condition);
            }
            if (this.isLogMessage()) {
                builder.append(BR_NBSP).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.message", (Object[])new Object[0]));
            }
            if ((logExpression = this.getLogExpression()) != null) {
                builder.append(BR_NBSP);
                builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.expression", (Object[])new Object[0]));
                builder.append("&nbsp;");
                builder.append(logExpression);
            }
            if ((masterBreakpoint = this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this)) != null) {
                builder.append(BR_NBSP);
                String str = XDebuggerBundle.message((String)"xbreakpoint.tooltip.depends.on", (Object[])new Object[0]);
                builder.append(str);
                builder.append("&nbsp;");
                builder.append(XBreakpointUtil.getDisplayText(masterBreakpoint));
            }
            builder.append("</body><html");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    private boolean canMoveTo(int line) {
        VirtualFile file = this.getFile();
        return file != null && this.myType.canPutAt(file, line, this.getProject());
    }

    @Nullable
    private String getErrorMessage() {
        String message;
        CustomizedBreakpointPresentation presentation;
        XDebugSessionImpl currentSession = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (currentSession != null && (presentation = currentSession.getBreakpointPresentation(this)) != null && (message = presentation.getErrorMessage()) != null) {
            return message;
        }
        return this.myCustomizedPresentation != null ? this.myCustomizedPresentation.getErrorMessage() : null;
    }

    public void updatePosition() {
        if (this.myHighlighter != null && this.myHighlighter.isValid()) {
            Document document = this.myHighlighter.getDocument();
            this.setLine(document.getLineNumber(this.myHighlighter.getStartOffset()));
        }
    }

    private void setLine(int line) {
        if (this.getLine() != line) {
            ((LineBreakpointState)this.myState).setLine(line);
            this.mySourcePosition = null;
            this.fireBreakpointChanged();
        }
    }

    public void setCustomizedPresentation(CustomizedBreakpointPresentation presentation) {
        this.myCustomizedPresentation = presentation;
    }

    private class MyToggleBreakpointAction
    extends AnAction {
        private MyToggleBreakpointAction() {
            super(XLineBreakpointImpl.this.isEnabled() ? XDebuggerBundle.message((String)"xdebugger.disable.breakpoint.action.text", (Object[])new Object[0]) : XDebuggerBundle.message((String)"xdebugger.enable.breakpoint.action.text", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            XLineBreakpointImpl.this.setEnabled(!XLineBreakpointImpl.this.isEnabled());
        }
    }

    private class MyRemoveBreakpointAction
    extends AnAction {
        private MyRemoveBreakpointAction() {
            super(XDebuggerBundle.message((String)"xdebugger.remove.line.breakpoint.action.text", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e) {
            XDebuggerUtil.getInstance().removeBreakpoint(XLineBreakpointImpl.this.getProject(), (XBreakpoint)XLineBreakpointImpl.this);
        }
    }

    private class BreakpointGutterIconRenderer
    extends GutterIconRenderer {
        private BreakpointGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = XLineBreakpointImpl.this.getIcon();
            if (icon == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl$BreakpointGutterIconRenderer.getIcon must not return null");
            }
            return icon;
        }

        @Nullable
        public AnAction getClickAction() {
            return new MyRemoveBreakpointAction();
        }

        @Nullable
        public AnAction getMiddleButtonClickAction() {
            return new MyToggleBreakpointAction();
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new MyRemoveBreakpointAction());
            group.add((AnAction)new MyToggleBreakpointAction());
            for (AnAction action : XLineBreakpointImpl.this.myType.getAdditionalPopupMenuActions((XLineBreakpoint)XLineBreakpointImpl.this, XDebuggerManager.getInstance((Project)XLineBreakpointImpl.this.getProject()).getCurrentSession())) {
                group.add(action);
            }
            group.add((AnAction)new Separator());
            group.add((AnAction)new ViewBreakpointsAction(XDebuggerBundle.message((String)"xdebugger.view.breakpoint.properties.action", (Object[])new Object[0]), (Object)XLineBreakpointImpl.this));
            return group;
        }

        @Nullable
        public String getTooltipText() {
            return XLineBreakpointImpl.this.getDescription();
        }

        public GutterDraggableObject getDraggableObject() {
            return new GutterDraggableObject(){

                public void removeSelf() {
                }

                public boolean copy(int line) {
                    if (XLineBreakpointImpl.this.canMoveTo(line)) {
                        XLineBreakpointImpl.this.setLine(line);
                        return true;
                    }
                    return false;
                }

                public Cursor getCursor(int line) {
                    return XLineBreakpointImpl.this.canMoveTo(line) ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
                }
            };
        }
    }

    @Tag(value="line-breakpoint")
    public static class LineBreakpointState<P extends XBreakpointProperties>
    extends XBreakpointBase.BreakpointState<XLineBreakpoint<P>, P, XLineBreakpointType<P>> {
        private String myFileUrl;
        private int myLine;

        public LineBreakpointState() {
        }

        public LineBreakpointState(boolean enabled, String typeId, String fileUrl, int line) {
            super(enabled, typeId);
            this.myFileUrl = fileUrl;
            this.myLine = line;
        }

        @Tag(value="url")
        public String getFileUrl() {
            return this.myFileUrl;
        }

        public void setFileUrl(String fileUrl) {
            this.myFileUrl = fileUrl;
        }

        @Tag(value="line")
        public int getLine() {
            return this.myLine;
        }

        public void setLine(int line) {
            this.myLine = line;
        }

        @Override
        public XBreakpointBase<XLineBreakpoint<P>, P, ?> createBreakpoint(@NotNull XLineBreakpointType<P> type, @NotNull XBreakpointManagerImpl breakpointManager) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl$LineBreakpointState.createBreakpoint must not be null");
            }
            if (breakpointManager == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl$LineBreakpointState.createBreakpoint must not be null");
            }
            return new XLineBreakpointImpl(type, breakpointManager, this);
        }
    }
}

