/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.ElementDefinedEvent;
import com.intellij.util.xml.events.ElementUndefinedEvent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.EvaluatedXmlNameImpl;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class FileDescriptionCachedValueProvider<T extends DomElement>
implements SemElement {
    private static final Key<CachedValue<XmlFileHeader>> ROOT_TAG_NS_KEY = Key.create((String)"rootTag&ns");
    private static final UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object> ourRootTagCache = new UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object>(){

        protected CachedValue<XmlFileHeader> compute(final XmlFile file, Object o) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlFileHeader>(){

                public CachedValueProvider.Result<XmlFileHeader> compute() {
                    return new CachedValueProvider.Result((Object)DomImplUtil.getXmlFileHeader((PsiFile)file), new Object[]{file});
                }
            }, false);
        }
    };
    private final XmlFile myXmlFile;
    private volatile boolean myComputed;
    private volatile DomFileElementImpl<T> myLastResult;
    private final MyCondition myCondition = new MyCondition();
    private final DomManagerImpl myDomManager;

    public FileDescriptionCachedValueProvider(DomManagerImpl domManager, XmlFile xmlFile) {
        this.myDomManager = domManager;
        this.myXmlFile = xmlFile;
    }

    @Nullable
    public final DomFileElementImpl<T> getFileElement() {
        if (this.myComputed) {
            return this.myLastResult;
        }
        this._computeFileElement(false, this.getRootTag(), null);
        this.myXmlFile.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, this.myLastResult);
        this.myComputed = true;
        return this.myLastResult;
    }

    private void _computeFileElement(boolean fireEvents, XmlFileHeader rootTagName, @Nullable StringBuilder sb) {
        SmartList events;
        if (sb != null) {
            sb.append(rootTagName).append("\n");
        }
        if (!this.myXmlFile.isValid()) {
            this.myLastResult = null;
            return;
        }
        if (sb != null) {
            sb.append("File is valid\n");
        }
        DomFileDescription<T> description = this.findFileDescription(rootTagName, sb);
        DomFileElementImpl<T> oldValue = this.getLastValue();
        if (sb != null) {
            sb.append("last " + oldValue + "\n");
        }
        SmartList smartList = events = fireEvents ? new SmartList() : Collections.emptyList();
        if (oldValue != null && fireEvents) {
            events.add(new ElementUndefinedEvent(oldValue));
        }
        if (description == null) {
            this.myLastResult = null;
            return;
        }
        Class rootElementClass = description.getRootElementClass();
        XmlName xmlName = DomImplUtil.createXmlName(description.getRootTagName(), rootElementClass, null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl rootTagName1 = EvaluatedXmlNameImpl.createEvaluatedXmlName(xmlName, xmlName.getNamespaceKey(), false);
        this.myLastResult = new DomFileElementImpl<T>(this.myXmlFile, rootElementClass, rootTagName1, this.myDomManager, description);
        if (sb != null) {
            sb.append("success " + this.myLastResult + "\n");
        }
        if (fireEvents) {
            events.add(new ElementDefinedEvent(this.myLastResult));
        }
    }

    @Nullable
    private DomFileDescription<T> findFileDescription(XmlFileHeader rootTagName, @Nullable StringBuilder sb) {
        DomFileDescription description;
        DomFileDescription mockDescription = (DomFileDescription)this.myXmlFile.getUserData(DomManagerImpl.MOCK_DESCIPRTION);
        if (mockDescription != null) {
            return mockDescription;
        }
        if (sb != null) {
            sb.append("no mock\n");
        }
        XmlFile originalFile = (XmlFile)this.myXmlFile.getOriginalFile();
        if (sb != null) {
            sb.append("original: " + originalFile + "\n");
        }
        if (originalFile != this.myXmlFile) {
            FileDescriptionCachedValueProvider provider = this.myDomManager.getOrCreateCachedValueProvider(originalFile);
            DomFileElementImpl element = provider.getFileElement();
            if (sb != null) {
                sb.append("originalDom " + element + "\n");
            }
            return element == null ? null : element.getFileDescription();
        }
        Set<DomFileDescription> namedDescriptions = this.myDomManager.getFileDescriptions(rootTagName.getRootTagLocalName());
        if (sb != null) {
            sb.append("named " + new HashSet(namedDescriptions) + "\n");
        }
        if ((description = (DomFileDescription)ContainerUtil.find(namedDescriptions, (Condition)this.myCondition)) == null) {
            Set<DomFileDescription> unnamed = this.myDomManager.getAcceptingOtherRootTagNameDescriptions();
            description = (DomFileDescription)ContainerUtil.find(unnamed, (Condition)this.myCondition);
        }
        if (sb != null) {
            sb.append("found " + description + "\n");
        }
        return description;
    }

    @Nullable
    XmlFileHeader getRootTag() {
        return this.myXmlFile.isValid() ? (XmlFileHeader)((CachedValue)ourRootTagCache.get(ROOT_TAG_NS_KEY, (Object)this.myXmlFile, null)).getValue() : XmlFileHeader.EMPTY;
    }

    @Nullable
    final DomFileElementImpl<T> getLastValue() {
        return this.myLastResult;
    }

    public String getFileElementWithLogging() {
        XmlFileHeader rootTagName = this.getRootTag();
        StringBuilder log = new StringBuilder();
        this._computeFileElement(false, rootTagName, log);
        return log.toString();
    }

    private class MyCondition
    implements Condition<DomFileDescription> {
        public Module module;

        private MyCondition() {
        }

        public boolean value(DomFileDescription description) {
            return description.isMyFile(FileDescriptionCachedValueProvider.this.myXmlFile, this.module);
        }
    }
}

