/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomAnchorImpl<T extends DomElement>
implements DomAnchor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomAnchorImpl");

    public static <T extends DomElement> DomAnchorImpl<T> createAnchor(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomAnchorImpl.createAnchor must not be null");
        }
        DomElement parent = t.getParent();
        if (parent == null) {
            LOG.error("Parent null: " + t);
        }
        if (parent instanceof DomFileElementImpl) {
            DomFileElementImpl fileElement = (DomFileElementImpl)parent;
            return new RootAnchor(fileElement.getFile(), fileElement.getRootElementClass());
        }
        DomAnchorImpl<DomElement> parentAnchor = DomAnchorImpl.createAnchor(parent);
        String name = t.getGenericInfo().getElementName(t);
        AbstractDomChildrenDescription description = t.getChildDescription();
        if (name != null) {
            return new NamedAnchor(parentAnchor, description, name);
        }
        List values = description.getValues(parent);
        int index = values.indexOf(t);
        if (index < 0) {
            XmlTag parentTag = parent.getXmlTag();
            StringBuilder diag = new StringBuilder("Index<0: description=" + description + "\nparent=" + parent + "\nt=" + t + "\nvalues=" + values + "\n");
            if (parentTag != null) {
                diag.append("Parent tag: ").append(parentTag.getName()).append("\n");
                if (t instanceof GenericAttributeValue) {
                    for (XmlAttribute attribute : parentTag.getAttributes()) {
                        diag.append("attr: ").append(attribute.getName());
                    }
                    diag.append("\n");
                } else {
                    for (XmlTag tag : parentTag.getSubTags()) {
                        diag.append("subtag: ").append(tag.getName());
                    }
                    diag.append("\n");
                }
            }
            diag.append("Child name: ").append(t.getXmlElementName()).append(";").append(t.getXmlElementNamespaceKey());
            LOG.error((Object)diag);
        }
        return new IndexedAnchor(parentAnchor, description, index);
    }

    @Nullable
    public abstract T retrieveDomElement();

    @NotNull
    public abstract XmlFile getContainingFile();

    private static class RootAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final XmlFile myFile;
        private final Class<T> myClass;

        private RootAnchor(XmlFile file, Class<T> aClass) {
            this.myFile = file;
            this.myClass = aClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RootAnchor)) {
                return false;
            }
            RootAnchor that = (RootAnchor)o;
            if (this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null);
        }

        public int hashCode() {
            int result = this.myFile != null ? this.myFile.hashCode() : 0;
            result = 31 * result + (this.myClass != null ? this.myClass.hashCode() : 0);
            return result;
        }

        @Override
        public T retrieveDomElement() {
            DomFileElement fileElement = DomManager.getDomManager((Project)this.myFile.getProject()).getFileElement(this.myFile, this.myClass);
            return (T)(fileElement == null ? null : fileElement.getRootElement());
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myFile;
            if (xmlFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomAnchorImpl$RootAnchor.getContainingFile must not return null");
            }
            return xmlFile;
        }
    }

    private static class IndexedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchorImpl myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final int myIndex;

        private IndexedAnchor(DomAnchorImpl parent, AbstractDomChildrenDescription descr, int index) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myIndex = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedAnchor)) {
                return false;
            }
            IndexedAnchor that = (IndexedAnchor)o;
            if (this.myIndex != that.myIndex) {
                return false;
            }
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            return !(this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null);
        }

        public int hashCode() {
            int result = this.myParent != null ? this.myParent.hashCode() : 0;
            result = 31 * result + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result = 31 * result + this.myIndex;
            return result;
        }

        @Override
        public T retrieveDomElement() {
            Object parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list = this.myDescr.getValues(parent);
            if (this.myIndex < 0 || this.myIndex >= list.size()) {
                return null;
            }
            return (T)((DomElement)list.get(this.myIndex));
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomAnchorImpl$IndexedAnchor.getContainingFile must not return null");
            }
            return xmlFile;
        }
    }

    private static class NamedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchorImpl myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final String myIndex;

        private NamedAnchor(DomAnchorImpl parent, AbstractDomChildrenDescription descr, String id) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myIndex = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedAnchor)) {
                return false;
            }
            NamedAnchor that = (NamedAnchor)o;
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            if (this.myIndex != null ? !this.myIndex.equals(that.myIndex) : that.myIndex != null) {
                return false;
            }
            return !(this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null);
        }

        public int hashCode() {
            int result = this.myParent != null ? this.myParent.hashCode() : 0;
            result = 31 * result + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result = 31 * result + (this.myIndex != null ? this.myIndex.hashCode() : 0);
            return result;
        }

        @Override
        public T retrieveDomElement() {
            Object parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list = this.myDescr.getValues(parent);
            for (DomElement element : list) {
                String s = element.getGenericInfo().getElementName(element);
                if (!this.myIndex.equals(s)) continue;
                return (T)element;
            }
            return null;
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomAnchorImpl$NamedAnchor.getContainingFile must not return null");
            }
            return xmlFile;
        }
    }
}

